# January Follow-Up Sequence

Convert December seeds into January conversations. Reference previous touchpoints to create continuity.

## Pomeli Visual Assets (Optional Attachments)

| Follow-Up | Recommended Image | Path |
|-----------|-------------------|------|
| Follow-Up 1 (GRI Dropped) | Single Carriers Hit the Wall | `marketing_assets/linkedin_ads/06_single_carriers_hit_wall.png` |
| Follow-Up 2 (Math Offer) | Unified Network, Lower Price | `marketing_assets/linkedin_ads/11_unified_network_lower_price.png` |
| Follow-Up 3 (LinkedIn) | Scale Your Shipping | `marketing_assets/linkedin_ads/09_scale_your_shipping.png` |
| Follow-Up 4 (Breakup) | Faster Shipping Delivered | `marketing_assets/linkedin_ads/12_faster_shipping_delivered.png` |

*See full mapping: `marketing_assets/ASSET_MANIFEST.md`*

---

## Follow-Up Philosophy

**December touchpoints created:**
- Recognition ("oh, that's the FirstMile guy")
- Credibility ("he asked smart questions")
- Timing awareness ("he warned me about GRI")

**January follow-ups leverage:**
- "I mentioned this was coming"
- "You engaged with my post about X"
- "We talked about Y in December"

---

## Follow-Up 1: GRI Dropped
**Send:** January 21 (day of GRI)
**Purpose:** Immediate relevance

### Subject Lines
- It happened - [CARRIER] up [X]%
- GRI just hit. Ready to talk?
- January 21 arrived

### Body Template

```
Hi [FIRST NAME],

[CARRIER] GRI is official: [X]% increase effective [DATE].

Remember in December when I asked about your volume control and contract timing? This is why.

The brands who mapped this out are negotiating from strength right now.

If you didn't get to it (no judgment - peak was brutal), I can help you run the numbers this week.

15 minutes to see where you stand?

[CALENDLY LINK]

Brett

P.S. - [REFERENCE DECEMBER TOUCHPOINT - e.g., "You mentioned claims were backing up during peak. That's exactly the leverage point for this conversation."]
```

---

## Follow-Up 2: The "I Told You So" (Gentle)
**Send:** Jan 23-24 (2-3 days post-GRI)
**Purpose:** Second touch while GRI is fresh

### Subject Lines
- Following up on GRI impact
- Quick shipping math for [COMPANY]
- Still time to act

### Body Template

```
Hi [FIRST NAME],

Quick follow-up on the GRI news.

I've been running numbers for a few brands this week. Common pattern:

- [X]% rate increase on [SERVICE LEVEL]
- [Y]% of volume could shift without contract issues
- [$Z]K potential annual savings with zone optimization

Happy to run the same analysis for [COMPANY] - takes about 20 minutes of your time and I'll do the math.

No commitment. Just clarity on your options.

Worth a quick call?

Brett
[CALENDLY LINK]
```

---

## Follow-Up 3: LinkedIn Engagement Reference
**Send:** When prospect engaged with your LinkedIn post
**Purpose:** Warm outreach based on social proof

### Subject Lines
- Thanks for engaging on LinkedIn
- Following up on the [TOPIC] post
- You asked a great question

### Body Template

```
Hi [FIRST NAME],

Thanks for [liking/commenting on] my post about [TOPIC - e.g., "zone distribution" or "volume control"].

Your [comment/question] about [SPECIFIC THING THEY SAID] got me thinking about [COMPANY].

Based on what I can see publicly, you might be dealing with [HYPOTHESIS BASED ON BRAND SCOUT + THEIR COMMENT].

Am I close?

If so, happy to dig deeper. If not, I'd love to understand what you're actually seeing.

Either way - appreciate the engagement.

Brett
```

---

## Follow-Up 4: The Breakup (Final Sequence Email)
**Send:** Jan 28-31 (end of January)
**Purpose:** Create urgency or clean close

### Subject Lines
- Last note on shipping rates
- Closing the loop
- Should I stop reaching out?

### Body Template

```
Hi [FIRST NAME],

I've reached out a few times about [COMPANY]'s shipping situation with GRI hitting.

I know January is chaos, so I'll keep this simple:

If carrier costs are a priority for Q1, let's talk this week.
If not, no worries - I'll check back in Q2.

Either way, just let me know so I can plan accordingly.

Brett

P.S. - If there's someone else at [COMPANY] I should be talking to about shipping, happy to connect with them instead.
```

---

## Sequence Variations by December Engagement

### High Engagement (Replied in December)
- Skip Follow-Up 1, go straight to scheduling
- Reference specific conversation
- Warmer tone, faster to ask

### Medium Engagement (Opened emails, no reply)
- Full sequence
- Reference "I reached out in December about..."
- Steady cadence

### Low Engagement (No opens)
- Follow-Up 1 + 4 only (GRI day + breakup)
- Fresh angle, don't reference December
- They may have missed it entirely

### LinkedIn Engagement
- Lead with Follow-Up 3
- Then resume normal sequence
- Social proof = warm lead

---

## Timing Calendar

| Date | Action | Target |
|------|--------|--------|
| Jan 21 | Follow-Up 1: GRI Dropped | All December contacts |
| Jan 23-24 | Follow-Up 2: Math Offer | No-reply from Jan 21 |
| Ongoing | Follow-Up 3: LinkedIn Reference | Any LinkedIn engagers |
| Jan 28-31 | Follow-Up 4: Breakup | Still no response |

---

## Response Handling

**If they book a call:**
- Run Brand Scout refresh before call
- Prep 38 Questions framework
- Goal: Discovery, not pitch

**If they reply but don't book:**
- Ask one clarifying question
- Don't push for meeting yet
- Build relationship first

**If they say "not now":**
- Respect it
- Set 90-day follow-up reminder
- Add to Q2 nurture list

**If they say "talk to X instead":**
- Thank them
- Immediately pivot to new contact
- Reference introduction
