# LinkedIn Posts - December Pipeline Priming

6-post series using 38 Questions as thought leadership + Nate Skiver engagement style. Each post plants a seed that grows into January conversations.

**Style Guide (Nate Skiver Pattern):**
- Short punchy lines (1-2 sentences max)
- Line breaks between thoughts
- Real numbers and specifics
- End with question (drives comments)
- Storytelling > lecturing

---

## Post 1: Volume Reality Check ✅ POSTED Dec 15
**Publish:** Mon Dec 16 (POSTED Dec 15)
**38 Questions Source:** Q1, Q3, Q4, Q6
**Status:** LIVE - 4 reactions including Nate Skiver

```
📦 Your carrier should ask you this before quoting rates:

"What volume do you actually control?"

I've seen brands claim 500K packages/year.

When we mapped it:
- 40% was FBA (Amazon controls)
- 15% was 3PL-locked
- Only 200K was addressable.

The carrier quoted on 500K.
The real relationship was built on 200K.

With 7-12% real GRI impact coming in January...
Every addressable package matters.

What percentage of your shipping do you actually control?

#ecommerce #shipping #logistics #GRI2026
```

**Image:** 500K → 200K funnel visualization
**Engagement:** Nate Skiver liked. Monitor for comments.

---

## Post 2: The Contract Question ✅ POSTED
**Publish:** Thu Dec 19 (POSTED)
**38 Questions Source:** Q14, Q15
**Performance:** 674 impressions, 11 reactions (Luc Jackman +10)

```
🚨 5.9% rate increase sounds manageable.

Here's the real math:

Base rate increase: 5.9%
+ Peak surcharge expansion: +2-3%
+ Demand surcharge triggers: +1-2%
+ Fuel surcharge adjustments: +0.5-1%

Actual impact: 7-12%

But before you panic-switch...

One question:

"What minimum volume commitments do you have—and what penalties apply?"

I've seen brands locked into contracts.
$25K+ penalties they forgot existed.

Switching isn't always the answer.
Sometimes it's renegotiating.

But you can't strategize what you don't know.

When does your carrier contract actually expire?

#GRI2026 #shipping #ecommerce #logistics
```

**Image Prompt:** Iceberg visual - "5.9%" visible above water, "7-12% Real Impact" below with surcharge breakdown

**Engagement strategy:** This post will surface prospects with contract pain. Flag for Brand Scout research.

---

## Post 3: Peak Season Truth Serum ✅ POSTED Dec 17
**Publish:** Mon Dec 23 (POSTED Dec 17 - ahead of schedule)
**38 Questions Source:** Q19, Q20, Q21

```
📊 Peak season is a stress test.

Your carrier either passed or failed.

Not what they promised.
What actually happened.

Ask yourself:
- On-time delivery rate during BFCM?
- Claims processed in how many days?
- Did they have capacity when it mattered?

If you can't answer these...
You're flying blind into 2026.

And with UPS announcing Dec 22 this year...
They're capturing peak at higher rates.

Smart brands are grading now.
Before January conversations start.

How did YOUR carrier actually perform this peak?

#BFCM #peakseason #ecommerce #shipping
```

**Image Prompt:** Report card style - "Peak Season Performance Review" with A/B/C/D/F checkboxes for: On-Time %, Claims Speed, Capacity

**Engagement strategy:** Perfect timing for post-peak frustration. Engage with war stories.

---

## Post 4: Implementation Barriers ✅ POSTED Dec 23
**Publish:** Mon Dec 30 (POSTED Dec 23 - ahead of schedule)
**38 Questions Source:** Q37, Q38
**Pre-Publish Score:** 28/30 (revised with empathetic framing)

```
Your carrier should ask you this before the test shipment starts:

"What would prevent you from ramping to full volume after success?"

Here's what I usually hear:

"We'll start small and see"
→ Smart. Risk management is responsible.

"Need to check with IT"
→ Good. Integration matters more than speed.

"Let's wait until after peak"
→ Fair. Timing is everything in shipping.

These aren't red flags.
They're real barriers that deserve real answers.

The best implementations happen when both sides name the obstacles upfront.

Not in February when momentum is lost.

What's YOUR biggest barrier to switching carriers?
Drop it below—I've probably heard it before.

#shipping #logistics #ecommerce #Q12026
```

**Content Revision Note (Dec 23):** Original version framed prospect responses as "red flags" and "not real partners" - too judgmental. Revised to validate responses as reasonable concerns, positioning FirstMile as collaborative problem-solver.

**Revisions Made (Dec 17)**:
- Hook: Changed to "Your carrier should ask..." format (+1 point)
- CTA: Added value exchange "I'll tell you if it's real" (+2 points)
- Brand: Removed emoji from hook, kept functional markers in visual only (+1 point)

**Image Prompt:** Red flag vs Green flag comparison - Left side: 3 red flags with the ❌ responses. Right side: green flag with ✅ response

**Engagement strategy:** This surfaces serious buyers. Anyone who engages = high intent.

---

## Post 5: The 5 States That Matter ✅ READY
**Publish:** Mon Jan 6 (FedEx GRI day)
**38 Questions Source:** Q17
**Pre-Publish Score:** 26/30 (final review Dec 30)
**Image:** `C:\Users\BrettWalker\Pictures\firstmile_images\post5_zone_distribution_jan6.png`

```
Your carrier should ask this before building your rate card:

"What are your top 5 destination states?"

Here's why it matters:

Zone distribution determines costs.
More than any negotiation skill.

Ship to CA from TX? Zone 4-5.
Ship to NY from TX? Zone 7-8.

Same weight.
Same carrier.
Completely different economics.

FedEx GRI hits today.
5.9% headline. 7-12% reality.

The brands who know their zones?
They'll optimize around it.

The brands who don't?
They'll just pay more.

Drop your top 5 states below. I'll tell you which zones are costing you, and which ones aren't.

#shipping #logistics #ecommerce #GRI2026
```

**Revisions Made (Dec 17)**:
- Hook: Changed to "Your carrier should ask..." format (+2 points)
- CTA: Added value exchange "I'll tell you which zones are costing you" (+2 points)
- Brand: Removed emoji from hook (+1 point)

**Image Prompt:** US map with TX warehouse icon, arrows pointing to CA (labeled "Zone 4-5") and NY (labeled "Zone 7-8") showing cost difference

**Engagement strategy:** Offer free zone analysis to anyone who comments their states.

---

## Post 6: GRI Reaction (Day Of) ✅ READY
**Publish:** Tue Jan 21 (UPS effective date + reflection)
**38 Questions Source:** Q11, Q36
**Pre-Publish Score:** 29/30 (final review Dec 30)
**Image Prompt:** Two-panel "Panic Mode vs Math Mode" - see image-prompts-firstmile.md

```
Your carrier should have asked you this BEFORE the GRI hit:

"What improvement would justify the pain of switching?"

The dust is settling.

UPS: 5.9% (effective Dec 22, captured peak at higher rates)
FedEx: 5.9% (effective Jan 6)
DHL: 5-7% (effective Jan 1)

Real impact with surcharges: 7-12%

Before you panic-switch, answer three questions:

1. What's your ACTUAL cost per package?
   Not what you think. What the data shows.

2. What improvement justifies the pain?
   Be specific. 10%? 20%? 30%?

3. Do you know your zone distribution?
   Can you compare apples to apples?

Brands who answer calmly will save money.

Brands who panic-switch without data will regret it.

DM me if you want help running the numbers.
No pitch. Just math.

#GRI2026 #shipping #ecommerce #logistics
```

**Revisions Made (Dec 17)**:
- Hook: Changed to "Your carrier should have asked..." format (+2 points)
- Brand: Removed emoji from hook (+1 point)
- Visual: Recommend two-panel (Panic Mode vs Math Mode) instead of spreadsheet (+1 point)

**Image Prompt:** Two-panel comparison - Left: "Panic Mode" (frantic switching icons, red tones). Right: "Math Mode" (calm checkmarks for 3 questions answered, green tones). Headline: "The Math Before The Move"

**Engagement strategy:** This is harvest time. Every DM = discovery call.

---

## Posting Schedule Summary

| Date | Post | Hook | Status |
|------|------|------|--------|
| Mon Dec 15 | Volume Reality | "What do you actually control?" | ✅ POSTED |
| Thu Dec 19 | Contract Question | "What penalties apply?" | ✅ POSTED |
| Mon Dec 23 | Peak Performance | "How'd your carrier actually perform?" | ✅ POSTED |
| Mon Dec 30 | Implementation Barriers | "What would prevent you from ramping?" | ✅ POSTED |
| Mon Jan 6 | Zone Distribution (FedEx GRI day) | "What are your top 5 states?" | ✅ READY |
| Tue Jan 21 | GRI Reaction (UPS effective) | "Before you panic..." | ✅ READY |

---

## Hashtag Strategy

**Always use:**
- #ecommerce
- #shipping
- #logistics

**Rotate:**
- #GRI2026
- #peakseason
- #BFCM
- #Q12026
- #fulfillment

---

## Image Prompts Summary

| Post | Image Concept |
|------|---------------|
| 1 ✅ | 500K → 200K funnel (DONE) |
| 2 | Iceberg: 5.9% above / 7-12% below with surcharge breakdown |
| 3 | Report card: Peak Season Performance Review A/B/C/D/F |
| 4 | Red flags vs Green flag comparison |
| 5 | US map: TX → CA (Zone 4-5) vs TX → NY (Zone 7-8) |
| 6 | Calculator: "The Math Before The Move" |
