# LinkedIn Performance Analytics - December Pipeline Priming

This reference captures real performance data to calibrate future content creation and rubric scoring.

**Last Updated**: December 17, 2025
**Data Source**: LinkedIn PostAnalytics exports

---

## Performance Benchmarks (Calibrated from Posts 1-3)

### Engagement Benchmarks

| Metric | Target | Good | Needs Work |
|--------|--------|------|------------|
| Impressions | 700+ | 500-700 | <500 |
| Members Reached | 450+ | 350-450 | <350 |
| Reactions | 10+ | 7-10 | <7 |
| Comments | 2+ | 1 | 0 |
| Profile Views | 5+ | 3-5 | <3 |
| Saves | 2+ | 1 | 0 |

### Audience Quality Benchmarks

| Metric | Target | Good | Needs Work |
|--------|--------|------|------------|
| Logistics Industry % | 55%+ | 45-55% | <45% |
| Decision Maker Reach (Sr+Dir+VP+CXO) | 60%+ | 50-60% | <50% |
| Executive Reach (VP+CXO) | 20%+ | 10-20% | <10% |

---

## Rubric-to-Performance Correlation

**Critical Finding**: 6-point rubric drop (29→23) = 22% impression drop, 50% executive reach drop

| Rubric Score | Expected Impressions | Expected Reactions | Expected Executive Reach |
|--------------|---------------------|-------------------|-------------------------|
| 28-30 | 650-750 | 9-12 | 18-25% |
| 25-27 | 550-650 | 7-9 | 12-18% |
| 22-24 | 450-550 | 5-7 | 8-12% |
| <22 | <450 | <5 | <8% |

**Minimum publish threshold**: 25/30 rubric score

---

## Post Performance Data

### Post 1: Volume Reality Check (Dec 15, 2025)

**Rubric Score**: 29/30

| Metric | Value |
|--------|-------|
| Impressions | 692 |
| Members Reached | 467 |
| Reactions | 10 |
| Comments | 0 |
| Saves | 1 |
| Profile Views | 4 |

**Audience Quality**:
- Industry (Logistics): 48.6%
- Executive Reach (VP+CXO): 21.6%
- Decision Makers (Sr+Dir+Mgr+VP+CXO): 78.8%
- Top Job Title: Vice President of Sales

**Competitor Viewership**:
- UPS: 5.6%
- Amazon: 3.6%
- FedEx: 3.2%
- OnTrac: 2.6%
- FirstMile: 2.6%

**What Worked**:
- Hook: "Your carrier should ask you this..." - specific, curiosity-creating
- Insight: 500K→200K concrete transformation
- CTA: Percentage question (though didn't drive comments)
- Visual: Clear funnel flow

**What to Replicate**:
- "Your [X] should..." hook pattern
- Concrete number transformations (before→after)
- Broader topics = higher reach + more executives

---

### Post 2: The Contract Question (Dec 16, 2025)

**Rubric Score**: 23/30 (BELOW THRESHOLD)

| Metric | Value | vs Post 1 |
|--------|-------|-----------|
| Impressions | 538 | -22% |
| Members Reached | 376 | -19% |
| Reactions | 7 | -30% |
| Comments | 0 | -- |
| Saves | 0 | -1 |
| Profile Views | 4 | -- |

**Audience Quality**:
- Industry (Logistics): 54% (+5.4%)
- Executive Reach (CXO only): 9.6% (-12%)
- Decision Makers: 51.9% (-26.9%)
- Top Job Title: Sales Executive (downgrade from VP)

**Competitor Viewership**:
- OnTrac: 3.7%
- FirstMile: 2.1%
- FedEx: 1.9%
- UPS: 1.6% (dropped from 5.6%)

**What Underperformed**:
- Hook: Number-led ("5.9%") less engaging than question-led
- CTA: Closed question ("When does your contract expire?") - yes/no answer
- Visual: Iceberg metaphor requires interpretation
- Topic: Specific (contracts) vs broad (volume) = narrower audience

**Lessons Learned**:
- Closed questions don't drive comments
- Number-led hooks underperform question-led hooks
- Specific/niche topics = better targeting but lower reach
- Need value exchange in CTA ("Drop X, I'll tell you Y")

---

### Post 3: Peak Season Truth Serum (Dec 17, 2025)

**Rubric Score**: TBD (published ahead of schedule)

**Performance Data**: Pending (check Dec 19-20)

**Hypothesis**: Report card format + "grade your carrier" CTA should drive first comments

---

## Dimension-Specific Learnings

### Hook Strength Patterns

| Pattern | Performance | Example |
|---------|-------------|---------|
| "Your [X] should..." | HIGH | "Your carrier should ask you this before quoting rates" |
| Question hook | HIGH | "What volume do you actually control?" |
| Number-led | MEDIUM | "5.9% rate increase sounds manageable" |
| Statement | LOW | "Shipping costs are rising" |

**Rule**: Use "Your [X] should..." or direct question hooks. Avoid number-led opens.

### CTA Patterns

| Pattern | Performance | Example |
|---------|-------------|---------|
| Value exchange | UNTESTED | "Drop your top 5 states - I'll analyze your zones" |
| Open question | MEDIUM | "What percentage do you actually control?" |
| Closed question | LOW | "When does your contract expire?" |
| No CTA | LOW | Post just ends |

**Rule**: CTAs must offer value for engaging. "Drop X, I'll tell you Y" format.

### Visual Patterns

| Pattern | Performance | Example |
|---------|-------------|---------|
| Before→After transformation | HIGH | 500K→200K funnel |
| Report card/scorecard | UNTESTED | Peak performance grades |
| Metaphor (iceberg, etc.) | MEDIUM | 5.9% visible, 7-12% hidden |
| Text-heavy infographic | LOW | Multiple competing elements |

**Rule**: Concrete transformations > metaphors. 2-second comprehension test.

### Topic Breadth Impact

| Topic Type | Reach | Executive % | Trade-off |
|------------|-------|-------------|-----------|
| Broad (volume control) | HIGH | HIGH | Less targeted |
| Specific (contracts) | MEDIUM | MEDIUM | Better fit, lower reach |
| Niche (implementation) | LOW | VARIES | Very targeted |

**Rule**: Balance broad topics (Posts 1, 3, 5) with specific topics (Posts 2, 4, 6).

---

## Pre-Publish Checklist (MANDATORY)

Before publishing any LinkedIn post:

1. [ ] **Rubric Score**: Score all 6 dimensions with quoted evidence
2. [ ] **Threshold Check**: Total must be 25+ to publish
3. [ ] **Hook Pattern**: Uses "Your [X] should..." or question format (not number-led)
4. [ ] **CTA Pattern**: Offers value exchange or uses open question
5. [ ] **Visual Test**: Passes 2-second comprehension test
6. [ ] **38Q Mapping**: Clearly maps to specific discovery questions
7. [ ] **Weak Dimension Fix**: If any dimension <4, request stronger version before publishing

**If score is 22-24**: Improve weakest dimension, re-score, then publish
**If score is <22**: Major revision required - do not publish

---

## Analytics Collection Workflow

After each post (48-72 hours post-publish):

1. Export PostAnalytics from LinkedIn
2. Run this analysis script (or manually extract):
   - Impressions, Reached, Reactions, Comments, Saves
   - Top Industry %, Executive Reach %
   - Competitor viewership
3. Update this file with new post data
4. Calculate rubric-to-performance correlation
5. Extract "What Worked" and "Lessons Learned"
6. Update dimension-specific learnings

---

## Integration Points

This reference is used by:

- **december-pipeline-priming/SKILL.md** - Campaign execution
- **nate-jones-deliberate-practice/11-linkedin-content-rubric.md** - Rubric scoring
- **ai-native-workflow/prompt-library.md** - Post creation prompts

When creating or reviewing LinkedIn posts, ALWAYS load this reference first.
