---
name: Decision Helper
slug: decision-helper
description: Make better decisions using structured frameworks and mental models
category: personal
complexity: simple
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "help me decide"
  - "decision framework"
  - "should I"
  - "making a decision"
tags:
  - productivity
  - decision-making
  - thinking
  - clarity
  - frameworks
---

# Decision Helper

The Decision Helper skill guides you through structured decision-making processes using proven frameworks, mental models, and de-biasing techniques. Rather than relying on gut feel alone or getting paralyzed by analysis, this skill helps you think clearly about choices that matter.

This skill applies decision science, behavioral economics, and strategic thinking frameworks to help you evaluate options systematically, identify hidden biases, consider long-term consequences, and make choices you'll be confident about. It recognizes different decision types—reversible vs. irreversible, urgent vs. important, personal vs. professional—and provides appropriate frameworks for each.

The tool doesn't make decisions for you—it clarifies your thinking, surfaces assumptions, and ensures you've considered what matters most before committing to a path.

## Core Workflows

### Workflow 1: Decision Framing
Clarify what you're actually deciding:
1. **Question Definition**: What exactly are you choosing between?
2. **Stakes Assessment**: How important is this? How reversible?
3. **Timeline**: When must you decide? Can you wait for more information?
4. **Stakeholders**: Who else is affected? Who should have input?
5. **Context**: What constraints or requirements apply?
6. **True Question**: Often the initial framing isn't the real decision

### Workflow 2: Options Generation
Expand your choice set:
1. **List Obvious Options**: The choices you're already considering
2. **Explore Alternatives**: Are there other possibilities?
3. **Challenge Constraints**: What if X weren't a factor?
4. **Hybrid Options**: Can you combine approaches?
5. **Do Nothing**: Is staying put an option?
6. **Third Alternative**: Beyond binary choices

### Workflow 3: Criteria Definition
Identify what matters:
1. **Values Alignment**: What principles matter here?
2. **Success Definition**: What does a good outcome look like?
3. **Trade-offs**: What are you willing to sacrifice for what?
4. **Weighted Importance**: Not all criteria are equal
5. **Deal-breakers**: Non-negotiable requirements

### Workflow 4: Systematic Evaluation
Assess options against criteria:
1. **Score Options**: Rate each option on each criterion
2. **Weight Criteria**: Apply importance multipliers
3. **Compare Trade-offs**: Where does each option excel/fail?
4. **Test Assumptions**: What must be true for each option to work?
5. **Consider Consequences**: Second and third-order effects

### Workflow 5: Decision Validation
Pressure-test your choice:
1. **10/10/10 Analysis**: How will you feel in 10 mins/months/years?
2. **Regret Minimization**: Which choice minimizes future regret?
3. **Reversibility Check**: Can you undo this if it doesn't work?
4. **Advice to Friend**: What would you tell someone else in this situation?
5. **Pre-mortem**: If this fails, what will be the reason?

## Decision Frameworks

### The Eisenhower Matrix
For prioritization and urgency decisions:

| | **Urgent** | **Not Urgent** |
|---|---|---|
| **Important** | DO NOW | SCHEDULE |
| **Not Important** | DELEGATE | ELIMINATE |

### The WRAP Framework (Chip & Dan Heath)

**W**iden your options
- Avoid "whether or not" framing
- Consider multiple alternatives simultaneously

**R**eality-test your assumptions
- Ask disconfirming questions
- Seek outside perspectives

**A**ttain distance before deciding
- 10/10/10: How will you feel in 10 mins/months/years?
- What would you advise a friend?

**P**repare to be wrong
- Set tripwires to reconsider
- Plan for both success and failure

### The Regret Minimization Framework (Jeff Bezos)

Project yourself to age 80 and ask:
- Will I regret not doing this?
- Will I regret the safe choice?
- What minimizes future regret?

Best for: Life-changing decisions, risk-taking, career choices

### The Weighted Decision Matrix

| Option | Criterion 1 (weight: 5) | Criterion 2 (weight: 3) | Criterion 3 (weight: 2) | Total |
|---|---|---|---|---|
| Option A | 4 × 5 = 20 | 3 × 3 = 9 | 5 × 2 = 10 | 39 |
| Option B | 5 × 5 = 25 | 2 × 3 = 6 | 3 × 2 = 6 | 37 |

Best for: Complex decisions with multiple factors

### Two-Way vs. One-Way Doors (Jeff Bezos)

**Two-Way Doors** (Reversible)
- Decide quickly with limited information
- You can walk back through if wrong
- Examples: Hiring, new feature, process change

**One-Way Doors** (Irreversible)
- Take time, gather data, consult widely
- Very difficult or impossible to reverse
- Examples: Marriage, major career change, selling company

### Second-Order Thinking

Don't just ask "What happens next?"
Ask "And then what?"

Example:
- Decision: Take on more clients
- First-order: More revenue
- Second-order: Less time for existing clients, quality drops
- Third-order: Reputation suffers, lose clients long-term

### The 10x Rule

Would you take this option if it required 10x the effort/cost?

If yes → genuine priorities
If no → probably not that important

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Start decision process | "help me decide" or "making a decision" |
| Binary choice | "should I [option A] or [option B]" |
| Generate options | "what are my options for [situation]" |
| Evaluate trade-offs | "compare [option A] vs [option B]" |
| Pressure test | "help me validate my decision" |
| Remove bias | "am I thinking clearly about [decision]" |
| Long-term view | "future implications of [decision]" |
| Risk assessment | "what could go wrong with [decision]" |

## Decision Types & Approaches

### Type 1: Career Decisions
Framework: Regret Minimization + Values Alignment
Questions:
- What does success look like in 10 years?
- What am I optimizing for? (Money, impact, growth, balance)
- What's irreversible vs. what can I change later?

### Type 2: Financial Decisions
Framework: Expected Value + Risk Assessment
Questions:
- What's the downside if this goes wrong?
- Can I afford to lose this?
- What's the opportunity cost?
- Is this speculation or investment?

### Type 3: Relationship Decisions
Framework: Values Alignment + Long-term Impact
Questions:
- Are core values aligned?
- What patterns am I seeing?
- What would I advise a friend in this situation?
- Am I making excuses or seeing reality?

### Type 4: Time Allocation Decisions
Framework: Eisenhower Matrix + Opportunity Cost
Questions:
- Is this urgent, important, both, or neither?
- What am I NOT doing if I do this?
- Does this align with my goals?
- Can someone else do this?

### Type 5: Strategic Business Decisions
Framework: WRAP + Pre-mortem
Questions:
- What are we really trying to achieve?
- What must be true for this to work?
- What would make this fail?
- Is this reversible?

## Decision Templates

### Standard Decision Template
```
DECISION: [What am I deciding?]

TIMELINE: [When must I decide?]

STAKES: [How important/reversible is this?]

OPTIONS:
A. [Option 1]
B. [Option 2]
C. [Option 3]
D. Do nothing / stay the course

WHAT MATTERS MOST (Criteria):
1. [Criterion 1] - Weight: [1-10]
2. [Criterion 2] - Weight: [1-10]
3. [Criterion 3] - Weight: [1-10]

EVALUATION:
           | Criterion 1 | Criterion 2 | Criterion 3 | Total
Option A   |             |             |             |
Option B   |             |             |             |
Option C   |             |             |             |

ASSUMPTIONS I'M MAKING:
-
-

WHAT COULD GO WRONG:
Option A risks:
Option B risks:

10/10/10:
In 10 minutes, I'll feel...
In 10 months, I'll feel...
In 10 years, I'll feel...

DECISION: [Choice]

WHY: [Rationale]

REVERSIBILITY: [ ] Can undo [ ] Hard to reverse [ ] Irreversible

REVIEW DATE: [When to reassess this decision]
```

### Quick Decision Template
```
DECIDING: [Question]

OPTIONS:
A. [Option A]
B. [Option B]

PROS/CONS:

Option A:
✓ Pro
✓ Pro
✗ Con
✗ Con

Option B:
✓ Pro
✓ Pro
✗ Con
✗ Con

GUT FEELING: [What does intuition say?]

LOGICAL CHOICE: [What does analysis say?]

IF THEY DISAGREE: [Explore the tension]

CHOICE: [Decision]
```

### Values-Based Decision Template
```
DECISION: [What I'm deciding]

MY CORE VALUES (in order):
1. [Value 1]
2. [Value 2]
3. [Value 3]

OPTION A:
How it aligns with Value 1:
How it aligns with Value 2:
How it aligns with Value 3:

OPTION B:
How it aligns with Value 1:
How it aligns with Value 2:
How it aligns with Value 3:

WHICH OPTION BEST HONORS WHO I WANT TO BE?

DECISION: [Choice]
```

## Best Practices

- **Define the real question** - "Should I take this job?" might really be "Am I ready to leave my current job?"
- **Expand your options** - Most decisions aren't binary
- **Separate deciding from doing** - Make the choice, then create the plan
- **Set decision deadlines** - Avoid perpetual analysis
- **Gather just enough information** - More data doesn't always improve decisions
- **Identify your biases** - We all have them
- **Sleep on big decisions** - Your unconscious processes information
- **Write it down** - External thinking clarifies internal confusion
- **Imagine explaining your choice** - To someone you respect
- **Consider opportunity cost** - Every yes is a no to something else
- **Run a pre-mortem** - Assume it failed, work backward to why
- **Make reversible decisions quickly** - Don't overthink two-way doors
- **Consult selectively** - Too many opinions create noise
- **Trust your gut (sometimes)** - Intuition is pattern recognition
- **Commit fully once decided** - Second-guessing wastes energy

## Common Decision Biases

### Status Quo Bias
**What it is**: Preferring things to stay the same
**Counter**: Imagine you're starting fresh—would you choose current state?

### Sunk Cost Fallacy
**What it is**: Continuing because you've already invested
**Counter**: Would you start this today knowing what you know?

### Confirmation Bias
**What it is**: Seeking evidence that supports what you already believe
**Counter**: Actively seek disconfirming evidence

### Anchoring Effect
**What it is**: Over-relying on first piece of information
**Counter**: Generate options before hearing others' opinions

### Availability Bias
**What it is**: Overweighting recent or vivid information
**Counter**: Look at base rates and statistics, not just stories

### Optimism Bias
**What it is**: Overestimating chances of success
**Counter**: Run a pre-mortem, consider downside scenarios

### Analysis Paralysis
**What it is**: Overthinking to avoid deciding
**Counter**: Set information cutoff, recognize diminishing returns

## Integration Points

This skill works well with:
- **Goal Setter**: Ensure decisions align with goals
- **Journal Prompter**: Reflect on decision outcomes
- **Learning Path Creator**: Decide what to learn next
- **Daily Planner**: Decide how to allocate time
- **Time Blocker**: Decide what deserves calendar space

## Example Decision Session

**User**: "help me decide"

**Skill Response**:
"I'll help you think through this clearly. Decision-making is a skill, and structure beats wishful thinking.

**First, tell me: What are you deciding?**

Be as specific as you can. For example:
- "Should I take the new job offer?" (career decision)
- "Should I invest in this opportunity?" (financial decision)
- "Should I end this relationship?" (personal decision)
- "Should we build feature A or feature B?" (strategic decision)

What's your decision?"

**User**: "Should I take the new job offer or stay at my current company?"

**Skill Response**:
"Classic career crossroads. This is a high-stakes, somewhat reversible decision (you could change jobs again, but there are costs).

Let's structure this properly. I have some clarifying questions:

**Context Questions:**

1. **Timeline**: When do you need to decide?

2. **What's driving this?**
   - Actively unhappy at current job?
   - Excited about new opportunity?
   - Just exploring?

3. **The offers**:
   - What does the new job offer (role, comp, growth)?
   - What does staying look like (trajectory, changes possible)?

4. **What matters most to you in a job?** (Top 3)
   - Compensation?
   - Growth/learning?
   - Work-life balance?
   - Impact/mission?
   - Team/culture?
   - Location/flexibility?

Take your time—clarity here shapes everything else."

**User**: "Need to decide by Friday. Not actively unhappy but feeling stagnant. New job is 20% raise, more senior role, but longer commute. Most important to me: growth, work-life balance, compensation (in that order)"

**Skill Response**:
"Got it. Growth is #1, balance #2, money #3. The new role offers more growth and money but potentially threatens balance (longer commute).

**Let's use a structured framework: Weighted Decision Matrix**

Here's how we'll score each option (1-10) on your criteria:

**CRITERION 1: Growth/Learning Opportunity** (Weight: 10 - your top priority)
- Current job: How would you rate growth potential? [1-10]
- New job: How would you rate growth potential? [1-10]

**CRITERION 2: Work-Life Balance** (Weight: 8 - second priority)
- Current job: [1-10]
- New job: [1-10] (consider that commute)

**CRITERION 3: Compensation** (Weight: 6 - third priority)
- Current job: [1-10]
- New job: [1-10]

Give me your honest ratings for each. Then we'll run the math and validate with other frameworks."

*[Continues with evaluation, 10/10/10 test, regret minimization, and final recommendation based on user's values]*
