# Red Flag Criteria

## Information Control Infrastructure

Indicators of content/narrative control capability:

- Content gatekeeping (determining platform access/revenue)
- Narrative amplification via AI/algorithms
- Creator economy intermediation (between creators and revenue)
- Social platform measurement (data influencing platform policies)
- Content classification enabling suppression/demonetization

**Investigation focus**: Document actual censorship effects, not just theoretical capability.

## Surveillance Infrastructure

Indicators of surveillance capability:

- Data collection at scale (behavioral, biometric, location)
- Monitoring technology (individual/group tracking)
- Metadata aggregation (enables re-identification)
- Encryption undermining (bypass protections)
- Behavioral profiling (detailed personality models)
- Real-time tracking (location, activity, communication)

**Investigation focus**: Map actual capabilities vs. security marketing claims.

## Market/Brand Manipulation

Indicators of distorted consensus:

- Advertising volume disproportionate to independent testing
- Affiliate program scale correlating with recommendation frequency
- PR-origin phrasing repeated across "independent" sources
- Peak specs marketed without sustained performance disclosure
- Warranty shorter than competitors at same price point
- Professional defection patterns contradicting consumer consensus

**Investigation focus**: Trace quality-information flow from manufacturer to recommendation.

## Red Flag Combinations

Multiple indicators compound risk.

### Privacy/Surveillance Combinations

| Combination | Concern Level |
|-------------|---------------|
| Complex ownership + Sensitive data operations | HIGH |
| Efficiency technology + Surveillance-capable clients | HIGH |
| Platform intermediation + Content control capability | HIGH |
| Government partnerships + Private data collection | CRITICAL |
| Market consolidation + Essential service provision | HIGH |
| Encryption undermining + "Security" marketing | CRITICAL |
| Extensive data collection + "Privacy by default" claims | HIGH |

### Product/Brand Combinations

| Combination | Concern Level |
|-------------|---------------|
| Brand dominance + No independent sustained testing | HIGH |
| Marketing volume + Warranty shorter than competitors | HIGH |
| "Best" ranking + Affiliate links + No methodology | HIGH |
| Recent reliability issues + Unchanged marketing claims | CRITICAL |
| Professional defection + Unchanged consumer consensus | HIGH |
| Peak specs only + No post-cache/stress test data | HIGH |

## Pattern Recognition Triggers

Look for convergent indicators:

- Multiple independent sources pointing to same conclusion
- Behavior patterns consistent across contexts
- Material incentive structures supporting alleged patterns
- Technical capabilities enabling alleged activities
- Historical precedents in similar contexts

## Common Marketing Claims to Verify

### Privacy/Security Claims

| Claim | Evidence to Seek | Red Flag |
|-------|------------------|----------|
| "Privacy by default" | Actual default settings, collection scope | Extensive collection enabled by default |
| "We don't sell data" | Third-party sharing, "licensing" semantics | Sharing via "partnerships" |
| "Encrypted/Secure" | E2E vs server-access, implementation | Company retains access |
| "Anonymized" | Re-identification capability, metadata | Behavioral profiling from "anonymous" data |
| "GDPR compliant" | Regulatory actions, consent mechanisms | Violations, inadequate consent |
| "Transparent" | Actual transparency reports | No reports, vague language |

### Product/Performance Claims

| Claim | Evidence to Seek | Red Flag |
|-------|------------------|----------|
| "Up to X speed" | Sustained performance testing | Drops significantly after cache/thermal |
| "Industry leading" | Independent comparative benchmarks | Only manufacturer testing cited |
| "Most reliable" | Backblaze/professional failure data | No third-party reliability data |
| "Best value" | Price/performance at sustained metrics | Only peak performance compared |
| "#1 recommended" | Source methodology, affiliate status | Affiliate-driven rankings |

## Credibility Gap Patterns

Indicators of unreliable claims:

- Technical capabilities contradicting marketing claims
- Business model incompatible with stated values
- Regulatory violations contradicting compliance claims
- Warranty terms contradicting reliability marketing
- Professional user experience contradicting consumer consensus
- Component sourcing contradicting quality positioning
