# 权威学习资源指南

## 论文下载渠道

### 1. arXiv (arxiv.org)
- **特点**：计算机科学、物理等领域的预印本服务器
- **访问方式**：完全免费开放
- **PDF下载**：`https://arxiv.org/pdf/{paper_id}.pdf`
- **示例**：`https://arxiv.org/pdf/1706.03762.pdf` (Attention Is All You Need)

### 2. Papers With Code (paperswithcode.com)
- **特点**：论文+代码+基准测试
- **访问方式**：免费
- **优势**：可以直接找到论文对应的代码实现

### 3. Semantic Scholar (semanticscholar.org)
- **特点**：AI驱动的学术搜索引擎
- **访问方式**：免费
- **API**：提供免费API获取论文元数据

### 4. Google Scholar (scholar.google.com)
- **特点**：最全面的学术搜索引擎
- **访问方式**：免费
- **技巧**：点击右侧PDF链接可能找到免费版本

### 5. OpenReview (openreview.net)
- **特点**：顶会论文（ICLR、NeurIPS等）
- **访问方式**：免费
- **优势**：可以看到审稿意见

### 6. ACL Anthology (aclanthology.org)
- **特点**：NLP领域权威论文库
- **访问方式**：完全免费
- **PDF下载**：直接提供

### 7. CVF Open Access
- **特点**：CVPR、ICCV等计算机视觉顶会
- **访问方式**：免费
- **网址**：`https://openaccess.thecvf.com/`

### 8. IEEE Xplore / ACM DL
- **特点**：正式出版的会议和期刊论文
- **访问方式**：需要订阅（部分开放获取）
- **替代方案**：可在arXiv找预印本版本

## 书籍资源

### 免费在线书籍
1. **Deep Learning Book** - Ian Goodfellow
   - https://www.deeplearningbook.org/

2. **Dive into Deep Learning** - 李沐等
   - https://d2l.ai/ (英文)
   - https://zh.d2l.ai/ (中文)

3. **Neural Networks and Deep Learning** - Michael Nielsen
   - http://neuralnetworksanddeeplearning.com/

4. **Probabilistic Machine Learning** - Kevin Murphy
   - https://probml.github.io/pml-book/

5. **Speech and Language Processing** - Jurafsky & Martin
   - https://web.stanford.edu/~jurafsky/slp3/

### 购买渠道（全球优先）

#### 国际购买渠道（推荐）
| 平台 | 网址 | 特点 |
|------|------|------|
| **Amazon** | amazon.com | 全球最大，书籍种类最全 |
| **O'Reilly Safari** | oreilly.com | 技术书籍订阅，月费制无限阅读 |
| **Manning** | manning.com | 优质编程书籍，MEAP早期访问 |
| **Packt** | packtpub.com | 技术书籍，常有折扣 |
| **Springer** | link.springer.com | 学术书籍和教材 |
| **MIT Press** | mitpress.mit.edu | AI/ML经典教材 |
| **Cambridge University Press** | cambridge.org | 学术权威 |
| **No Starch Press** | nostarch.com | 技术书籍，DRM-free |
| **Book Depository** | bookdepository.com | 全球免运费 |
| **AbeBooks** | abebooks.com | 二手书和绝版书 |
| **ThriftBooks** | thriftbooks.com | 便宜的二手书 |
| **Google Play Books** | play.google.com/books | 电子书 |
| **Apple Books** | apple.com/apple-books | 电子书 |

#### 电子书订阅服务
- **O'Reilly Safari** (oreilly.com) - 技术书籍首选，$49/月
- **Kindle Unlimited** (amazon.com) - 部分技术书籍
- **Scribd** (scribd.com) - 综合订阅服务

#### 中文渠道（辅助）
- 京东、当当 - 中文版购买
- 微信读书 - 部分技术书籍

## 课程平台（全球资源优先）

### 免费课程（国际平台）
| 平台 | 网址 | 推荐课程 |
|------|------|----------|
| **Coursera** | coursera.org | Andrew Ng深度学习专项、Stanford CS229/CS231n/CS224n |
| **edX** | edx.org | MIT、Harvard、Berkeley AI课程 |
| **fast.ai** | fast.ai | Practical Deep Learning for Coders（强烈推荐） |
| **MIT OCW** | ocw.mit.edu | 6.S191 Introduction to Deep Learning |
| **Stanford Online** | online.stanford.edu | CS系列课程 |
| **Khan Academy** | khanacademy.org | 数学基础（线性代数、微积分、概率） |
| **YouTube** | youtube.com | 3Blue1Brown, StatQuest, Sentdex, Two Minute Papers |

### 付费课程（国际平台）
| 平台 | 网址 | 特点 |
|------|------|------|
| **Udacity** | udacity.com | 纳米学位，项目驱动 |
| **deeplearning.ai** | deeplearning.ai | Andrew Ng系列，专业证书 |
| **DataCamp** | datacamp.com | 互动式学习 |
| **Pluralsight** | pluralsight.com | 技术技能评估 |
| **LinkedIn Learning** | linkedin.com/learning | 职业导向 |

### 中文课程（辅助）
- B站：李宏毅机器学习、吴恩达系列（中英双语）
- 网易公开课、学堂在线

## 博客和社区（全球资源优先）

### 国际博客（推荐）
| 博客 | 作者/来源 | 特点 |
|------|-----------|------|
| **Towards Data Science** | Medium | 综合技术文章 |
| **Machine Learning Mastery** | Jason Brownlee | 实践教程，代码完整 |
| **Distill.pub** | 多位研究者 | 高质量可视化解释 |
| **Lil'Log** | Lilian Weng (OpenAI) | 深度技术综述 |
| **Jay Alammar** | Jay Alammar | Transformer可视化解释 |
| **Sebastian Ruder** | Sebastian Ruder | NLP综述和前沿 |
| **Andrej Karpathy** | Andrej Karpathy | 前Tesla AI总监 |
| **Christopher Olah** | Christopher Olah | 神经网络可视化 |
| **Chip Huyen** | Chip Huyen | ML系统设计 |
| **Eugene Yan** | Eugene Yan | ML工程实践 |
| **The Gradient** | AI研究社区 | 深度访谈和分析 |
| **AI Alignment Forum** | 多位研究者 | AI安全研究 |

### 国际社区和新闻
| 平台 | 网址 | 特点 |
|------|------|------|
| **Reddit** | r/MachineLearning, r/LearnML | 活跃讨论社区 |
| **Hacker News** | news.ycombinator.com | 技术新闻 |
| **Twitter/X** | twitter.com | 研究者动态 |
| **Discord** | 各框架官方Discord | 实时交流 |

### 中文博客（辅助）
- 知乎专栏：机器之心、PaperWeekly、量子位
- 微信公众号：机器之心、新智元、AI科技评论

## 代码资源

### GitHub
1. **Awesome系列**
   - awesome-deep-learning
   - awesome-machine-learning
   - awesome-nlp
   - awesome-cv

2. **官方实现**
   - 顶会论文通常附带代码

3. **教程仓库**
   - pytorch/tutorials
   - tensorflow/models

### 实践平台
1. **Kaggle** - 竞赛和数据集
2. **Google Colab** - 免费GPU
3. **Hugging Face** - 模型和数据集

## 论文检索技巧

### 搜索策略
1. 先搜 `{topic} survey` 或 `{topic} 综述` 获取领域全貌
2. 查看综述论文的参考文献找经典论文
3. 用 Google Scholar 查看引用次数判断重要性
4. 在 Papers With Code 看 SOTA 了解最新进展

### 论文类型
- **Survey/Review**：领域综述，入门首选
- **Tutorial**：教程性质，深入浅出
- **Seminal Paper**：开创性论文，必读经典
- **SOTA Paper**：最新最强，了解前沿

### 阅读顺序建议
1. 先读综述了解全貌
2. 精读3-5篇经典论文
3. 泛读近2年的SOTA论文
4. 根据兴趣深入某个方向
