# Research Report: [Topic]

<!-- =============================================================================
PROGRESSIVE FILE ASSEMBLY STRATEGY (2025 - Unlimited Length):

This report is generated section-by-section using progressive file assembly.
Each section is generated to APPROPRIATE depth (however many words needed) and
written to file immediately using Write/Edit tools.

WHY: Manages output token limits while maintaining quality throughout
RESULT: Large reports (up to 20,000 words per skill run) - sections sized naturally by content

CLAUDE CODE LIMIT: 32,000 output tokens (≈20,000 words max per run)
For reports >20,000 words: Run skill multiple times for different parts

GENERATION WORKFLOW:
1. Generate Executive Summary → Write to file
   (As long as needed for comprehensive summary)

2. Generate Introduction → Edit/append to file
   (As long as needed to establish context)

3. Generate Finding 1 → Edit/append to file
   (As long as needed to fully present evidence and analysis)

4. Generate Finding 2 → Edit/append to file
   (Each finding sized appropriately - some may need 300 words, others 1,500)

5. Continue for ALL findings (no limit on number OR length per finding!)

6. Generate Synthesis → Edit/append to file
   (As long as needed for deep synthesis)

7. Generate Limitations → Edit/append to file
8. Generate Recommendations → Edit/append to file
9. Generate Bibliography (ALL citations) → Edit/append to file
10. Generate Methodology → Edit/append to file

SIZING PRINCIPLE:
- Each section should be as long as IT NEEDS TO BE
- Simple finding? Maybe 400 words is enough
- Complex multi-faceted finding? Could be 1,200 words
- Let evidence and analysis determine length, not arbitrary targets
- Only constraint: Keep each INDIVIDUAL generation under ~2,000 words to avoid output limits
- If a section needs >2,000 words, break it into subsections and generate progressively

CITATION TRACKING (CRITICAL):
- Maintain running list in working memory: citations_used = [1, 2, 3, ...]
- After each section: Add new citations to list
- In Bibliography: Generate entry for EVERY citation in final list
- NO gaps, NO ranges, NO placeholders

============================================================================= -->

<!-- WRITING STANDARDS (Apply to EACH section): -->
<!-- - PRECISION: Each word deliberately chosen, carries intention -->
<!-- - ECONOMY: No fluff, eliminate fancy grammar, unnecessary adjectives -->
<!-- - CLARITY: Use exact numbers, specific data, precise technical terms -->
<!-- - DIRECTNESS: State findings without embellishment -->
<!-- - HIGH SIGNAL-TO-NOISE: Respect reader's time, dense information -->
<!-- Examples: "reduced mortality 23%" not "significantly improved outcomes" -->
<!-- Examples: "5 RCTs (n=1,847)" not "several studies suggest" -->

<!-- SOURCE ATTRIBUTION (CRITICAL - PREVENTS FABRICATION): -->
<!-- EVERY factual claim MUST be followed by [N] citation in same sentence -->
<!-- Use "According to [1]..." or "[1] reports..." for factual statements -->
<!-- DISTINGUISH fact from synthesis: -->
<!--   ✅ GOOD: "Mortality decreased 23% (p<0.01) in treatment group [1]." -->
<!--   ❌ BAD: "Studies show mortality improved significantly." -->
<!-- NO vague attributions like "research suggests" or "experts believe" -->
<!-- ADMIT uncertainty: "No sources found for X" not fabricated citations -->
<!-- LABEL speculation: "This suggests..." not "Research shows..." -->

<!-- ANTI-TRUNCATION (CRITICAL - Each Section Must Be COMPLETE): -->
<!-- ❌ FORBIDDEN: "Content continues...", "Due to length...", "[Sections X-Y...]" -->
<!-- ✅ REQUIRED: Generate current section COMPLETELY (you're only writing 500 words!) -->
<!-- ✅ REQUIRED: Write to file immediately, then move to next section -->
<!-- Progressive assembly handles unlimited length - you handle quality per section -->

## Executive Summary

[Write 3-5 bullet points, 50-250 words total]
- **Key Finding 1:** [Major discovery with specific data/metrics]
- **Key Finding 2:** [Important insight with evidence]
- **Key Finding 3:** [Critical conclusion with implications]
- [Additional findings as needed]

**Primary Recommendation:** [One clear sentence stating the main recommendation]

**Confidence Level:** [High/Medium/Low with brief justification]

---

## Introduction

### Research Question
[State the original question clearly and completely]

[Add 1-2 sentences providing context for why this question matters]

### Scope & Methodology
[2-3 paragraphs explaining:]
- What specific aspects were investigated
- What was included vs excluded from scope
- What research methods were used (web search, academic sources, industry reports, etc.)
- How many sources were consulted
- Time period covered

### Key Assumptions
[List 3-5 important assumptions made during research]
- Assumption 1: [Description and why it matters]
- Assumption 2: [Description and why it matters]
- [Continue...]

---

## Main Analysis

<!-- CRITICAL: Write 4-8 detailed findings, each 300-500 words -->
<!-- Each finding should have multiple paragraphs with evidence -->
<!-- Include specific data, quotes, statistics, not vague statements -->
<!-- PRECISION: Use exact numbers, specific metrics, no fluff words -->
<!-- "mortality reduced 23%" not "significantly improved" -->
<!-- "5 trials (n=1,847)" not "several studies" -->

### Finding 1: [Descriptive Title That Captures the Key Point]

[Opening paragraph: State the finding clearly and why it matters]

[Body paragraphs:
- Present detailed evidence
- Include specific data, statistics, dates, numbers
- Explain mechanisms, causes, or relationships
- Discuss implications
- Address nuances or exceptions
]

**Key Evidence:**
- Data point 1 from Source A [1]
- Data point 2 from Source B [2]
- Conflicting view from Source C [3] and how it was resolved

**Implications:**
[1-2 paragraphs on what this finding means for the user's decision/understanding]

**Sources:** [1], [2], [3], [4]

---

### Finding 2: [Descriptive Title]

[Follow same detailed structure as Finding 1]
[Minimum 300 words per finding]
[Include multiple paragraphs with evidence]

**Sources:** [5], [6], [7], [8]

---

### Finding 3: [Descriptive Title]

[Continue with same detail level]

**Sources:** [9], [10], [11]

---

### Finding 4: [Descriptive Title]

[And so on... Include 4-8 major findings minimum]

**Sources:** [12], [13], [14]

---

[Continue with additional findings as needed]

---

## Synthesis & Insights

<!-- This section should be 500-1000 words -->
<!-- Go beyond just summarizing - generate NEW insights -->

### Patterns Identified

[2-3 paragraphs identifying key patterns across findings]

**Pattern 1: [Name]**
[Explain the pattern in detail, cite which findings support it]

**Pattern 2: [Name]**
[Continue...]

### Novel Insights

[2-3 paragraphs of insights that go BEYOND what sources explicitly stated]

**Insight 1: [Name]**
[What you discovered by connecting information across sources]
[Why this matters even though no single source said it explicitly]

**Insight 2: [Name]**
[Continue...]

### Implications

[2-3 paragraphs on what all this means]

**For [User Context]:**
[Specific implications for the user's situation/decision]

**Broader Implications:**
[Wider significance of these findings]

**Second-Order Effects:**
[What might happen as consequences of these findings]

---

## Limitations & Caveats

<!-- Be honest and comprehensive about what's uncertain -->

### Counterevidence Register

<!-- Document findings that contradict or challenge main conclusions -->

[2-3 paragraphs explaining contradictory evidence found during research]

**Contradictory Finding 1:** [Description]
- Source: [Citation]
- Why it contradicts: [Explanation]
- How resolved/interpreted: [Your analysis]
- Impact on conclusions: [Minimal/Moderate/Significant]

**Contradictory Finding 2:** [Continue...]

### Known Gaps

[2-3 paragraphs explaining:]
- What information was not available
- What questions remain unanswered
- What would strengthen this research

**Gap 1:** [Description]
- Why it's missing
- How it affects conclusions
- How to address it in future research

**Gap 2:** [Continue...]

### Assumptions

[Revisit key assumptions from intro, now with more detail on their validity]

**Assumption 1:** [Restate]
- Evidence supporting it: [...]
- Evidence challenging it: [...]
- Overall validity: [...]

### Areas of Uncertainty

[2-3 paragraphs on:]
- Where sources disagree
- Where evidence is thin
- Where extrapolation was necessary
- What could change conclusions

**Uncertainty 1:** [Topic]
[Detailed explanation of what's uncertain and why]

**Uncertainty 2:** [Continue...]

---

## Recommendations

<!-- Make this actionable and specific -->

### Immediate Actions

[3-5 specific actions the user should take NOW]

1. **[Action Title]**
   - What: [Specific action]
   - Why: [Rationale based on findings]
   - How: [Implementation steps]
   - Timeline: [When to do this]

2. **[Continue with similar detail...]**

### Next Steps

[3-5 actions for the near-term future (1-3 months)]

1. **[Step Title]**
   - [Similar detailed structure]

### Further Research Needs

[3-5 areas where additional research would be valuable]

1. **[Research Topic]**
   - What to investigate: [Specific question]
   - Why it matters: [Connection to current findings]
   - Suggested approach: [How to research it]

---

## Bibliography

<!-- ============================================================================ -->
<!-- CRITICAL: Generate COMPLETE bibliography with ALL sources cited in report   -->
<!-- DO NOT use placeholders like "[8-75] Additional citations" or "etc."        -->
<!-- DO NOT use "...continue..." or "[Continue with all sources...]"             -->
<!-- EVERY citation [N] in report body MUST have corresponding entry here        -->
<!-- If report cites [1]-[25], bibliography MUST contain all 25 complete entries -->
<!-- Format: [N] Author/Organization (Year). "Title". Publication. URL           -->
<!-- ============================================================================ -->

[1] Author Name or Organization (2025). "Full Title of Article or Paper". Publication Name or Website. https://full-url.com (Retrieved: 2025-11-04)

[2] Second Author (2024). "Second Article Title". Journal Name, Volume(Issue), pages. https://doi-or-url.com (Retrieved: 2025-11-04)

<!-- Add ALL remaining citations [3] through [N] here -->
<!-- Standard reports: 15-30 sources | Deep/UltraDeep: 30-50 sources -->
<!-- Write each entry completely - NO ranges, NO "etc.", NO placeholders -->

---

## Appendix: Methodology

### Research Process

[2-3 paragraphs describing the research process in detail]

**Phase Execution:**
- Phase 1 (SCOPE): [What was done]
- Phase 2 (PLAN): [What was done]
- Phase 3 (RETRIEVE): [What was done]
- [Continue for all phases executed]

### Sources Consulted

**Total Sources:** [Number]

**Source Types:**
- Academic journals: [Number]
- Industry reports: [Number]
- News articles: [Number]
- Government/regulatory: [Number]
- Documentation: [Number]
- [Other categories]

**Geographic Coverage:**
[If relevant, note geographic distribution of sources]

**Temporal Coverage:**
[Date range of sources, recency distribution]

### Verification Approach

[2-3 paragraphs explaining:]

**Triangulation:**
- How claims were verified across multiple sources
- Minimum sources required per major claim: 3
- How contradictions were handled

**Credibility Assessment:**
- How source quality was evaluated
- Scoring system used (0-100)
- Average credibility score: [Number]/100
- Distribution: [High/medium/low source counts]

**Quality Control:**
- Validation checks performed
- Issues found and corrected
- Final quality metrics

### Claims-Evidence Table

<!-- Explicit mapping of major claims to supporting sources -->

| Claim ID | Major Claim | Evidence Type | Supporting Sources | Confidence |
|----------|-------------|---------------|-------------------|------------|
| C1 | [First major claim from findings] | [Primary data / Meta-analysis / Expert opinion] | [1], [2], [3] | High / Medium / Low |
| C2 | [Second major claim] | [Evidence type] | [4], [5], [6] | High / Medium / Low |
| C3 | [Third major claim] | [Evidence type] | [7], [8] | High / Medium / Low |
| ... | [Continue for all major claims] | ... | ... | ... |

**Confidence Levels:**
- **High**: 3+ independent sources, consistent findings, strong methodology
- **Medium**: 2 sources OR single high-quality source with minor contradictions
- **Low**: Single source OR significant contradictions in evidence

---

## Report Metadata

**Research Mode:** [Quick/Standard/Deep/UltraDeep]
**Total Sources:** [Number]
**Word Count:** [Approximate count]
**Research Duration:** [Time taken]
**Generated:** [Date and time]
**Validation Status:** [Passed with X warnings / Passed without warnings]

---

<!-- END OF TEMPLATE -->
<!-- Remember: Write COMPREHENSIVE, DETAILED reports -->
<!-- Target 2,000-5,000 words minimum, more for deep modes -->
<!-- Include specific data, evidence, and analysis throughout -->
