---
name: deep-research
description: |
  複雑なトピックについて段階的に深く調査し、包括的なレポートを生成するスキル。
  ユーザーが「詳しく調べて」「深く調査」「リサーチして」「research」などを要求したときに発動。
  複数の視点から情報を収集・分析し、構造化されたレポートを作成する。
allowed-tools:
  - bash
metadata:
  author: skill-creator
  version: 1.0.0
---

# Deep Research

複雑なトピックについて段階的に深く調査し、包括的なレポートを生成するスキル。

## Overview

このスキルは以下のような場合に使用します：
- 複雑なトピックについて多角的な調査が必要な場合
- 単純な回答では不十分で、深い分析が求められる場合
- 調査結果を構造化されたレポートとしてまとめたい場合

## Workflow

### 1. 調査計画の立案
- ユーザーの質問・トピックを分析
- 調査すべき観点（サブトピック）を特定
- 調査の深さと範囲を決定

### 2. 段階的調査
各サブトピックについて以下を実施：
- **背景・定義**: 基本的な概念と歴史的背景
- **現状分析**: 最新の状況とトレンド
- **多角的視点**: 異なる立場・視点からの分析
- **課題と論点**: 主要な問題点と議論
- **将来展望**: 今後の予測と可能性

### 3. 統合分析
- 収集した情報を統合
- 関連性や因果関係を分析
- 重要なポイントを抽出

### 4. レポート生成
以下の構造でMarkdownレポートを作成：
```
# [トピック名] 調査レポート

## エグゼクティブサマリー
- 主要な発見
- 重要な結論

## 1. 背景と概要
## 2. 詳細分析
### 2.1 [サブトピック1]
### 2.2 [サブトピック2]
...
## 3. 統合的考察
## 4. 結論と提言
## 5. 参考情報
```

### 5. 保存（オプション）
生成したレポートを保存：
```bash
python skills/deep-research/scripts/save_report.py \
  --topic "トピック名" \
  --output ./output/research_reports/
```

## Available Resources

### Scripts
- `scripts/save_report.py` - 調査レポートをファイルに保存するスクリプト

### References
- `references/research_template.md` - レポートテンプレート
- `references/research_methodology.md` - 調査手法のガイドライン

## Examples

### 例1: 技術調査
```
ユーザー: 「量子コンピュータについて深く調査してください」

手順:
1. 調査計画:
   - 量子コンピュータの原理
   - 現在の技術レベル
   - 主要な企業・研究機関
   - 応用分野
   - 課題と展望

2. 各観点について詳細調査

3. 包括的レポート生成
```

### 例2: ビジネス分析
```
ユーザー: 「EV市場の動向をリサーチして」

手順:
1. 市場規模と成長率
2. 主要プレイヤー分析
3. 技術トレンド
4. 規制環境
5. 競合分析
6. 将来予測
```

## Best Practices

### 調査の深さ
- **浅い調査**: 3-5個のサブトピック、各300-500語
- **標準調査**: 5-8個のサブトピック、各500-800語
- **深い調査**: 8-12個のサブトピック、各800-1200語

### 情報の質
- 複数の視点を含める
- 具体的な例やデータを使用
- 主張には論拠を示す
- 不確実性や限界を明記

### レポート構造
- 見出しを適切に使用（h2, h3）
- 箇条書きで要点を整理
- 重要な情報を強調（**太字**）
- 長い段落は避ける（3-5文程度）

## Constraints

- 調査は利用可能な知識ベースに基づく
- リアルタイムの情報取得は不可（API連携が必要）
- 非常に専門的な内容は限界がある場合がある
- レポート生成には数分かかる場合がある
- 保存するレポートのファイル名は自動生成される（タイムスタンプ付き）

## Output Format

レポートは以下の形式で出力：
1. **画面表示**: Markdown形式で全文表示
2. **ファイル保存**（オプション）: `YYYYMMDD_HHMMSS_topic.md`

## Tips

- 具体的な調査範囲を指定すると精度が向上
- 「〜の観点から」と視点を指定可能
- 「簡易版」「詳細版」で深さを調整可能
- 途中経過の確認も可能
