# Deep Research 調査手法ガイドライン

## 調査の原則

### 1. 体系的アプローチ
- **構造化**: トピックを論理的に分解
- **段階的**: 基礎から応用へ順序立てて調査
- **包括的**: 複数の視点を含める

### 2. 客観性
- **バランス**: 異なる立場や意見を公平に扱う
- **根拠**: 主張には論拠を示す
- **透明性**: 情報源や限界を明記

### 3. 深さと広さのバランス
- **深さ**: 重要なポイントは詳細に分析
- **広さ**: 関連する周辺領域もカバー
- **焦点**: 最も重要な部分を強調

## 調査プロセス

### Phase 1: 準備（Planning）

#### 1.1 トピックの理解
```
質問:
- このトピックの核心は何か？
- なぜこの調査が必要か？
- どのような情報が求められているか？
```

#### 1.2 スコープ設定
- **範囲**: 何を含め、何を除外するか
- **深さ**: どのレベルまで掘り下げるか
- **時間軸**: 過去・現在・未来のどこに焦点を当てるか

#### 1.3 調査計画
```
サブトピックのリスト作成:
1. [基礎]
2. [現状]
3. [課題]
4. [将来]
```

### Phase 2: 情報収集（Research）

#### 2.1 各サブトピックの調査
各サブトピックについて以下を調査:

**基本情報**:
- 定義と概念
- 歴史と発展
- 現在の状況

**詳細分析**:
- 主要な要素・プレイヤー
- メカニズムや仕組み
- データや事例

**多角的視点**:
- 技術的側面
- 経済的側面
- 社会的側面
- 環境的側面
- 政治的側面

#### 2.2 情報の構造化
```
各サブトピックを以下の形式で整理:

### [サブトピック名]

**概要**: [1-2文で要約]

**詳細**:
- ポイント1
- ポイント2
- ポイント3

**重要性**: [なぜ重要か]

**関連**: [他のトピックとの関連]
```

### Phase 3: 分析（Analysis）

#### 3.1 横断的分析
- 共通パターンの発見
- 因果関係の特定
- 相互作用の理解

#### 3.2 批判的思考
```
質問:
- この情報は信頼できるか？
- 他の解釈は可能か？
- 何が欠けているか？
- バイアスはないか？
```

#### 3.3 統合
- 断片的な情報を統合
- 全体像の構築
- 主要なインサイトの抽出

### Phase 4: 合成（Synthesis）

#### 4.1 レポート構成
```
構造:
1. サマリー（結論先出し）
2. 背景（文脈の提供）
3. 詳細（主要な分析）
4. 考察（統合的な洞察）
5. 結論（主要なポイント）
```

#### 4.2 ライティング原則
- **明確性**: 専門用語は説明する
- **簡潔性**: 冗長な表現を避ける
- **構造**: 見出しと段落を適切に使用
- **強調**: 重要なポイントを目立たせる

## 調査の深さレベル

### Level 1: 概要調査（Quick Survey）
**所要時間**: 5-10分  
**サブトピック**: 3-5個  
**各トピック**: 200-300語  
**適用場面**: 基本的な理解が必要な場合

**構成**:
1. 定義と背景
2. 現状
3. 主要な論点
4. 簡単な結論

### Level 2: 標準調査（Standard Research）
**所要時間**: 15-30分  
**サブトピック**: 5-8個  
**各トピック**: 500-800語  
**適用場面**: 一般的な調査ニーズ

**構成**:
1. 背景と概要
2. 複数の観点からの分析
3. 課題と論点
4. 将来展望
5. 結論と提言

### Level 3: 深層調査（Deep Research）
**所要時間**: 45分以上  
**サブトピック**: 8-12個  
**各トピック**: 800-1200語  
**適用場面**: 包括的な理解が必要な場合

**構成**:
1. 詳細な背景分析
2. 多角的な詳細分析
3. ケーススタディ
4. シナリオ分析
5. 統合的考察
6. 詳細な提言

## トピック別アプローチ

### 技術トピック
重点項目:
- 技術の原理とメカニズム
- 発展の歴史とマイルストーン
- 現在の技術レベル
- 主要な企業・研究機関
- 応用分野と事例
- 技術的課題
- 競合技術との比較
- 将来の可能性

### ビジネストピック
重点項目:
- 市場規模と成長率
- 業界構造と主要プレイヤー
- ビジネスモデル
- 競争環境（5forces等）
- 成功/失敗事例
- トレンドと変化の兆し
- 規制環境
- 将来予測

### 社会トピック
重点項目:
- 問題の定義と背景
- ステークホルダー分析
- 現状と統計データ
- 原因と影響
- 既存の取り組み
- 異なる視点・立場
- 課題と論点
- 解決策と提言

### 学術トピック
重点項目:
- 理論的枠組み
- 主要な研究と発見
- 研究手法
- 議論と論争
- 知識のギャップ
- 最新の動向
- 実践的応用
- 今後の研究方向

## 品質チェックリスト

### 内容の質
- [ ] トピックを包括的にカバーしている
- [ ] 重要なポイントが明確
- [ ] 複数の視点を含んでいる
- [ ] 具体例やデータがある
- [ ] 論理的に一貫している
- [ ] バイアスを避けている

### 構造の質
- [ ] 明確な構成がある
- [ ] 見出しが適切
- [ ] 段落が論理的
- [ ] 情報の流れがスムーズ
- [ ] サマリーが効果的

### 表現の質
- [ ] 明確で理解しやすい
- [ ] 専門用語が説明されている
- [ ] 適切な長さ
- [ ] 視覚的に読みやすい
- [ ] 誤字脱字がない

### 価値の質
- [ ] 新しい洞察がある
- [ ] 実用的な情報を含む
- [ ] 客観的で信頼できる
- [ ] 適切な深さ
- [ ] 読者のニーズに応えている

## よくある落とし穴

### 1. 範囲の問題
- **広すぎる**: 焦点が定まらない、表面的
- **狭すぎる**: 重要な関連情報が欠ける
- **解決策**: スコープを明確に定義する

### 2. 深さの問題
- **浅すぎる**: 既知の情報のみ、洞察がない
- **深すぎる**: 本質を見失う、細部にこだわりすぎ
- **解決策**: 重要度に応じてメリハリをつける

### 3. バランスの問題
- **偏り**: 特定の視点のみ
- **平板**: すべて同じ重みで扱う
- **解決策**: 複数視点を含めつつ、重要な部分を強調

### 4. 構造の問題
- **無秩序**: 論理的な流れがない
- **硬直的**: テンプレートに縛られすぎ
- **解決策**: 柔軟に構造を調整する

## ベストプラクティス

### 1. 逆ピラミッド方式
最も重要な情報を最初に提示:
```
1. 結論・重要な発見（サマリー）
2. 主要な分析
3. 詳細と補足
4. 参考情報
```

### 2. レイヤー構造
異なる詳細レベルを提供:
```
- Level 1: 見出しだけで全体像を把握
- Level 2: 各セクションの冒頭で要点を把握
- Level 3: 詳細を読んで深い理解
```

### 3. シグナリング
重要な情報を明示:
```
- **重要**: [重要なポイント]
- ⚠️ **注意**: [注意事項]
- 💡 **インサイト**: [洞察]
- 📊 **データ**: [データポイント]
```

### 4. コンテキスト提供
情報に文脈を与える:
```
- なぜ重要か
- どのように関連するか
- 何を意味するか
```

## 参考リソース

### 調査フレームワーク
- **PESTEL分析**: 政治・経済・社会・技術・環境・法律
- **SWOT分析**: 強み・弱み・機会・脅威
- **5Forces**: 競争環境分析
- **バリューチェーン**: 価値創造プロセス

### 思考ツール
- **クリティカルシンキング**: 批判的思考
- **システム思考**: 全体像と相互作用
- **デザイン思考**: 問題解決アプローチ
- **シナリオプランニング**: 将来予測

### レポーティング
- **ピラミッド原則**: 論理構造
- **ストーリーテリング**: 効果的な伝達
- **データビジュアライゼーション**: 視覚化（テキストでの表現）
