# DeepResearch Report QA Checklist

Run this checklist before delivery. Each item must be checked off.

## A. Scope & Structure
- [ ] Main question and time window are clear, Non-goals are explicit
- [ ] KIQ ≤ 7 and each is answered
- [ ] Conclusion-first (Key Judgments at front)

## B. Evidence & Citations
- [ ] Each key judgment has evidence anchor (not stacked links)
- [ ] Key numbers/facts are traceable to original sources or derivation chains
- [ ] Citation information sufficient for location (title/organization/date/URL/access date/page or paragraph)
- [ ] Key web pages archived/screenshotted/downloaded to prevent link failure

## C. Reasoning & Alternative Explanations
- [ ] Clearly distinguish fact vs judgment vs inference
- [ ] At least 1 alternative explanation is seriously presented and evaluated
- [ ] Key assumptions are explicit, vulnerability and verification paths are clear
- [ ] Conflicting evidence is recorded and choice explained

## D. Uncertainty Expression
- [ ] Each key judgment includes Likelihood + Confidence
- [ ] Probability words used consistently; avoid vague evasive words (e.g., apparently/reportedly without explanation)
- [ ] "What evidence would change conclusion" is written (flip conditions)

## E. Usability & Actionability
- [ ] Provides executable recommendations or options (including risks/costs)
- [ ] Has monitoring indicators/signals (signposts) for continuous updates
- [ ] Report length and detail match audience (management can read in 5 minutes; appendices auditable)

## Quick Validation (10 minutes)

For each Key Judgment, ask three questions:

1. **Can I find the original evidence supporting it in 30 seconds?** (Traceability)
2. **Is there a seriously treated alternative explanation? Why was it excluded?** (Alternative hypotheses)
3. **Is this judgment's likelihood/confidence clearly written? Where does uncertainty come from?** (Uncertainty)

If any fails, the report cannot be considered "deliverable deepresearch".

## Red Team Pressure Test (60 minutes)

- Assign one reviewer as Devil's Advocate: specifically target key assumptions, weak evidence chains, possible deception/selective evidence
- Require author to supplement:
  - How disconfirming and conflicting evidence is handled
  - What new information would trigger revision (indicators)

## Bad Report Warning Signs

- **Lots of information but no judgments**, or lots of judgments but missing evidence chains
- Citations "look formal" but **cannot locate original sources**, or citations don't match assertions
- Using "apparently / reportedly (unmodified) / someone said" to replace evidence and responsibility
- Not writing alternative hypotheses; pretending conflicting evidence doesn't exist
- Mixing likelihood and confidence in same sentence, causing readers to misread certainty
