# DeepResearch Report Evaluation Rubric

8-dimension rubric for evaluating DeepResearch report quality. Each dimension scored 1-5. Any dimension scoring ≤2 indicates the report is not suitable for DeepResearch delivery (at most, it's a literature review).

## Dimension 1: Problem & Scope (Scope Discipline)

**5 Points**: Research questions are testable; scope boundaries clear (what's covered/what's not); key definitions explicit; research path explains why this decomposition.

**4 Points**: Questions testable, scope mostly clear, minor gaps in definitions.

**3 Points**: Questions somewhat testable, scope has some ambiguity, definitions need clarification.

**2 Points**: Questions vague, scope boundaries unclear, definitions missing.

**1 Point**: Topic is vague, scope drifts, conclusions actually answer a different question.

**Key Questions**:
- Is the research question falsifiable and testable?
- Are scope boundaries (includes/excludes) explicit?
- Are key terms and definitions clear?
- Can the research path be justified?

---

## Dimension 2: Source Coverage & Collection Strategy (Source Strategy)

**5 Points**: Explains "which source categories used, why credible, what are blind spots"; can identify key information gaps and gap-filling plans. ICD 203 requires "based on all available sources, and identify key gaps."

**4 Points**: Good source coverage, minor gaps in strategy explanation.

**3 Points**: Adequate sources, strategy explanation incomplete.

**2 Points**: Limited source types, strategy unclear, gaps not acknowledged.

**1 Point**: Relies on single information source or secondary retellings; gaps not acknowledged.

**Key Questions**:
- Are multiple source types used (official, company, media, academic, etc.)?
- Is there a cross-validation strategy (at least two complementary source types)?
- Are information gaps explicitly identified?
- Is the collection strategy explained and justified?

---

## Dimension 3: Citations & Traceability (Traceability)

**5 Points**: Key assertions have verifiable citations; citation information sufficient to locate original sources; prefer citing most original sources; not "stacking links" but enabling readers to assess source quality.

**4 Points**: Most assertions have citations, minor gaps in traceability.

**3 Points**: Some citations present, but many assertions lack traceability.

**2 Points**: Citations missing or don't match assertions; citations are news retellings, original evidence missing.

**1 Point**: No citations or citations don't match assertions; citations are second- or third-hand, original evidence missing.

**Key Questions**:
- Can each key assertion be traced to a source?
- Are citations sufficient to locate original sources (title, date, URL, access date, page/paragraph)?
- Are original sources preferred over secondary sources?
- Can readers assess source quality from citations?

---

## Dimension 4: Evidence Assessment (Evidence Quality)

**5 Points**: For key sources, writes assessment of "quality/credibility/bias/timeliness/possible deception and misinformation"; can explain which sources most support key judgments. ICD 203/206 emphasize describing source quality and credibility factors.

**4 Points**: Most sources assessed, minor gaps in assessment depth.

**3 Points**: Some source assessment, but inconsistent or incomplete.

**2 Points**: Treats all sources as equivalent; "selectively ignores" conflicting evidence.

**1 Point**: Treats all sources as equivalent; selectively ignores conflicting evidence.

**Key Questions**:
- Are source reliability and credibility assessed?
- Are bias risks identified?
- Are conflicting sources explicitly addressed?
- Is evidence strength graded (Strong/Medium/Weak) with rationale?

---

## Dimension 5: Reasoning Chain & Alternative Explanations (Analytic Rigor)

**5 Points**: Conclusions clearly derived from evidence and reasoning; lists reasonable alternative hypotheses and explains why not chosen; explicitly writes key assumptions and "what would change judgment" indicators.

**4 Points**: Good reasoning, alternative explanations present but could be stronger.

**3 Points**: Some reasoning present, alternative explanations mentioned but not deeply evaluated.

**2 Points**: Conclusions read like opinions; no disconfirming evidence handling; no discussion of alternatives.

**1 Point**: Conclusions read like opinions; no disconfirming evidence handling; no discussion of alternative explanations.

**Key Questions**:
- Can conclusions be traced to evidence?
- Are alternative explanations seriously considered and evaluated?
- Are key assumptions explicit?
- Are "flip conditions" (what would change the judgment) identified?

---

## Dimension 6: Uncertainty Expression (Uncertainty & Calibration)

**5 Points**: Each key judgment states likelihood + confidence, and explains uncertainty sources; probability words used consistently, no mixing systems; doesn't mix likelihood/confidence in same sentence causing confusion.

**4 Points**: Most judgments include uncertainty, minor inconsistencies.

**3 Points**: Some uncertainty expression, but inconsistent or incomplete.

**2 Points**: Throughout uses "possibly/maybe"; or uses strong language to mask weak evidence; appears Kent's "weasel words."

**1 Point**: Throughout uses "possibly/maybe"; or uses strong language to mask weak evidence; appears Kent's "weasel words."

**Key Questions**:
- Does each key judgment include likelihood (probability word) and confidence (High/Medium/Low)?
- Are probability words used consistently?
- Are uncertainty sources explained?
- Are "weasel words" (apparently/reportedly without assessment) avoided?

---

## Dimension 7: Verification & Anti-Manipulation (Verification / Anti-disinfo)

**5 Points**: For UGC/breaking information, defaults to skepticism, first verifies source, time, location, motivation, and triangulation; records verification path and failure points. Verification Handbook emphasizes "assume content is inaccurate first," verify source and content, and "triangulate & challenge."

**4 Points**: Good verification practices, minor gaps in documentation.

**3 Points**: Some verification, but incomplete or inconsistent.

**2 Points**: Treats social media/reposts as facts; no source tracing or cross-validation.

**1 Point**: Treats social media/reposts as facts; no source tracing or cross-validation.

**Key Questions**:
- Is UGC/breaking information verified before use?
- Are source, time, location, and motivation checked?
- Is triangulation (cross-validation) performed?
- Is the verification path documented?

---

## Dimension 8: Expression & Usability (Utility)

**5 Points**: Conclusion-first, clear hierarchy, readers can quickly grasp "so what"; uses charts/tables to enhance understanding when needed; product format facilitates reuse and redistribution. ICD 203 requires clear logical argument and "effective visualization"; ICD 208 emphasizes discoverable/accessible/reusable.

**4 Points**: Generally clear and usable, minor improvements possible.

**3 Points**: Somewhat clear, but could be more structured or actionable.

**2 Points**: Information dump; after reading, unclear what to do; key numbers/comparisons not systematic.

**1 Point**: Information dump; after reading, unclear what to do; key numbers/comparisons not systematic.

**Key Questions**:
- Is the report conclusion-first and well-structured?
- Can decision-makers quickly understand key points?
- Are visualizations (tables, charts) used effectively when helpful?
- Is the format suitable for the audience and decision context?

---

## Quick Validation Method (10 Minutes)

For each Key Judgment, ask three questions:

1. **Can I find the original evidence supporting it in 30 seconds?** (Traceability)
2. **Is there a seriously treated alternative explanation? Why was it excluded?** (Alternative hypotheses)
3. **Is this judgment's likelihood/confidence clearly written? Where does uncertainty come from?** (Uncertainty)

**If any fails, the report cannot be considered "deliverable DeepResearch."**

---

## Red Team Pressure Test (60 Minutes)

- Assign one reviewer as Devil's Advocate: specifically target key assumptions, weak evidence chains, possible deception/selective evidence
- Require author to supplement:
  - How disconfirming and conflicting evidence is handled
  - What new information would trigger revision (indicators)

---

## Bad Report Warning Signs

- **Lots of information but no judgments**, or lots of judgments but missing evidence chains
- Citations "look formal" but **cannot locate original sources**, or citations don't match assertions
- Using "apparently / reportedly (unmodified) / someone said" to replace evidence and responsibility
- Not writing alternative hypotheses; pretending conflicting evidence doesn't exist
- Mixing likelihood and confidence in same sentence, causing readers to misread certainty

---

## Scoring Interpretation

- **35-40 points (4.4-5.0 average)**: Excellent, ready for delivery
- **28-34 points (3.5-4.3 average)**: Good, minor revisions needed
- **21-27 points (2.6-3.4 average)**: Adequate, significant revisions needed
- **≤20 points (≤2.5 average)**: Not suitable for DeepResearch delivery, major revision required

**Any dimension ≤2**: Report should not be delivered as DeepResearch until that dimension is addressed.

---

## References

- ICD 203: Analytic Standards
- ICD 206: Sourcing Requirements
- ICD 208: Analytic Product Usability
- Kent, Sherman. "Words of Estimative Probability"
- CIA Tradecraft Primer: Structured Analytic Techniques
