# 用户反馈分析框架

## 分类体系

### 1. 功能缺失 (Feature Gap)

用户明确表达希望产品具备但当前没有的功能。

**识别信号:**

- "wish it could..."
- "why can't I..."
- "would be nice if..."
- "希望能..."
- "要是有...就好了"
- "为什么不能..."

**分析要点:**

- 这是核心功能还是边缘需求？
- 竞品是否已有此功能？
- 实现难度和优先级？

### 2. 体验问题 (UX Issues)

产品有此功能，但使用体验不佳。

**识别信号:**

- "confusing / unintuitive"
- "took me forever to figure out"
- "太复杂 / 不直观"
- "找了半天才找到"
- "为什么要这样设计"

**细分类型:**

- 学习曲线过陡
- 操作步骤过多
- 界面布局不合理
- 反馈不明确
- 一致性问题

### 3. 性能问题 (Performance)

速度、稳定性、兼容性相关问题。

**识别信号:**

- "slow / laggy / freezes"
- "crashes all the time"
- "卡 / 慢 / 闪退"
- "又崩了"
- "占内存太大"

**细分类型:**

- 启动慢
- 操作响应慢
- 同步问题
- 崩溃/闪退
- 内存/电量消耗

### 4. 定价问题 (Pricing)

价格、付费模式、性价比相关。

**识别信号:**

- "too expensive / overpriced"
- "not worth the price"
- "太贵了 / 不值这个价"
- "free tier too limited"
- "为什么要订阅制"

**细分类型:**

- 绝对价格高
- 性价比低
- 免费版限制多
- 付费模式不合理
- 隐藏收费

### 5. 竞品对比 (Competitive Insights)

用户比较或迁移行为。

**识别信号:**

- "switched from X to Y"
- "X is better because..."
- "从 X 换到 Y"
- "比 X 好/差在..."
- "为什么不用 Y 呢"

**关注点:**

- 迁移原因
- 竞品优势
- 功能对比
- 价格对比

## 评估维度

### 频次评估

| 等级 | 描述 | 标准 |
|------|------|------|
| 高频 | 普遍问题 | 10+ 条独立反馈 |
| 中频 | 常见问题 | 5-10 条独立反馈 |
| 低频 | 个别反馈 | <5 条独立反馈 |

### 情绪强度

| 等级 | 描述 | 信号词 |
|------|------|--------|
| 强烈 | 愤怒/极度沮丧 | hate, terrible, unusable, 垃圾, 坑死 |
| 中等 | 不满/失望 | annoying, frustrating, 难用, 失望 |
| 轻微 | 建议/期望 | wish, would be nice, 希望, 建议 |

### 可操作性

| 等级 | 描述 |
|------|------|
| 高 | 明确的功能需求，可直接转化为产品任务 |
| 中 | 需要进一步调研才能确定解决方案 |
| 低 | 过于模糊或主观，难以落地 |

### 商业价值

| 等级 | 判断标准 |
|------|----------|
| 高 | 影响付费决策、用户留存 |
| 中 | 影响用户体验、口碑传播 |
| 低 | 边缘需求、少数用户关注 |

## 洞察提取模板

```markdown
### [痛点名称]

**分类**: 功能缺失 / 体验问题 / 性能问题 / 定价问题
**频次**: 高 / 中 / 低
**情绪强度**: 强烈 / 中等 / 轻微
**可操作性**: 高 / 中 / 低

**典型用户声音:**
> "原文引用..." — [来源](链接)
> "原文引用..." — [来源](链接)

**问题分析:**
[为什么用户会有这个痛点？背后的本质需求是什么？]

**竞品表现:**
[竞品如何解决这个问题？做得好还是也有同样问题？]

**产品建议:**
[具体可执行的改进建议]
```

## 优先级矩阵

根据频次 × 情绪强度 × 可操作性 确定优先级：

```
高优先级 = 高频 + 强烈情绪 + 高可操作性
中优先级 = 中频 + 中等情绪 + 中可操作性
低优先级 = 低频 或 轻微情绪 或 低可操作性
```

建议关注顺序：

1. 高频 + 强烈 → 紧急修复
2. 高频 + 中等 → 重要改进
3. 中频 + 强烈 → 关注小众强需求
4. 低频 + 轻微 → 暂时搁置
