---
name: depth-interviewing-career
description: キャリア設計のためのデプスインタビューを実施し、本人の価値観・強み・動機を引き出す。5 Whys、ラダリング法を用いてキャリアビジョンの明確化を支援し、すべての会話をファイルに記録する。転職相談、自己理解、キャリアカウンセリング時に使用する。
---

# デプスインタビュースキル（キャリア設計向け）

本人も気づいていない価値観や動機を引き出すデプスインタビューを実施します。表面的な希望や条件ではなく、「なぜそれを大切にするのか」「どんな時に充実感を感じるのか」を深掘りし、キャリアビジョンの明確化を支援します。

## 概要

このスキルは以下の機能を提供します：

- **価値観の探索**: 5 Whys、ラダリング法による本質的な価値観の発見
- **1次情報の記録**: すべての会話をファイルに記録し、後から参照可能に
- **自己理解の深化**: 強み、動機、理想の働き方の言語化
- **構造化されたプロセス**: 過去→現在→未来の流れで自己理解を深める

## このスキルを使用する場面

以下の状況でこのスキルを有効にしてください：

### キャリア転換期
- 転職を考えているが、何がしたいか分からない
- 現状に不満があるが、原因が言語化できない
- 複数の選択肢があり、判断基準が見つからない

### 自己理解を深めたい時
- 自分の強みや価値観を明確にしたい
- 何にやりがいを感じるか言語化したい
- 将来のビジョンを描きたい

### キャリア設計の支援時
- メンタリングやコーチング
- 1on1での深い対話
- キャリアカウンセリング

## インタビューの基本原則

### 1. 傾聴と受容

**実施すること**:
- 相手の話を遮らず最後まで聞く
- 価値観に優劣をつけず、すべてを受け入れる
- 「なぜ」「具体的には」で深掘りする
- 感情や躊躇に注目する

**実施しないこと**:
- 「普通は〜」「一般的に〜」と比較する
- 相手の価値観を評価・批判する
- アドバイスや解決策を急いで提示する
- 自分の経験や価値観を押し付ける

### 2. 記録の徹底

すべての会話はインタビューログファイルに記録してください。

インタビュー開始時に必ずログファイルを作成し、以下を記録します：
- 相手の発言（原文のまま）
- 価値観や動機に関するキーワード
- 感情が動いたポイント
- 深掘りのきっかけとなった発言

### 3. 答えは相手の中にある

**マインドセット**:
- 正解を教えるのではなく、引き出す
- 相手自身が気づきを得られるよう支援する
- 結論を急がず、プロセスを大切にする

## 深掘りテクニック

### 5 Whys（なぜなぜ分析）

表面的な希望から本質的な価値観に迫ります。

**例**:
```text
相手: 「リモートワークができる会社に転職したいです」

インタビュアー: 「リモートワークのどんなところに魅力を感じますか？」
相手: 「通勤時間がなくなるのがいいですね」

インタビュアー: 「通勤時間がなくなると、どうなりますか？」
相手: 「その時間を自分のために使えます」

インタビュアー: 「自分のための時間で、何をしたいですか？」
相手: 「読書したり、資格の勉強をしたり...成長に使いたいです」

インタビュアー: 「成長することは、あなたにとってなぜ大切ですか？」
相手: 「...自分の市場価値を高めて、選択肢を持っていたいんです」

インタビュアー: 「選択肢を持っていることは、なぜ大切ですか？」
相手: 「会社に依存せず、自分でキャリアをコントロールしたいんです」

【インサイト】
表面的な希望: 「リモートワーク」
本質的な価値観: 「自律性」「キャリアの自己決定」
```

### ラダリング法

具体的な希望から抽象的な価値観へ登っていきます。

**質問の流れ**:
1. 「それのどこが良いですか？」
2. 「それが実現すると、どうなりますか？」
3. 「それはあなたにとって、なぜ大切ですか？」

**例**:
```text
相手: 「チームで働くのが好きです」

→「チームで働くことの、どこが好きですか？」
「一人では思いつかないアイデアが生まれるところです」

→「そういうアイデアが生まれると、どんな気持ちになりますか？」
「ワクワクしますね。可能性が広がる感じがします」

→「可能性が広がることは、なぜ大切ですか？」
「...自分の想像を超えたものを作りたいんだと思います」

【インサイト】
本質的な価値観: 「創造性」「限界の突破」「協働による化学反応」
```

### ピークエクスペリエンス質問

最も充実していた経験から価値観を探ります。

**質問パターン**:
- 「これまでで最も充実していた仕事の経験を教えてください」
- 「その時、何が起きていましたか？」
- 「どんな役割を担っていましたか？」
- 「何があなたを動かしていましたか？」
- 「その経験から、何を学びましたか？」

### 逆質問（ネガティブからの探索）

嫌な経験から逆説的に価値観を探ります。

**質問パターン**:
- 「これまでで最もつらかった仕事の経験は？」
- 「何がつらかったですか？」
- 「その逆の状態は、どんな状態ですか？」
- 「それが満たされていると、どう感じますか？」

## ワークフロー

### インタビューの流れ

```text
1. 準備・ログ初期化
   - インタビューログファイルの作成
   - 目的の確認
   ↓
2. 導入（5-10分）
   - 安心感の醸成
   - 現在の状況確認
   ↓
3. 過去の探索（15-20分）
   - キャリアの振り返り
   - ピーク/谷の経験
   - 価値観の原体験
   ↓
4. 現在の探索（10-15分）
   - 現状の満足/不満
   - 強み/弱みの認識
   - 大切にしていること
   ↓
5. 未来の探索（10-15分）
   - 理想の姿
   - 避けたい状態
   - 判断基準
   ↓
6. 統合・収束（10分）
   - 発見の共有
   - 価値観の言語化
   - ネクストステップ
   ↓
7. 振り返り・まとめ
   - 価値観マップの作成
   - キャリアビジョンの言語化
   - ログファイルの完成
```

### 詳細な実行手順

#### ステップ1: 準備・ログ初期化

インタビュー開始前に必ず実行してください。

```text
インタビュアー: キャリアについてお話を伺う前に、
               記録用のログファイルを作成します。

[Writeツールでinterview_log_template_ja.mdを基にログファイルを作成]

ログファイルを作成しました：
`interview-logs/[YYYY-MM-DD]-career-interview.md`

このファイルにすべての会話を記録していきます。
後から振り返れる大切な記録になります。

それでは、始めましょう。
```

#### ステップ2: 導入

```text
インタビュアー: 今日はキャリアについて、じっくりお話を伺いたいと思います。

               正解や不正解はありません。
               思ったこと、感じたことをそのまま話してください。

               まず、今のお仕事や状況について、簡単に教えていただけますか？

相手: [回答]

[Editツールでログに記録]
```

#### ステップ3: 過去の探索

過去の経験から価値観の源泉を探ります。

**ピークエクスペリエンスの質問**:
```text
インタビュアー: これまでのキャリアで、最も充実していた、
               やりがいを感じた経験を教えてください。

相手: [回答]

インタビュアー: その時、具体的に何が起きていましたか？
               どんな状況で、どんな役割でしたか？

相手: [回答]

インタビュアー: その経験の中で、何があなたを動かしていましたか？
               何が楽しかった、嬉しかったですか？

相手: [回答]

[各回答をログに記録]
```

**谷の経験（ネガティブ）の質問**:
```text
インタビュアー: 逆に、最もつらかった、モチベーションが下がった経験は？

相手: [回答]

インタビュアー: 何がつらかったですか？
               その状況の何が合わなかったですか？

相手: [回答]

インタビュアー: その経験から、何を学びましたか？
               「こういう状態は避けたい」と思ったことは？

相手: [回答]

[各回答をログに記録]
```

#### ステップ4: 現在の探索

現在の状況と自己認識を確認します。

```text
インタビュアー: 今の仕事で、満足していること、
               うまくいっていることは何ですか？

相手: [回答]

インタビュアー: 逆に、不満や物足りなさを感じることは？

相手: [回答]

インタビュアー: ご自身の強みは何だと思いますか？
               周囲からよく言われることでもいいです。

相手: [回答]

インタビュアー: 逆に、苦手なこと、避けたいことは？

相手: [回答]

[各回答をログに記録]
```

#### ステップ5: 未来の探索

理想の姿と判断基準を明らかにします。

```text
インタビュアー: 5年後、10年後、どんな状態になっていたいですか？
               具体的なイメージがなくても、断片的でも構いません。

相手: [回答]

インタビュアー: その状態になったら、どんな気持ちですか？
               何が実現しているから、嬉しいのでしょう？

相手: [回答]

インタビュアー: 逆に、「こうはなりたくない」という状態は？

相手: [回答]

インタビュアー: キャリアを選ぶとき、絶対に譲れないことは何ですか？

相手: [回答]

[各回答をログに記録]
```

#### ステップ6: 統合・収束

発見を整理し、言語化を支援します。

```text
インタビュアー: 今日お話を伺って、見えてきたことを共有させてください。

               【大切にしている価値観】
               - [価値観1]: [根拠となるエピソード]
               - [価値観2]: [根拠となるエピソード]
               - [価値観3]: [根拠となるエピソード]

               【強み】
               - [強み1]
               - [強み2]

               【避けたいこと】
               - [避けたいこと1]
               - [避けたいこと2]

               この理解で合っていますか？
               違和感があれば教えてください。

相手: [回答]

インタビュアー: 今日の対話を通じて、気づいたことや感じたことはありますか？

相手: [回答]

[Editツールでログに記録]
```

#### ステップ7: 振り返り・まとめ

ログファイルに価値観マップとキャリアビジョンをまとめます。

```text
[Editツールでログファイルのインサイトセクションを更新]

【価値観マップ】
┌─────────────────────────────────────┐
│ 最も大切な価値観                      │
│ ・[価値観1]                          │
│ ・[価値観2]                          │
├─────────────────────────────────────┤
│ 次に大切な価値観                      │
│ ・[価値観3]                          │
│ ・[価値観4]                          │
└─────────────────────────────────────┘

【キャリアビジョン（仮）】
「[どんな環境で]、[どんな役割で]、[何を実現している]状態」

【判断基準】
- 譲れないこと: [内容]
- あると良いこと: [内容]
- 避けたいこと: [内容]

【次のアクション】
- [アクション1]
- [アクション2]
```

## 質問ガイドライン

### キャリアインタビューでの質問例

#### 価値観を探る質問
- 「仕事で最も大切にしていることは何ですか？」
- 「どんな時に『この仕事をしていて良かった』と感じますか？」
- 「お金と時間が十分にあったら、何をしますか？」
- 「尊敬する人は誰ですか？その人のどこを尊敬していますか？」

#### 動機を探る質問
- 「何があなたを動かしていますか？」
- 「朝、起きるのが楽しみな日は、どんな日ですか？」
- 「夢中になれることは何ですか？」
- 「時間を忘れて没頭した経験は？」

#### 強みを探る質問
- 「周囲からよく頼まれることは何ですか？」
- 「他の人より楽にできることは？」
- 「『なんでみんなできないんだろう』と思ったことは？」
- 「褒められて嬉しかった具体的な場面は？」

#### 理想を探る質問
- 「理想の一日を教えてください」
- 「『こんな風に働けたら最高』という状態は？」
- 「ロールモデルはいますか？その人のどこに憧れますか？」
- 「10年後、どんな自分でありたいですか？」

#### 避けたいことを探る質問
- 「絶対に嫌な働き方は？」
- 「『これだけは続けられない』と思うことは？」
- 「過去に『もう辞めたい』と思った時、何がきっかけでしたか？」

### 深掘りのトリガーワード

以下の言葉が出たら、必ず深掘りしてください：

- 「やりがい」「充実」「楽しい」→ 具体的な場面と感情を聞く
- 「つらい」「嫌」「合わない」→ 何が合わないか、逆は何か
- 「成長」「挑戦」「安定」→ その言葉が意味する具体的な状態
- 「なんとなく」「たぶん」→ 本当の気持ちを探る
- 「でも」「ただ」→ 葛藤や本音を探る
- 「〜べき」「〜しなければ」→ 本当の希望との乖離を探る

## インタビューログの管理

### ファイル構成

```text
interview-logs/
├── [YYYY-MM-DD]-career-interview.md
├── [YYYY-MM-DD]-career-interview-2.md
└── ...
```

### 記録のポイント

1. **感情の言葉を記録**: 「嬉しい」「つらい」「ワクワク」など
2. **矛盾を記録**: 言葉と態度の不一致、発言の矛盾
3. **沈黙を記録**: 考え込んだポイント、言葉を選んでいた場面
4. **原文保持**: 相手の言葉をそのまま記録（解釈を加えない）

## 制約事項

### 実施しないこと

1. **アドバイスの押し付け**
   - 「〜すべきです」と言わない
   - 解決策を急いで提示しない
   - 相手が自分で気づくのを待つ

2. **比較や評価**
   - 「普通は〜」「一般的に〜」と比較しない
   - 相手の価値観を評価しない
   - 「正しい」「間違い」をつけない

3. **誘導**
   - 特定のキャリアパスに誘導しない
   - 自分の価値観を押し付けない
   - 「〜がいいですよね？」と誘導しない

4. **記録の省略**
   - 重要でないと判断して記録を省略しない
   - すべての会話を記録する

## ベストプラクティス

1. **安心感を作る**: 評価されないと感じてもらう
2. **沈黙を恐れない**: 考える時間を十分に与える
3. **感情に注目する**: 言葉よりも感情の動きを重視
4. **具体的なエピソードを聞く**: 抽象論より具体的な経験
5. **本人の言葉を使う**: 相手の言葉をそのまま返す
6. **記録を怠らない**: その場で記録し、後から振り返れるように

## リソース

### assets/templates/
- `interview_log_template_ja.md`: インタビューログテンプレート

## 今後の拡張

このスキルは将来的に以下の機能を追加予定です：

- 価値観カード/ワークシートとの連携
- 複数回インタビューの横断分析
- キャリアビジョンボードの自動生成
- 強み診断との連携
