---
name: depth-interviewing-product
description: サービス開発のためのデプスインタビューを実施し、ユーザーの真のニーズ・課題・動機を引き出す。5 Whys、ラダリング法を用いてプロダクト開発に活かせるインサイトを発見し、すべての会話をファイルに記録する。ユーザーリサーチ、課題発見、ペルソナ構築時に使用する。
---

# デプスインタビュースキル（サービス開発向け）

ユーザーの真のニーズと課題を引き出すデプスインタビューを実施します。表面的な回答で終わらせず、行動の背景にある動機や文脈を深掘りし、サービス開発に活かせるインサイトを発見します。

## 概要

このスキルは以下の機能を提供します：

- **深層心理の探索**: 5 Whys、ラダリング法による本質的なニーズの発見
- **1次情報の記録**: すべての会話をファイルに記録し、後から参照可能に
- **インサイトの抽出**: 課題仮説、ペルソナ要素、機会領域の特定
- **構造化されたプロセス**: 導入→探索→深掘り→収束の流れ

## このスキルを使用する場面

以下の状況でこのスキルを有効にしてください：

### ユーザーリサーチ時
- 新規サービス開発のためのニーズ調査
- 既存プロダクトの課題発見
- ユーザーペルソナの構築
- カスタマージャーニーの理解

### 課題発見時
- 「何を作るべきか」が不明確な場合
- ユーザーの本当の困りごとを知りたい場合
- 表面的な要望の裏にある真のニーズを探りたい場合

## インタビューの基本原則

### 1. 傾聴と深掘り

**実施すること**:
- ユーザーの発言を遮らず最後まで聞く
- 「なぜ」「具体的には」で深掘りする
- 沈黙を恐れず、ユーザーが考える時間を与える
- 非言語的な情報（躊躇、強調）にも注目する

**実施しないこと**:
- 誘導質問をする（「〜ですよね？」）
- 自分の仮説を押し付ける
- 表面的な回答で満足する
- ユーザーの発言を否定・評価する

### 2. 記録の徹底

すべての会話はインタビューログファイルに記録してください。

インタビュー開始時に必ずログファイルを作成し、以下を記録します：
- ユーザーの発言（原文のまま）
- 重要なインサイト
- 非言語的な観察
- 深掘りのきっかけとなったポイント

### 3. 推測の禁止

**避けるべき表現**:
- 「おそらく〜でしょう」
- 「普通は〜ですよね」
- 「〜ということですね」（勝手なまとめ）

**推奨される表現**:
- 「もう少し詳しく教えていただけますか？」
- 「それは具体的にはどういうことですか？」
- 「なぜそう思われたのですか？」

## 深掘りテクニック

### 5 Whys（なぜなぜ分析）

表面的な回答から本質的な動機に迫るため、「なぜ」を繰り返します。
ただし、機械的に「なぜ？」と聞くのではなく、自然な会話の流れで深掘りします。

**例**:
```text
ユーザー: 「タスク管理アプリが使いにくいです」

インタビュアー: 「使いにくいと感じるのは、具体的にどんな時ですか？」
ユーザー: 「タスクを登録するのに時間がかかるんです」

インタビュアー: 「なるほど。登録に時間がかかると、どんな影響がありますか？」
ユーザー: 「面倒になって結局メモ帳に書いちゃうんです」

インタビュアー: 「メモ帳に書く方が良いと感じるのはなぜでしょう？」
ユーザー: 「すぐに書けて、考えを整理しながら書けるからです」

インタビュアー: 「考えを整理しながら書けることが大事なんですね。
               それはどんな場面で特に重要ですか？」
ユーザー: 「会議中にアイデアが浮かんだ時とか、急いでる時ですね」

【インサイト】
真のニーズ: 「思考を妨げない素早い記録」
表面的な課題: 「登録に時間がかかる」
本質的な課題: 「思考の流れを止めたくない」
```

### ラダリング法

属性→機能的価値→情緒的価値→本質的価値の順で深掘りします。

**質問の流れ**:
1. 「それのどこが良いですか？」（属性→機能的価値）
2. 「それが良いとどうなりますか？」（機能的価値→情緒的価値）
3. 「それはあなたにとってなぜ大切ですか？」（情緒的価値→本質的価値）

**例**:
```text
ユーザー: 「シンプルなデザインのアプリが好きです」

→「シンプルだと何が良いですか？」
「迷わずに使える」

→「迷わないとどんな気持ちになりますか？」
「ストレスを感じない、集中できる」

→「集中できることはなぜ大切ですか？」
「限られた時間で成果を出したいから」

【インサイト】
本質的価値: 「限られた時間で成果を出したい」
```

### 具体化の質問

抽象的な発言を具体的なエピソードに落とし込みます。

**パターン**:
- 「最近、それを感じた具体的な場面を教えてください」
- 「例えば、どんな時にそう思いましたか？」
- 「その時、具体的に何が起きましたか？」
- 「それは週に何回くらいありますか？」

### 比較の質問

他の選択肢と比較することで、価値判断の基準を探ります。

**パターン**:
- 「他の方法と比べて、なぜこれを選びましたか？」
- 「以前使っていたものと比べてどうですか？」
- 「もし〜がなかったら、どうしていましたか？」

## ワークフロー

### インタビューの流れ

```text
1. 準備・ログ初期化
   - インタビューログファイルの作成
   - 目的とテーマの確認
   ↓
2. 導入（5-10分）
   - 自己紹介と目的説明
   - アイスブレイク
   - 基本情報の確認
   ↓
3. 探索（15-20分）
   - オープンクエスチョンで広く聞く
   - 現状の行動・習慣を把握
   - 課題やペインポイントを探る
   ↓
4. 深掘り（15-20分）
   - 5 Whysで動機を探る
   - ラダリングで価値を探る
   - 具体的なエピソードを聞く
   ↓
5. 収束（5-10分）
   - 重要なポイントの確認
   - 追加で聞きたいことの確認
   - お礼と次のステップ
   ↓
6. 振り返り・まとめ
   - インサイトの整理
   - 課題仮説の言語化
   - ログファイルの完成
```

### 詳細な実行手順

#### ステップ1: 準備・ログ初期化

インタビュー開始前に必ず実行してください。

```text
インタビュアー: インタビューを始める前に、記録用のログファイルを作成します。

[Writeツールでinterview_log_template_ja.mdを基にログファイルを作成]

ログファイルを作成しました：
`interview-logs/[YYYY-MM-DD]-[テーマ]-interview.md`

このファイルにすべての会話を記録していきます。
それでは、インタビューを始めましょう。
```

#### ステップ2: 導入

```text
インタビュアー: 本日はお時間をいただきありがとうございます。

               今日は[テーマ]についてお話を伺いたいと思います。
               正解・不正解はありませんので、率直なお考えをお聞かせください。

               まず、簡単に自己紹介をお願いできますか？
               - お仕事や普段の活動について
               - [テーマ]との関わりについて

ユーザー: [回答]

[Editツールでログに記録]
```

#### ステップ3: 探索

オープンクエスチョンで広く状況を把握します。

**探索フェーズの質問例**:

```text
【現状把握】
- 普段、[テーマ]についてどのようにされていますか？
- 一日/一週間の中で、それにどれくらい時間を使っていますか？
- どんなツールやサービスを使っていますか？

【課題探索】
- [テーマ]について、困っていることや不満はありますか？
- 「もっとこうだったらいいのに」と思うことはありますか？
- 最近、[テーマ]で困った具体的な場面を教えてください

【行動観察】
- なぜそのやり方を選んでいますか？
- 他の方法を試したことはありますか？その結果は？
- 理想の状態はどんな感じですか？
```

#### ステップ4: 深掘り

探索フェーズで出てきた重要なポイントを深掘りします。

```text
インタビュアー: 先ほど「[重要な発言]」とおっしゃっていましたが、
               もう少し詳しく教えていただけますか？

ユーザー: [回答]

インタビュアー: なるほど。それは具体的にはどんな時に起きますか？

ユーザー: [回答]

インタビュアー: その時、どんな気持ちになりますか？

ユーザー: [回答]

[各回答をログに記録]
```

**深掘りの判断基準**:
- ユーザーが感情を込めて話したポイント
- 「実は」「本当は」などの言葉が出たポイント
- 矛盾や躊躇が見られたポイント
- 具体的なエピソードが出てきたポイント

#### ステップ5: 収束

```text
インタビュアー: ありがとうございます。
               今日お話しいただいた中で、特に重要だと感じたのは：

               1. [ポイント1]
               2. [ポイント2]
               3. [ポイント3]

               この理解で合っていますか？
               補足や訂正があれば教えてください。

ユーザー: [回答]

インタビュアー: 最後に、今日お話しした内容以外で、
               [テーマ]について伝えておきたいことはありますか？

ユーザー: [回答]

インタビュアー: 本日は貴重なお話をありがとうございました。
```

#### ステップ6: 振り返り・まとめ

インタビュー終了後、ログファイルにインサイトをまとめます。

```text
[Editツールでログファイルのインサイトセクションを更新]

【発見したインサイト】
1. 表面的な課題: [内容]
   本質的な課題: [内容]

2. 表面的なニーズ: [内容]
   真のニーズ: [内容]

【課題仮説】
「[ユーザー像]は、[状況]において、[課題]を抱えている。
なぜなら[理由]だから。」

【機会領域】
- [機会1]
- [機会2]

【次のアクション】
- [アクション1]
- [アクション2]
```

## 質問ガイドライン

### 良い質問の特徴

1. **オープンクエスチョン**
   - ○「どのようにしていますか？」
   - ×「〜していますか？」（Yes/Noで終わる）

2. **具体的な質問**
   - ○「最近の具体的な例を教えてください」
   - ×「一般的にどう思いますか？」

3. **中立的な質問**
   - ○「どう感じましたか？」
   - ×「困りましたよね？」（誘導）

4. **一つずつ聞く**
   - ○「まず〜について教えてください」
   - ×「〜、〜、〜について教えてください」

### 避けるべき質問

- **誘導質問**: 「〜は便利ですよね？」
- **仮定質問**: 「もし〜があったら使いますか？」（信頼性が低い）
- **複合質問**: 「〜と〜について、どう思いますか？」
- **専門用語**: ユーザーが理解できない言葉を使う

### 深掘りのトリガーワード

以下の言葉が出たら、必ず深掘りしてください：

- 「面倒」「大変」「困る」→ 具体的な状況と影響を聞く
- 「いつも」「毎回」→ 頻度と具体的なエピソードを聞く
- 「なんとなく」「たぶん」→ 本当の理由を探る
- 「でも」「ただ」→ 矛盾や葛藤を探る
- 「実は」「本当は」→ 隠れたニーズがある可能性

## インタビューログの管理

### ファイル構成

```text
interview-logs/
├── [YYYY-MM-DD]-[テーマ1]-interview.md
├── [YYYY-MM-DD]-[テーマ2]-interview.md
└── ...
```

### 記録のタイミング

- **即時記録**: ユーザーの発言は可能な限りそのまま記録
- **セクション終了時**: 各フェーズ終了時にインサイトを整理
- **インタビュー終了時**: 全体のまとめとインサイトを記録

### 記録のポイント

1. **原文保持**: ユーザーの言葉をそのまま記録（解釈を加えない）
2. **文脈記録**: 発言の背景や状況も記録
3. **観察記録**: 非言語的な情報（躊躇、強調、感情）も記録
4. **タイムスタンプ**: 重要な発言には時刻を記録

## 制約事項

### 実施しないこと

1. **推測や解釈の押し付け**
   - ユーザーの発言を勝手に解釈しない
   - 確認なしに「つまり〜ですね」とまとめない

2. **誘導や評価**
   - 特定の回答に誘導しない
   - ユーザーの発言を評価・批判しない

3. **仮説の検証に固執**
   - 事前の仮説に合う情報だけを集めない
   - 予想外の発見にもオープンでいる

4. **記録の省略**
   - 重要でないと判断して記録を省略しない
   - すべての会話を記録する

## ベストプラクティス

1. **ユーザーの言葉を使う**: 専門用語を避け、ユーザーの言葉で会話する
2. **沈黙を活用する**: 答えを急かさず、考える時間を与える
3. **好奇心を持つ**: 本当に知りたいという姿勢で質問する
4. **柔軟に対応する**: スクリプト通りに進めず、流れに応じて深掘りする
5. **記録を怠らない**: 「後で覚えている」と思わず、その場で記録する

## リソース

### assets/templates/
- `interview_log_template_ja.md`: インタビューログテンプレート

## 今後の拡張

このスキルは将来的に以下の機能を追加予定です：

- 複数インタビューの横断分析
- ペルソナ自動生成
- インサイトのパターン分析
- カスタマージャーニーマップ生成
