# Cover Design Templates & Specifications

Complete guide for designing book covers for print-on-demand and offset printing.

## Cover Anatomy

```
┌─────────────────────────────────────────────────────────────────┐
│ ← Bleed (0.125")                              Bleed (0.125") → │
│  ┌───────────────────────────────────────────────────────────┐  │
│  │                                                           │  │
│  │   BACK COVER          SPINE         FRONT COVER          │  │
│  │                                                           │  │
│  │   - Back cover copy   - Title       - Title               │  │
│  │   - Author bio        - Author      - Subtitle            │  │
│  │   - Blurbs            - Publisher   - Author name         │  │
│  │   - Barcode area      - Logo        - Cover image         │  │
│  │   - ISBN                            - Publisher logo      │  │
│  │                                                           │  │
│  └───────────────────────────────────────────────────────────┘  │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
        ↑                                           ↑
    Safe zone                                   Safe zone
    (0.25" from trim)                          (0.25" from trim)
```

## Spine Width Calculation

### Formula

```
Spine Width = Page Count × Paper Thickness
```

### Paper Thickness Values

| Paper Type | Thickness per Page | Notes |
|------------|-------------------|-------|
| White (standard) | 0.002252" | Most common |
| Cream/Natural | 0.0025" | Warmer, slightly thicker |
| Groundwood | 0.0030" | Mass market paperbacks |
| Premium white | 0.002" | Thinner, more pages per inch |

### Quick Reference Table

**White Paper (0.002252" per page):**

| Pages | Spine Width |
|-------|-------------|
| 100 | 0.225" |
| 150 | 0.338" |
| 200 | 0.450" |
| 250 | 0.563" |
| 300 | 0.676" |
| 350 | 0.788" |
| 400 | 0.901" |

**Cream Paper (0.0025" per page):**

| Pages | Spine Width |
|-------|-------------|
| 100 | 0.250" |
| 150 | 0.375" |
| 200 | 0.500" |
| 250 | 0.625" |
| 300 | 0.750" |
| 350 | 0.875" |
| 400 | 1.000" |

### Spine Text Guidelines

| Spine Width | Text Recommendation |
|-------------|---------------------|
| < 0.25" | No spine text (too thin) |
| 0.25" - 0.5" | Horizontal text only, small |
| 0.5" - 0.75" | Rotated text possible |
| > 0.75" | Full spine design possible |

**Text rotation:** Read from top to bottom (spine text reads when book is lying flat, front cover up)

## Full Cover Dimensions

### Calculation

```
Cover Width = Back Width + Spine Width + Front Width + (2 × Bleed)
Cover Height = Trim Height + (2 × Bleed)
```

### Example: 6" × 9" book, 200 pages, cream paper

```
Back Width:    6.0"
Spine Width:   200 × 0.0025 = 0.5"
Front Width:   6.0"
Bleed:         0.125" × 2 = 0.25"

Total Width:   6 + 0.5 + 6 + 0.25 = 12.75"
Total Height:  9 + 0.25 = 9.25"

Final dimensions: 12.75" × 9.25" at 300 DPI
```

## Safe Zones and Margins

### Critical Areas

| Zone | Distance from Trim | Content Rules |
|------|-------------------|---------------|
| Bleed | 0.125" outside | Background images/colors only |
| Trim | 0 (edge) | Cut line - nothing critical |
| Safe Zone | 0.25" inside | All text and important elements |
| Spine Safe | 0.0625" from spine edge | Text only in center of spine |

### Barcode Placement

**Standard barcode area:** 2" × 1.2"
**Placement:** Lower right of back cover
**Safe zone:** 0.25" from all edges
**Background:** White or light solid color

## Color Specifications

### Print Color Modes

| Print Type | Color Mode | Notes |
|------------|------------|-------|
| Full color cover | CMYK | Always CMYK, never RGB |
| Black & white interior | Grayscale | True grayscale, not CMYK black |
| Rich black | C:60 M:40 Y:40 K:100 | Large black areas on covers |

### Rich Black Formula

```
C: 60%
M: 40%
Y: 40%
K: 100%

Total ink coverage: 240% (under 300% max)
```

## File Specifications

### Technical Requirements

```yaml
Resolution: 300 DPI (minimum)
Color Mode: CMYK (for print)
File Format: PDF/X-1a:2001 or PDF/X-4
Bleed: 0.125" on all sides
Fonts: Embedded or outlined
Images: 300 DPI, CMYK
```

## POD Service Requirements

### Amazon KDP
- PDF format, embedded fonts
- 300 DPI images, bleed 0.125" required
- Cover calculator: https://kdp.amazon.com/cover-calculator

### IngramSpark
- PDF/X-1a:2001, CMYK color
- 300 DPI minimum, bleed 0.125"
- Template generator in publisher portal

### Lulu
- PDF format, 300 DPI
- Bleed included, CMYK preferred

## Quality Checklist

- [ ] Correct dimensions calculated
- [ ] Spine width verified for page count
- [ ] Bleed extends 0.125" all sides
- [ ] Text within safe zone (0.25" from trim)
- [ ] Spine text centered and readable
- [ ] Barcode area clear (2" × 1.2")
- [ ] Resolution 300 DPI minimum
- [ ] Color mode CMYK
- [ ] Fonts embedded or outlined
- [ ] Background extends to bleed edge
