# Typography Guide for Book Design

Comprehensive reference for typographic decisions in book production.

## The Anatomy of Type

### Key Measurements

- **Point (pt)**: 1/72 inch - standard unit for type size
- **Pica**: 12 points - used for line lengths and margins
- **Em**: Width equal to the type size (12pt type = 12pt em)
- **En**: Half an em
- **X-height**: Height of lowercase 'x' - affects readability
- **Leading**: Line spacing (baseline to baseline)

### Type Classification

**Old Style Serifs** (humanist, warm)
- Garamond, Caslon, Palatino, Bembo
- Best for: Literary fiction, memoirs, poetry
- Characteristics: Diagonal stress, moderate contrast

**Transitional Serifs** (balanced, refined)
- Baskerville, Times New Roman, Georgia
- Best for: General non-fiction, biographies
- Characteristics: Vertical stress, higher contrast

**Modern Serifs** (elegant, dramatic)
- Bodoni, Didot
- Best for: Fashion, art books, titles
- Characteristics: Extreme contrast, hairline serifs

**Slab Serifs** (sturdy, bold)
- Rockwell, Clarendon, Memphis
- Best for: Children's books, cookbooks
- Characteristics: Heavy, block-like serifs

**Sans Serifs** (clean, contemporary)
- Helvetica, Gill Sans, Futura, Avenir
- Best for: Modern non-fiction, technical books
- Characteristics: No serifs, geometric or humanist

## Body Text Specifications

### Optimal Settings by Genre

**Memoir/Biography (Eleanor Life Story Books)**
```
Font: Garamond Premier Pro or EB Garamond
Size: 11.5-12pt
Leading: 15pt (130% of font size)
Line length: 27-32 picas (4.5-5.3 inches)
Alignment: Justified with careful hyphenation
First-line indent: 1em (0.375")
```

**General Non-Fiction**
```
Font: Minion Pro, Sabon, or Bembo
Size: 10.5-11pt
Leading: 13-14pt
Line length: 26-30 picas
Alignment: Justified
First-line indent: 1em
```

**Older Reader Optimization**
```
Font: High x-height (Georgia, Charter, Bookman)
Size: 12-13pt minimum
Leading: 16-18pt (140-150%)
Line length: 24-28 picas
Contrast: Dark black on cream paper
```

### Line Length Guidelines

Optimal reading: 45-75 characters per line (66 ideal)

```
6" × 9" book with 0.875" margins:
Text width = 6 - 0.625 - 0.875 = 4.5"
At 11pt Garamond: ~60-65 characters ✓
```

Too short (<45 chars): Eye fatigues from constant line jumps
Too long (>75 chars): Reader loses place returning to left margin

## Hierarchy System

### Standard Book Hierarchy

```
LEVEL 1: Book Title
  Font: Display or Heavy weight
  Size: 24-36pt
  Spacing: 48pt above, 24pt below

LEVEL 2: Part Title
  Font: Small caps or Bold
  Size: 18-24pt
  Spacing: Start new recto page, 2" from top

LEVEL 3: Chapter Title
  Font: Bold or Medium weight
  Size: 16-20pt
  Spacing: Start new page, 2-3" from top

LEVEL 4: Section Heading (A-head)
  Font: Bold, same family
  Size: 12-14pt
  Spacing: 18pt above, 9pt below

LEVEL 5: Subsection (B-head)
  Font: Italic or Semibold
  Size: 11-12pt (same as body)
  Spacing: 12pt above, 6pt below

LEVEL 6: Run-in heading
  Font: Bold inline with text
  Size: Same as body
  Example: **The Early Years.** She was born...
```

### Chapter Opener Design

**Traditional**
```
[Blank space: 2-2.5" from top]

CHAPTER ONE

The Beginning

[1-2 line breaks]

First paragraph (no indent, or drop cap)
```

**Contemporary**
```
[Small chapter number or ornament]

1

MEMORY AND LIGHT

[Epigraph in italics, if any]

First paragraph with small caps lead-in
```

**Drop Cap Specifications**
- Size: 3-5 lines tall
- Font: Same family or decorative
- Alignment: Baseline aligns with line 3/4/5
- Following text: Small caps for 3-5 words
- Spacing: Small negative space after cap

## Special Typography

### Block Quotes

```
Indent: 0.5" left and right
Font: Same family, same or 1pt smaller
Leading: Same as body
Space: 6-12pt above and below
Style: No quotation marks (indent signals quote)
Attribution: Right-aligned, em dash before name
```

Example styling:
```latex
\begin{quote}
Memory is the diary that we all carry about with us.
\hfill---Oscar Wilde
\end{quote}
```

### Dialogue Formatting

**American Style**
- Double quotation marks for speech
- Single quotes for quotes within quotes
- Punctuation inside closing quotes
- New paragraph for each speaker

**British Style**
- Single quotation marks for speech
- Double quotes for quotes within quotes
- Punctuation outside unless part of quote

### Poetry and Verse

```
Alignment: Centered on longest line, or left-aligned
Indentation: Preserve poet's original indentation
Font: May be italic or smaller
Line breaks: Preserve exactly
Runover lines: Indent 1em, or use special mark

For long lines that wrap:
    And this line continues
        with a hanging indent
```

### Letters and Documents

```
Date: Right-aligned
Salutation: Left-aligned, followed by comma
Body: Slight indent or different font
Closing: Right-aligned
Signature: Right-aligned, italic or script

Consider:
- Typewriter font (Courier, American Typewriter)
- Subtle box or border
- Aged paper background (if printing color)
```

### Footnotes vs. Endnotes

**Footnotes** (same page)
- Size: 8-9pt
- Leading: 10-11pt
- Separator: Short rule or blank space
- Best for: Academic, reference-heavy texts

**Endnotes** (end of chapter or book)
- Size: 9-10pt
- Best for: Memoirs, general non-fiction
- Less disruptive to reading flow

**Sidenotes/Marginalia**
- Size: 8-9pt
- Placement: In outer margin
- Best for: Premium formats, art books

## Running Headers and Folios

### Header Styles

**Traditional**
```
Left (verso): BOOK TITLE          Right (recto): CHAPTER TITLE
              centered or outside                centered or outside
```

**Contemporary**
```
Left: Chapter Title               Right: Book Title
      (outside margin)                   (outside margin)
```

**Minimal**
```
No running headers, only folios
Page numbers bottom center or outside corners
```

### Folio Placement

```
Bottom center:    Classic, unobtrusive
Bottom outside:   Easy thumb navigation
Top outside:      Modern, often with headers

Drop folios: Appear lower on chapter openers
Blind folios: Pages counted but not numbered (title page, etc.)
```

### What Not to Header

- Half-title page
- Title page
- Copyright page
- Dedication
- Blank pages
- Chapter opener pages (folio only, bottom)
- Full-page images

## Spacing and Rhythm

### Vertical Rhythm (Baseline Grid)

All text should align to a baseline grid:
```
Body leading: 14pt
Grid: 14pt intervals

Headings, quotes, and spaces should be
multiples of 14pt to maintain alignment.

Space above A-head: 28pt (2 × 14)
Space below A-head: 14pt (1 × 14)
```

### Paragraph Spacing

**Indented (traditional)**
- First-line indent: 1-1.5em
- No space between paragraphs
- No indent after headings, breaks, or quotes

**Block (modern)**
- No indent
- One line space between paragraphs
- Suitable for business books, modern design

### Section Breaks

**Scene breaks within chapters:**
```
Options:
- Three asterisks: * * *
- Ornament: ❧ or ◆ or ✦
- Extra line space (1-2 lines)
- Small illustration

Centered on the line
18-24pt space above and below
```

## Hyphenation and Justification

### Hyphenation Rules

```
Minimum characters before hyphen: 3
Minimum characters after hyphen: 3
Maximum consecutive hyphens: 2
Don't hyphenate: Proper names, last word of paragraph,
                 last word of page, capitalized words
```

### Justification Settings

**Optimal word spacing:**
- Minimum: 85%
- Desired: 100%
- Maximum: 120%

**Optimal letter spacing:**
- Minimum: -2%
- Desired: 0%
- Maximum: 2%

**Glyph scaling (if available):**
- Minimum: 98%
- Maximum: 102%

### Rivers and Spacing

Watch for "rivers" (vertical white spaces through justified text):
- Fix by adjusting hyphenation
- Light editing of text
- Manual line breaks

## Special Characters

### Dashes

```
Hyphen (-): Compound words, word breaks
En dash (–): Ranges (1990–1995), scores
Em dash (—): Interruption, attribution
             No spaces in American style
             Thin spaces in British style
```

### Quotation Marks

```
Opening double: " (Unicode 201C)
Closing double: " (Unicode 201D)
Opening single: ' (Unicode 2018)
Closing single: ' (Unicode 2019)
Apostrophe: ' (same as closing single)

NEVER use straight quotes: " '
```

### Ellipsis

```
Proper ellipsis: … (Unicode 2026)
Or: three periods with thin spaces: . . .

With sentence end: four dots (period + ellipsis)
```

### Other Characters

```
Multiplication: × not x
Minus: − not hyphen
Prime (feet, minutes): ′ not apostrophe
Double prime (inches): ″ not quotes
Copyright: ©
Registered: ®
Trademark: ™
```

## Font Pairing

### Classic Combinations

```
Garamond + Gill Sans
  Body: Garamond (warm, readable)
  Heads: Gill Sans (clean, humanist)

Minion + Myriad
  Adobe's designed-to-pair families
  Consistent x-heights and weights

Palatino + Optima
  Both humanist, work beautifully together

Caslon + Franklin Gothic
  Traditional serif with American sans
```

### Rules for Pairing

1. **Contrast, not conflict** - Different enough to distinguish
2. **Match x-heights** - Similar proportions feel harmonious
3. **Limit families** - Maximum 2-3 fonts per book
4. **Consistent weights** - If bold in one, bold in both
5. **Consider era** - Fonts from similar periods work well

## Accessibility Considerations

### For Older Readers (Eleanor audience)

```
Minimum type size: 12pt
Maximum line length: 60 characters
High contrast: Black on cream/ivory
Avoid: Light gray text, thin fonts
Leading: 140-150% of font size
Font choice: High x-height, open counters
```

### For Dyslexic Readers

```
Recommended fonts: OpenDyslexic, Lexie Readable
Or: Sans-serif with distinct letterforms
Avoid: Italic for long passages
Line spacing: 1.5-2× font size
Paragraph spacing: Clear visual breaks
```

## Quality Checklist

- [ ] Consistent baseline grid
- [ ] No widows or orphans
- [ ] Maximum 2 consecutive hyphenated lines
- [ ] No rivers in justified text
- [ ] Proper quotation marks throughout
- [ ] Em dashes, en dashes used correctly
- [ ] Hierarchy clearly distinguishable
- [ ] Running headers/folios consistent
- [ ] First paragraphs handle correctly
- [ ] Chapter openers start recto
- [ ] Front matter uses roman numerals
