---
name: developing-elearning-curriculum
description: Designs and develops e-learning curricula using ADDIE methodology, Bloom's Taxonomy, and modern instructional design principles. Use when creating online courses, training programs, learning modules, curriculum outlines, learning objectives, assessments, or when user mentions "curriculum," "e-learning," "instructional design," "course development," "learning objectives," or "training design."
---

# E-Learning Curriculum Development

Guide for creating effective, standards-compliant e-learning experiences using modern instructional design best practices.

## Quick Start: The ADDIE Framework

All curriculum development follows the **ADDIE** lifecycle:

1. **Analyze** → Learner needs, context, constraints
2. **Design** → Objectives, structure, assessments
3. **Develop** → Content, media, interactions
4. **Implement** → Delivery, facilitation, support
5. **Evaluate** → Formative and summative assessment

For rapid, iterative projects, use **SAM** (Successive Approximation Model) instead. See [./instructional-design-models.md](./instructional-design-models.md).

## Phase 1: Analysis

### Conduct Needs Assessment

Ask these questions:
- **Who** are the learners? (demographics, prior knowledge, learning preferences)
- **What** performance gap exists? (current vs. desired state)
- **Why** is training the solution? (vs. job aids, process changes)
- **Where** will learning occur? (devices, connectivity, environment)
- **When** must competency be achieved? (timeline, urgency)

### Define Target Audience Profile

```markdown
## Learner Profile: [Name]

**Demographics**: [Age range, education level, job roles]
**Prior Knowledge**: [What they already know]
**Technical Proficiency**: [Device access, digital literacy]
**Learning Context**: [When/where they'll learn]
**Motivations**: [Why they need this, what drives them]
**Barriers**: [Time constraints, accessibility needs, language]
```

### Identify Constraints

- Budget and resources
- Timeline and deadlines
- Technology limitations (LMS, bandwidth, devices)
- Regulatory or compliance requirements
- Organizational culture and preferences

## Phase 2: Design

### Write Learning Objectives

Use Bloom's Taxonomy action verbs. See [./learning-objectives-guide.md](./learning-objectives-guide.md) for comprehensive verb lists.

**Format**: By the end of this [module/course], learners will be able to **[action verb]** + **[specific content]** + **[condition/context]**.

**Examples by cognitive level**:
- **Remember**: List the five stages of grief
- **Understand**: Explain the relationship between supply and demand
- **Apply**: Calculate compound interest using the formula
- **Analyze**: Compare traditional and agile project management approaches
- **Evaluate**: Critique a business proposal using the provided rubric
- **Create**: Design a marketing campaign for a new product launch

### Map Curriculum Structure

```markdown
## Course: [Title]

### Module 1: [Topic]
Duration: [X minutes/hours]
Objectives:
- Objective 1
- Objective 2

Topics:
1. [Subtopic A]
2. [Subtopic B]

Assessments:
- [Quiz/Activity/Project]

### Module 2: [Topic]
...
```

### Choose Delivery Format

| Format | Best For | Duration | Engagement |
|--------|----------|----------|------------|
| **Self-paced** | Flexible schedules, global audiences | 15-45 min/module | High interactivity |
| **Microlearning** | Just-in-time, reinforcement | 5-15 min | Single concept focus |
| **Blended** | Complex skills, hands-on practice | Variable | Mixed methods |
| **VILT** | Discussion, collaboration | 60-90 min sessions | Live interaction |

See [./delivery-formats.md](./delivery-formats.md) for detailed guidance.

### Design Assessments

Align assessments directly to learning objectives:

| Objective Level | Assessment Types |
|-----------------|------------------|
| Remember/Understand | Multiple choice, matching, true/false |
| Apply | Simulations, scenarios, calculations |
| Analyze | Case studies, compare/contrast essays |
| Evaluate | Critiques, peer review, rubric-based |
| Create | Projects, portfolios, presentations |

## Phase 3: Development

### Content Structure Best Practices

- **Chunk content**: 5-15 minute segments maximum
- **Use the 7±2 rule**: 5-9 items per concept group
- **Follow the 60/40 rule**: 60% practice, 40% instruction
- **Apply progressive disclosure**: Simple → Complex

### Multimedia Principles (Mayer)

1. **Coherence**: Remove extraneous content
2. **Signaling**: Highlight essential material
3. **Redundancy**: Don't duplicate narration with on-screen text
4. **Spatial Contiguity**: Place related elements near each other
5. **Temporal Contiguity**: Present related elements simultaneously
6. **Segmenting**: Break complex lessons into parts
7. **Pre-training**: Teach key terms before the main lesson
8. **Modality**: Use narration with graphics, not text with graphics
9. **Personalization**: Use conversational tone, second person

### Accessibility Standards

Follow WCAG 2.1 AA guidelines:
- Provide captions for all video content
- Include transcripts for audio
- Ensure keyboard navigation
- Maintain 4.5:1 color contrast ratio
- Provide alt text for images
- Design for screen readers

See [./accessibility-checklist.md](./accessibility-checklist.md).

## Phase 4: Implementation

### Technical Standards

For LMS compatibility, choose appropriate standard:

| Standard | Use Case | Key Features |
|----------|----------|--------------|
| **SCORM 1.2** | Legacy LMS, simple tracking | Completion, score, time |
| **SCORM 2004** | Sequencing rules, detailed tracking | Objectives, interactions |
| **xAPI** | Multi-platform, offline, detailed analytics | Any experience tracking |
| **cmi5** | Modern LMS, best of both worlds | xAPI + launch management |

See [./technical-standards.md](./technical-standards.md) for detailed specifications.

### Pilot Testing

Before full rollout:
1. Test with 5-10 representative learners
2. Observe navigation and comprehension issues
3. Collect qualitative feedback
4. Check all technical functionality
5. Measure completion rates and scores

## Phase 5: Evaluation

### Kirkpatrick's Four Levels

1. **Reaction**: Did learners enjoy it? (surveys, feedback)
2. **Learning**: Did they learn? (pre/post tests, skill demos)
3. **Behavior**: Are they applying it? (observation, 360 feedback)
4. **Results**: Business impact? (KPIs, ROI analysis)

### Continuous Improvement

After each cohort:
- Review completion and assessment data
- Analyze learner feedback
- Identify drop-off points
- Update content for accuracy
- Refine based on behavior/results data

## Templates and Tools

### Course Design Document Template

```markdown
# Course Design Document

## Overview
- **Course Title**:
- **Target Audience**:
- **Duration**:
- **Delivery Method**:
- **Prerequisites**:

## Business Case
- **Performance Gap**:
- **Success Metrics**:
- **Stakeholders**:

## Learning Objectives
1.
2.
3.

## Module Outline
| Module | Topics | Duration | Objectives | Assessments |
|--------|--------|----------|------------|-------------|
| 1 | | | | |
| 2 | | | | |

## Assessment Strategy
- **Formative**:
- **Summative**:
- **Passing Criteria**:

## Technical Requirements
- **LMS**:
- **Standard**:
- **Devices**:
- **Accessibility**:

## Timeline
| Phase | Activities | Duration |
|-------|------------|----------|
| Analysis | | |
| Design | | |
| Development | | |
| Pilot | | |
| Launch | | |
```

## Reference Files

- **[Instructional Design Models](./instructional-design-models.md)**: ADDIE, SAM, Merrill, Gagné details
- **[Learning Objectives Guide](./learning-objectives-guide.md)**: Bloom's Taxonomy verbs by level
- **[Delivery Formats](./delivery-formats.md)**: Self-paced, blended, microlearning guidance
- **[Technical Standards](./technical-standards.md)**: SCORM, xAPI, cmi5 specifications
- **[Accessibility Checklist](./accessibility-checklist.md)**: WCAG 2.1 AA compliance
- **[Assessment Design](./assessment-design.md)**: Question types and rubric templates
