# Accessibility Checklist

WCAG 2.1 AA compliance reference for e-learning content.

## Contents
- Quick Reference Checklist
- Perceivable Guidelines
- Operable Guidelines
- Understandable Guidelines
- Robust Guidelines
- Media Accessibility
- Testing Tools

---

## Quick Reference Checklist

### Essential Accessibility Requirements

- [ ] All images have descriptive alt text
- [ ] Videos have synchronized captions
- [ ] Audio content has transcripts
- [ ] Color is not the only means of conveying information
- [ ] Color contrast ratio is at least 4.5:1 (text) / 3:1 (large text)
- [ ] All functionality is keyboard accessible
- [ ] Focus order is logical and visible
- [ ] Content is readable at 200% zoom
- [ ] Page titles are descriptive and unique
- [ ] Form fields have visible labels
- [ ] Error messages are clear and helpful
- [ ] Content works with screen readers
- [ ] Flashing content is avoided or limited
- [ ] Audio can be paused/stopped

---

## Perceivable Guidelines

Content must be presentable in ways users can perceive.

### 1.1 Text Alternatives

| Element | Requirement | Example |
|---------|-------------|---------|
| Informative images | Alt text describes content/purpose | `alt="Bar chart showing Q3 sales increased 15%"` |
| Decorative images | Empty alt or CSS background | `alt=""` or `role="presentation"` |
| Complex images | Alt + long description | Alt text + link to detailed description |
| Icons with text | Empty alt (text provides meaning) | Button with icon + "Submit" label |
| Icons alone | Alt describes function | `alt="Search"` for magnifying glass |
| Image maps | Alt for image + each hotspot | Descriptive alt for clickable regions |

**Complex image example**:
```html
<figure>
  <img src="process-flowchart.png"
       alt="Customer service escalation process (described below)">
  <figcaption>
    <details>
      <summary>Flowchart description</summary>
      <p>The escalation process has three levels:
         Level 1 support handles initial contact...
      </p>
    </details>
  </figcaption>
</figure>
```

### 1.2 Time-Based Media

| Media Type | Requirement |
|------------|-------------|
| Pre-recorded video | Captions + audio description (if needed) |
| Pre-recorded audio | Transcript |
| Live video | Live captions |
| Video-only | Text alternative or audio track |
| Audio-only | Transcript |

### 1.3 Adaptable

| Requirement | Implementation |
|-------------|----------------|
| Semantic structure | Use proper headings (H1→H2→H3) |
| Reading order | DOM order matches visual order |
| Lists | Use `<ul>`, `<ol>`, `<dl>` appropriately |
| Tables | Use `<th>` headers, `scope`, `caption` |
| Forms | Associate labels with inputs |
| Landmarks | Use `<nav>`, `<main>`, `<aside>`, etc. |

**Heading structure example**:
```
H1: Module Title
  H2: Section 1
    H3: Subsection 1.1
    H3: Subsection 1.2
  H2: Section 2
    H3: Subsection 2.1
```

### 1.4 Distinguishable

**Color contrast requirements**:

| Text Size | Minimum Ratio |
|-----------|---------------|
| Normal text (<18pt or <14pt bold) | 4.5:1 |
| Large text (≥18pt or ≥14pt bold) | 3:1 |
| UI components/graphics | 3:1 |

**Color-only indicators** - Always provide secondary cue:
```
❌ "Click the green button to continue"
✓  "Click the green 'Continue' button"

❌ Red text = error (color only)
✓  Red text + error icon + "Error:" prefix
```

**Text spacing** (must work with user overrides):
- Line height: 1.5× font size
- Paragraph spacing: 2× font size
- Letter spacing: 0.12× font size
- Word spacing: 0.16× font size

---

## Operable Guidelines

Users must be able to operate the interface.

### 2.1 Keyboard Accessible

**All functionality via keyboard**:

| Action | Keyboard Equivalent |
|--------|-------------------|
| Click/select | Enter or Space |
| Navigate | Tab / Shift+Tab |
| Menus | Arrow keys |
| Close modal | Escape |
| Custom controls | Documented keys |

**Focus management**:
- Visible focus indicator (2px+ outline)
- Logical tab order (matches visual order)
- No keyboard traps
- Skip links for navigation

**Focus indicator example**:
```css
:focus {
  outline: 3px solid #005fcc;
  outline-offset: 2px;
}

/* Don't remove outline */
:focus { outline: none; } /* ❌ Avoid */
```

### 2.2 Enough Time

**Timing requirements**:

| Situation | Requirement |
|-----------|-------------|
| Timed activities | Warn before time expires |
| Auto-advancing | Allow pause, stop, or extend |
| Session timeout | 20+ seconds warning + extend option |
| Reading time | No arbitrary limits |

**Assessment timing**:
- Provide time extensions as accommodation
- Show time remaining prominently
- Warn at 5 minutes, 1 minute remaining
- Allow save/resume if possible

### 2.3 Seizures and Physical Reactions

**Flashing content**:
- No more than 3 flashes per second
- Flash area < 25% of viewport
- Provide warnings for photosensitive content
- Allow users to disable animations

**Motion considerations**:
- Provide `prefers-reduced-motion` alternatives
- Avoid parallax effects or auto-playing animation
- Include pause controls for animated content

### 2.4 Navigable

**Navigation requirements**:

| Feature | Purpose |
|---------|---------|
| Skip to content link | Bypass repetitive navigation |
| Page titles | Describe page purpose |
| Focus order | Logical, predictable sequence |
| Link purpose | Clear from link text (or context) |
| Multiple ways | Search, sitemap, or nav menu |
| Headings | Describe topic or purpose |
| Visible focus | Clear focus indicator |

**Link text examples**:
```
❌ "Click here"
❌ "Learn more"
✓  "Read the accessibility guidelines"
✓  "Download course syllabus (PDF, 2MB)"
```

---

## Understandable Guidelines

Content and operation must be understandable.

### 3.1 Readable

**Language requirements**:
- Set page language: `<html lang="en">`
- Mark language changes: `<span lang="fr">Bonjour</span>`
- Define unusual words or jargon
- Expand abbreviations on first use

**Reading level guidelines**:
- Target 8th grade reading level when possible
- Provide summaries for complex content
- Use clear, simple language
- Define technical terms

### 3.2 Predictable

**Consistent behavior**:

| Principle | Implementation |
|-----------|----------------|
| Consistent navigation | Same location across pages |
| Consistent identification | Same icons/labels for same functions |
| No unexpected changes | User-initiated actions only |
| On focus | Don't change context on focus |
| On input | Warn before auto-submit |

### 3.3 Input Assistance

**Error handling requirements**:

| Requirement | Implementation |
|-------------|----------------|
| Error identification | Clearly identify which field has error |
| Labels/instructions | Provide before input |
| Error suggestion | Suggest how to fix |
| Error prevention | Confirm, review, or reverse important actions |

**Error message example**:
```html
<label for="email">Email address (required)</label>
<input type="email" id="email" aria-describedby="email-error"
       aria-invalid="true">
<span id="email-error" role="alert">
  Please enter a valid email address (example: name@domain.com)
</span>
```

---

## Robust Guidelines

Content must work with current and future technologies.

### 4.1 Compatible

**Technical requirements**:

| Requirement | Implementation |
|-------------|----------------|
| Valid HTML | Proper nesting, unique IDs, complete tags |
| Name, Role, Value | ARIA labels for custom controls |
| Status messages | Use ARIA live regions |

**ARIA for custom controls**:
```html
<!-- Custom checkbox -->
<div role="checkbox"
     aria-checked="false"
     aria-label="Accept terms"
     tabindex="0">
</div>

<!-- Progress indicator -->
<div role="progressbar"
     aria-valuenow="45"
     aria-valuemin="0"
     aria-valuemax="100"
     aria-label="Course progress: 45%">
</div>

<!-- Live region for updates -->
<div aria-live="polite" aria-atomic="true">
  Quiz submitted successfully
</div>
```

---

## Media Accessibility

### Video Captions

**Caption quality standards**:
- 99%+ accuracy
- Proper punctuation and grammar
- Speaker identification when needed
- Sound descriptions [applause], [phone rings]
- Synchronized within 1 frame of audio
- Readable duration (minimum 1 second)
- Maximum 2 lines, 32 characters per line

**Caption example**:
```
[00:15] INSTRUCTOR: Welcome to the safety training module.

[00:19] Today we'll cover three key topics.
[music plays]

[00:23] First, let's discuss fire evacuation procedures.
```

### Audio Description

**When needed**: Video content has visual information not described in dialogue.

**Description types**:
- Standard: Fits in natural pauses
- Extended: Video pauses for description
- Alternative: Separate described version

**What to describe**:
- Actions and movements
- Scene changes and settings
- On-screen text and graphics
- Facial expressions (when relevant)
- Attire and appearance (when relevant)

### Transcripts

**Transcript components**:
- All spoken content
- Speaker identification
- Sound effects and music cues
- Visual descriptions (for video transcripts)

---

## Testing Tools

### Automated Testing

| Tool | Purpose | URL |
|------|---------|-----|
| WAVE | Web accessibility evaluation | wave.webaim.org |
| axe | Browser extension | deque.com/axe |
| Lighthouse | Chrome DevTools audit | Built into Chrome |
| Color Contrast Analyzer | Color testing | paciellogroup.com |
| ANDI | Section 508 testing | ssa.gov/accessibility/andi |

### Manual Testing Checklist

- [ ] Navigate entire course using keyboard only
- [ ] Test with screen reader (NVDA, VoiceOver, JAWS)
- [ ] Verify at 200% zoom
- [ ] Check with color blindness simulator
- [ ] Test with reduced motion preference
- [ ] Verify all videos have accurate captions
- [ ] Confirm transcripts match audio content
- [ ] Check form error handling
- [ ] Validate custom interactive elements

### Screen Reader Testing

**Common screen readers**:
- NVDA (Windows, free)
- JAWS (Windows, paid)
- VoiceOver (macOS/iOS, built-in)
- TalkBack (Android, built-in)

**Basic testing commands (NVDA)**:
- `Insert + Down Arrow`: Read all
- `Tab`: Next focusable element
- `H`: Next heading
- `D`: Next landmark
- `Insert + F7`: Elements list

---

## Resources

- [WCAG 2.1 Guidelines](https://www.w3.org/WAI/WCAG21/quickref/)
- [Section 508 Standards](https://www.section508.gov/)
- [WebAIM Resources](https://webaim.org/resources/)
- [Deque University](https://dequeuniversity.com/)
- [A11Y Project Checklist](https://www.a11yproject.com/checklist/)
