# Assessment Design Guide

Reference for creating effective assessments aligned to learning objectives.

## Contents
- Assessment Types Overview
- Question Types by Cognitive Level
- Writing Effective Questions
- Rubric Design
- Assessment Strategy Templates

---

## Assessment Types Overview

### Formative vs Summative

| Type | Purpose | When | Examples |
|------|---------|------|----------|
| **Formative** | Check understanding, guide learning | During instruction | Knowledge checks, practice activities, polls |
| **Summative** | Evaluate mastery, certify competency | End of instruction | Final exams, capstone projects, skill demos |

### Assessment Methods

| Method | Best For | Effort Level |
|--------|----------|--------------|
| Multiple choice | Knowledge, comprehension | Low to create, auto-grade |
| True/false | Simple facts | Low to create, auto-grade |
| Matching | Terminology, relationships | Low to create, auto-grade |
| Fill-in-blank | Recall, terminology | Medium to create, may need review |
| Short answer | Explanation, application | Medium to create, manual grade |
| Essay | Analysis, synthesis, evaluation | High to create, manual grade |
| Scenario/case study | Application, analysis, judgment | High to create, may need rubric |
| Simulation | Procedural skills, decision-making | High to create, can auto-grade |
| Portfolio | Comprehensive competency | High to create, rubric-based |
| Performance observation | Hands-on skills | Live evaluation, checklist-based |

---

## Question Types by Cognitive Level

### Remember Level

**Objective**: Recall facts, terms, basic concepts.

**Best question types**: Multiple choice, true/false, matching, fill-in-blank

**Example - Multiple Choice**:
```
Which of the following is the first step in the ADDIE model?
a) Design
b) Develop
c) Analyze ✓
d) Implement
```

**Example - Matching**:
```
Match each Bloom's level to its description:
1. Remember       a. Make judgments based on criteria
2. Understand     b. Use a procedure in a situation
3. Apply          c. Retrieve knowledge from memory
4. Evaluate       d. Construct meaning from information

Answers: 1-c, 2-d, 3-b, 4-a
```

### Understand Level

**Objective**: Explain ideas, interpret meaning.

**Best question types**: Multiple choice (interpretation), short answer, ordering

**Example - Interpretation**:
```
Read the following learning objective:
"Learners will understand workplace safety procedures."

What is the primary problem with this objective?
a) It's too specific
b) It uses a non-measurable verb ✓
c) It doesn't mention the audience
d) It's too long
```

**Example - Short Answer**:
```
In your own words, explain why learning objectives should use
action verbs from Bloom's Taxonomy. (2-3 sentences)

Sample answer: Action verbs ensure objectives are measurable
and observable. They help designers create aligned assessments
and help learners understand exactly what they'll be able to do.
```

### Apply Level

**Objective**: Use procedures, solve problems.

**Best question types**: Scenarios, simulations, calculations, demonstrations

**Example - Scenario**:
```
Scenario: You're designing a 30-minute e-learning module on
data privacy for customer service representatives. They need
to handle customer requests for data deletion.

Which learning objective is most appropriate?
a) Understand data privacy regulations
b) Process a data deletion request using the CRM system ✓
c) Appreciate the importance of customer privacy
d) Know the company's data policy
```

**Example - Calculation**:
```
A training program costs $50,000 to develop and delivers $20,000
in productivity savings per year. Calculate the ROI after 3 years.

Show your work:
Total savings: $20,000 × 3 = $60,000
Net benefit: $60,000 - $50,000 = $10,000
ROI: ($10,000 ÷ $50,000) × 100 = 20%
```

### Analyze Level

**Objective**: Compare, differentiate, examine relationships.

**Best question types**: Case studies, compare/contrast, root cause analysis

**Example - Case Study Analysis**:
```
Case: A company launched a new compliance training module.
Completion rate is 95%, but audit violations increased by 12%
in the following quarter.

Analyze this situation. What are three possible explanations
for the discrepancy between completion and behavior?

Sample responses:
1. Training may test recall but not application
2. Knowledge isn't transferring to job context
3. Environmental factors (time pressure, conflicting priorities)
4. Training content may not address actual compliance gaps
```

**Example - Compare/Contrast**:
```
Compare the ADDIE and SAM instructional design models.
Identify two advantages of each approach.

ADDIE advantages:
- Thorough front-end analysis reduces rework
- Clear documentation supports stakeholder alignment

SAM advantages:
- Faster time to first prototype
- Continuous stakeholder feedback catches issues early
```

### Evaluate Level

**Objective**: Make judgments, justify decisions.

**Best question types**: Critique, recommendation, peer review

**Example - Critique**:
```
Review the following learning objective and rate it on the
criteria below (1=Poor, 5=Excellent). Justify each rating.

Objective: "After completing this module, participants will
be familiar with the new expense reporting system."

Criteria:
- Measurable verb: [Rating] [Justification]
- Specific outcome: [Rating] [Justification]
- Achievable scope: [Rating] [Justification]
- Clear audience: [Rating] [Justification]
```

**Example - Recommendation**:
```
Your organization needs training for a new product launch in
6 weeks. You have limited budget and a global audience of 500
sales representatives in 12 time zones.

Which delivery format do you recommend? Justify your choice
by addressing: timeline, budget, reach, and effectiveness.
```

### Create Level

**Objective**: Generate new products, designs, plans.

**Best question types**: Projects, portfolios, design challenges

**Example - Design Project**:
```
Design a 5-module microlearning curriculum for new manager
onboarding. For each module, provide:

1. Module title
2. One measurable learning objective (using Bloom's verbs)
3. Duration (must be 5-10 minutes each)
4. Primary content format (video, scenario, etc.)
5. Assessment type

Your design must address: setting expectations, giving feedback,
delegating tasks, conducting 1:1 meetings, and managing conflict.
```

---

## Writing Effective Questions

### Multiple Choice Best Practices

**Stem (question)**:
- Write as a complete question or statement
- Put most content in the stem, not options
- Avoid negatives (or bold if necessary: NOT)
- One clear correct answer

**Options (answers)**:
- 3-5 options (4 is standard)
- All options similar length
- Options grammatically consistent with stem
- Arrange logically (alphabetical, numerical, chronological)

**Distractors (wrong answers)**:
- Plausible to someone who doesn't know
- Based on common misconceptions
- Don't use "all of the above" or "none of the above"
- Avoid "always" and "never"

**Example - Before and After**:
```
❌ Poor:
Which is not true about ADDIE?
a) It was developed in the 1970s
b) It is always used in a linear fashion
c) ADDIE stands for Analyze, Design, Develop, Implement, Evaluate
d) It is used in corporate training

❓ Issues: Negative stem, "always" in option, options vary in length

✓ Better:
How is the ADDIE model typically applied in modern practice?
a) Strictly linear, completing each phase before starting the next
b) Iteratively, with overlap between phases ✓
c) Only for compliance training projects
d) Exclusively in academic settings
```

### Scenario-Based Question Structure

```
CONTEXT: [Brief background - who, what, where]
SITUATION: [Specific challenge or problem]
DATA: [Relevant information for decision-making]
QUESTION: [What learner must do/decide]
OPTIONS or OPEN RESPONSE: [Choices or response format]
```

**Example**:
```
Context: You're a customer service supervisor at TechCo.

Situation: A team member, Jamie, has been making errors in
data entry. This is the third occurrence this month.

Data:
- Jamie has been employed for 8 months
- Errors are costing an average of 2 hours to fix each time
- Jamie completed data entry training 6 months ago

Question: Which is the most appropriate first step?

a) Issue a written warning
b) Retrain Jamie on data entry procedures
c) Have a one-on-one conversation to understand the cause ✓
d) Reassign Jamie to a different role
```

### Avoiding Common Pitfalls

| Pitfall | Example | Fix |
|---------|---------|-----|
| Double-barreled | "What is X and why?" | Split into two questions |
| Leading | "Don't you agree that..." | Remove opinion |
| Ambiguous | "List the important factors" | Define "important" |
| Trick questions | Tricky wording to confuse | Be straightforward |
| Cultural bias | US-centric examples | Use universal examples |
| Jargon | Industry terms undefined | Define or simplify |

---

## Rubric Design

### Analytic Rubric Template

Scores each criterion separately.

```
| Criterion | 4 - Exemplary | 3 - Proficient | 2 - Developing | 1 - Beginning |
|-----------|---------------|----------------|----------------|---------------|
| [Criterion 1] | [Description of 4] | [Description of 3] | [Description of 2] | [Description of 1] |
| [Criterion 2] | [Description of 4] | [Description of 3] | [Description of 2] | [Description of 1] |
| [Criterion 3] | [Description of 4] | [Description of 3] | [Description of 2] | [Description of 1] |
```

**Example - Learning Objective Rubric**:

| Criterion | 4 - Exemplary | 3 - Proficient | 2 - Developing | 1 - Beginning |
|-----------|---------------|----------------|----------------|---------------|
| **Action Verb** | Uses specific, measurable Bloom's verb at appropriate level | Uses measurable verb, may be slightly off level | Uses general verb (explain, demonstrate) | Uses unmeasurable verb (understand, know) |
| **Specificity** | Clearly states observable outcome with context | States outcome, some context missing | Vague outcome statement | Missing or unclear outcome |
| **Conditions** | Appropriate conditions included (tools, resources) | Some conditions stated | Conditions implied but not stated | No conditions |
| **Criteria** | Success criteria clearly defined | Criteria implied | Criteria vague | No criteria |

### Holistic Rubric Template

Single overall score based on general performance levels.

```
4 - Exemplary
[Description of comprehensive mastery]

3 - Proficient
[Description of meeting expectations]

2 - Developing
[Description of partial achievement]

1 - Beginning
[Description of minimal achievement]
```

**Example - Presentation Holistic Rubric**:

```
4 - Exemplary
Presentation demonstrates comprehensive understanding of the
topic. Content is well-organized, accurate, and insightful.
Visual aids enhance understanding. Speaker is confident,
engages audience, and handles questions effectively.

3 - Proficient
Presentation demonstrates solid understanding of the topic.
Content is organized and accurate. Visual aids support content.
Speaker is prepared and answers most questions adequately.

2 - Developing
Presentation demonstrates partial understanding of the topic.
Organization or accuracy issues are present. Visual aids are
basic or somewhat distracting. Speaker reads from notes and
struggles with some questions.

1 - Beginning
Presentation demonstrates limited understanding. Major
organization or accuracy problems. Visual aids missing or
detract from content. Speaker is unprepared and cannot
answer questions.
```

### Single-Point Rubric

Lists only the proficiency standard; feedback notes above/below.

```
Areas for Improvement | Criteria (Proficient Level) | Evidence of Excellence
---------------------|----------------------------|----------------------
                     | Uses measurable action verb |
                     | Specifies observable outcome |
                     | Includes appropriate conditions |
                     | Defines success criteria |
```

---

## Assessment Strategy Templates

### Module Assessment Plan

```
## Module: [Title]

### Learning Objectives
1. [Objective 1]
2. [Objective 2]
3. [Objective 3]

### Formative Assessments

| Point | Type | Objective Assessed | Purpose |
|-------|------|-------------------|---------|
| After Section 1 | Knowledge check (3 MC) | Obj 1 | Verify recall |
| After Section 2 | Scenario activity | Obj 2 | Practice application |
| Before Summary | Reflection prompt | All | Self-assessment |

### Summative Assessment

| Component | Type | Objectives | Weight |
|-----------|------|------------|--------|
| Quiz | 10 MC + 2 short answer | Obj 1, 2 | 40% |
| Scenario | Case analysis | Obj 2, 3 | 60% |

### Passing Criteria
- Minimum score: 80%
- Must pass scenario component
- Two attempts permitted
```

### Course Assessment Plan

```
## Course: [Title]
## Duration: [X modules/hours]

### Assessment Structure

| Assessment | When | Type | Weight | Objectives Covered |
|------------|------|------|--------|-------------------|
| Module quizzes | End of each module | MC + short answer | 30% | Per module |
| Mid-course project | After Module 4 | Practical application | 25% | 1-4 combined |
| Final exam | End of course | Comprehensive | 25% | All |
| Capstone project | End of course | Create/design | 20% | All, emphasizing create |

### Grading Scale
| Grade | Percentage | Interpretation |
|-------|------------|----------------|
| Pass with Distinction | 90-100% | Exceeds expectations |
| Pass | 70-89% | Meets expectations |
| Incomplete | <70% | Retake required |

### Attempt Policy
- Module quizzes: 2 attempts, highest score
- Mid-course project: Revision allowed after feedback
- Final exam: 2 attempts, waiting period of 48 hours
- Capstone: Revision encouraged, due 1 week after feedback
```
