# Delivery Formats Guide

Comprehensive reference for selecting and designing e-learning delivery methods.

## Contents
- Self-Paced Online Learning
- Microlearning
- Blended Learning
- Virtual Instructor-Led Training (VILT)
- Format Selection Matrix

---

## Self-Paced Online Learning

Asynchronous e-learning where learners progress independently.

### Characteristics

| Aspect | Description |
|--------|-------------|
| Duration | 15-60 minutes per module |
| Interaction | Built-in (quizzes, scenarios, simulations) |
| Pace | Learner-controlled |
| Access | Anytime, anywhere |
| Feedback | Automated |

### Module Structure

```
Module Structure (30-45 minutes typical)

1. Introduction (2-3 min)
   - Hook/attention grabber
   - Objectives statement
   - Overview/agenda

2. Content Sections (15-25 min, 3-5 sections)
   - Each section: 3-5 minutes
   - Teaching + practice
   - Knowledge check after each section

3. Application Activity (5-10 min)
   - Scenario or simulation
   - Apply all learning points

4. Summary & Assessment (5-7 min)
   - Key takeaways
   - Final quiz (5-10 questions)
   - Next steps/resources

5. Closing (1-2 min)
   - Completion confirmation
   - Call to action
```

### Best Practices

**Content design**:
- Use conversational, second-person tone
- Present one concept per screen
- Balance text with visuals (40/60 rule)
- Include progress indicators
- Provide navigation flexibility

**Interactivity requirements**:
- Minimum: 1 interaction per 3-5 minutes
- Types: click-to-reveal, drag-drop, branching scenarios
- Purpose: Check understanding, maintain engagement

**Video guidelines**:
- Keep under 6 minutes per video
- Use talking head + screen capture for software
- Include captions for accessibility
- Optimize for mobile viewing

### When to Use

**Best for**:
- Large, geographically dispersed audiences
- Compliance and policy training
- Consistent message delivery
- Flexible scheduling needs
- Content with long shelf life

**Avoid when**:
- Skills require hands-on practice with feedback
- Content changes frequently (unless easy to update)
- Learners need peer interaction
- Complex skills requiring coaching

---

## Microlearning

Short, focused learning nuggets targeting specific outcomes.

### Characteristics

| Aspect | Description |
|--------|-------------|
| Duration | 3-15 minutes |
| Focus | Single concept/skill |
| Access | Mobile-optimized |
| Design | Standalone or series |
| Reinforcement | Spaced repetition |

### Microlearning Formats

| Format | Duration | Best For |
|--------|----------|----------|
| Video nugget | 2-5 min | Demonstrations, concepts |
| Interactive card | 3-5 min | Facts, processes, decisions |
| Scenario | 5-10 min | Application, judgment |
| Quiz burst | 3-5 min | Reinforcement, assessment |
| Infographic | 2-3 min | Reference, summary |
| Audio clip | 3-5 min | Mobile, commute time |

### Design Principles

**Single learning objective**: One video, one concept, one takeaway.

**Structure for 5-minute module**:
```
0:00-0:30  Hook (problem/question)
0:30-1:00  Setup (context, why it matters)
1:00-3:30  Core teaching (concept + example)
3:30-4:30  Practice (1-2 quick checks)
4:30-5:00  Summary (key point + action)
```

**Engagement techniques**:
- Start with a question or challenge
- Use real-world scenarios
- Include at least one interaction
- End with immediate applicability

### Microlearning Series Design

**Spaced learning campaign** (recommended for retention):
```
Week 1: Module 1 (intro concept)
Week 1+2 days: Quiz reinforcement
Week 2: Module 2 (build on concept)
Week 2+2 days: Scenario practice
Week 3: Module 3 (advanced application)
Week 4: Comprehensive challenge
```

### When to Use

**Best for**:
- Just-in-time performance support
- Reinforcement after formal training
- Mobile-first audiences
- Busy professionals with limited time
- Frequently updated content
- Building habits over time

**Avoid when**:
- Deep understanding required
- Complex skills needing guided practice
- Certification or compliance requiring proof
- Topics requiring context-building

---

## Blended Learning

Combination of online and face-to-face elements.

### Common Models

#### Flipped Classroom
```
Pre-work (Online)     → In-Person Session     → Follow-up (Online)
Self-paced content      Discussion, practice    Reinforcement, support
20-30 min              2-4 hours                Ongoing
```

#### Rotation Model
```
Week 1: Online foundation modules
Week 2: In-person workshop
Week 3: Online practice + peer discussion
Week 4: In-person skills lab
Week 5: Online assessment + project
```

#### Enriched Virtual
```
Primary: Virtual/online learning
Supplemented by: Occasional in-person sessions for:
- Kickoff/cohort building
- Hands-on practice
- Capstone presentations
```

### Blend Design Framework

| Component | Purpose | Delivery |
|-----------|---------|----------|
| Content delivery | Transfer information | Online (self-paced) |
| Discussion | Social learning, perspectives | Live (virtual or in-person) |
| Practice | Skill building | Mix (simulations + live) |
| Coaching | Personalized feedback | Live (1:1 or small group) |
| Assessment | Verify competency | Online or live demonstration |

### Best Practices

**Pre-work success factors**:
- Keep under 30 minutes
- Make it directly relevant to live session
- Include accountability (quiz, discussion post)
- Provide clear instructions and deadlines

**Live session design**:
- Don't repeat pre-work content
- Focus on application, discussion, practice
- Use group activities (case studies, role-play)
- Address questions from pre-work

**Post-session follow-up**:
- Provide resources and job aids
- Schedule practice or coaching
- Create accountability partnerships
- Measure application over time

### When to Use

**Best for**:
- Complex skill development
- Leadership and soft skills training
- Programs requiring behavior change
- Cohort-based learning experiences
- High-value, high-stakes content

**Avoid when**:
- Budget doesn't support live sessions
- Audience can't gather (time zones, schedules)
- Content is purely informational
- Rapid scale-up is needed

---

## Virtual Instructor-Led Training (VILT)

Live, synchronous training delivered via web conferencing.

### Session Design

| Duration | Structure | Best For |
|----------|-----------|----------|
| 60 min | Single topic, heavy interaction | Focused skill building |
| 90 min | Topic + practice + Q&A | Moderate complexity |
| 2-3 hr | Multiple topics with breaks | Comprehensive workshops |
| Half-day | Deep dive with activities | Intensive skill building |

### 60-Minute VILT Template

```
0:00-0:05  Welcome, tech check, icebreaker
0:05-0:10  Objectives and agenda
0:10-0:25  Content segment 1 + discussion
0:25-0:35  Activity 1 (breakout/individual)
0:35-0:45  Content segment 2 + Q&A
0:45-0:55  Activity 2 (application/practice)
0:55-1:00  Summary, action items, close
```

### Engagement Techniques

**Every 3-5 minutes**, include one of:
- Poll question
- Chat prompt
- Annotation activity
- Raised hand/reaction
- Breakout discussion

**Breakout room activities**:
- Keep 5-15 minutes
- Provide clear instructions (in chat + verbal)
- Assign roles (timekeeper, note-taker, presenter)
- Visit rooms briefly

**Producer role responsibilities**:
- Manage chat questions
- Launch polls/breakouts
- Troubleshoot tech issues
- Time management signals
- Record session

### Platform Considerations

| Feature | Use For |
|---------|---------|
| Breakout rooms | Small group discussions |
| Polls | Quick knowledge checks, opinions |
| Chat | Questions, text responses |
| Whiteboard | Brainstorming, visual collaboration |
| Screen share | Demonstrations, presentations |
| Annotations | Mark up shared content |

### When to Use

**Best for**:
- Interactive skill practice
- Q&A and clarification
- Building team/cohort connection
- Content requiring expert facilitation
- Discussion-based learning

**Avoid when**:
- Purely information transfer (use self-paced)
- Large audiences with no interaction plan
- Learners in incompatible time zones
- Technology access is limited

---

## Format Selection Matrix

### By Learning Objective Type

| Objective Type | Primary Format | Secondary |
|---------------|----------------|-----------|
| Knowledge (facts, concepts) | Self-paced | Microlearning |
| Comprehension | Self-paced | VILT |
| Skills (procedures) | Blended | Self-paced + practice |
| Soft skills | Blended | VILT |
| Behavior change | Blended | VILT + coaching |

### By Audience Factors

| Factor | Recommended Format |
|--------|-------------------|
| Global, many time zones | Self-paced, microlearning |
| Small cohort, same location | Blended, VILT |
| Limited time availability | Microlearning |
| High technology access | Any format |
| Low bandwidth/mobile only | Microlearning (optimized) |
| Need social connection | VILT, blended |

### By Content Factors

| Factor | Recommended Format |
|--------|-------------------|
| Rapidly changing content | Microlearning |
| Stable, long-term content | Self-paced |
| Complex, nuanced topics | Blended |
| Compliance/certification | Self-paced + assessment |
| Hands-on skills | Blended |
| Conceptual understanding | Self-paced or VILT |

### By Business Factors

| Factor | Recommended Format |
|--------|-------------------|
| Limited budget | Self-paced, microlearning |
| Fast deployment needed | Microlearning |
| High-stakes outcomes | Blended |
| Need to track completion | Self-paced (LMS) |
| Scale to thousands | Self-paced |
| Build culture/community | Blended, VILT |
