# Instructional Design Models

Comprehensive reference for selecting and applying instructional design frameworks.

## Contents
- ADDIE Model (Standard)
- SAM Model (Agile/Iterative)
- Merrill's Principles of Instruction
- Gagné's Nine Events of Instruction
- Backward Design (Understanding by Design)
- Model Selection Guide

---

## ADDIE Model

The industry-standard systematic approach. 67% of hiring managers expect familiarity with ADDIE.

### Phase Details

#### 1. Analysis (10-15% of project time)
**Purpose**: Identify the problem and define the solution scope.

**Activities**:
- Conduct needs assessment interviews
- Analyze target audience demographics
- Review existing training materials
- Identify technical and resource constraints
- Define success metrics

**Deliverables**:
- Needs assessment report
- Learner personas
- Constraints documentation
- Project scope statement

#### 2. Design (15-20% of project time)
**Purpose**: Blueprint the learning experience.

**Activities**:
- Write measurable learning objectives
- Design curriculum structure and flow
- Select delivery methods and media
- Create assessment strategy
- Develop content outline

**Deliverables**:
- Learning objectives document
- Course outline/storyboard
- Assessment plan
- Design document

#### 3. Development (40-50% of project time)
**Purpose**: Create all course materials.

**Activities**:
- Write scripts and content
- Create or source media assets
- Build interactive elements
- Develop assessments and feedback
- Integrate into authoring tool/LMS

**Deliverables**:
- Complete course content
- Media library
- Assessment items
- Style guide

#### 4. Implementation (5-10% of project time)
**Purpose**: Deploy and facilitate the learning.

**Activities**:
- Pilot test with representative sample
- Train facilitators/administrators
- Launch to full audience
- Provide learner support
- Monitor technical performance

**Deliverables**:
- Pilot feedback report
- Facilitator guide
- Learner communications
- Support documentation

#### 5. Evaluation (Ongoing)
**Purpose**: Measure effectiveness and improve.

**Activities**:
- Collect reaction data (Level 1)
- Measure learning gains (Level 2)
- Assess behavior change (Level 3)
- Calculate business results (Level 4)
- Iterate based on findings

**Deliverables**:
- Evaluation reports
- Improvement recommendations
- Updated course versions

### When to Use ADDIE

**Best for**:
- Large-scale corporate training programs
- Compliance and regulatory training
- Projects requiring extensive stakeholder sign-off
- Content with long shelf life (2+ years)
- High-stakes training (safety, legal)

**Limitations**:
- Can be slow for rapidly changing content
- Front-loaded analysis may delay development
- Less flexible for mid-project changes

---

## SAM Model (Successive Approximation Model)

Agile-inspired approach developed by Michael Allen. Emphasizes rapid prototyping and iteration.

### Three Phases

#### Phase 1: Savvy Start (Preparation)
**Duration**: 1-3 focused sessions

**Activities**:
- Gather key stakeholders together
- Brainstorm learning goals rapidly
- Identify performance outcomes
- Sketch initial concepts
- Agree on constraints and priorities

**Output**: Shared vision document, initial concepts

#### Phase 2: Iterative Design
**Cycles**: 3-5 iterations

Each iteration includes:
1. **Design**: Create/refine prototypes
2. **Prototype**: Build functional mockups
3. **Review**: Gather stakeholder feedback

**Key principle**: "Design a little, build a little, test a little"

#### Phase 3: Iterative Development
**Cycles**: 3-5 iterations

Each iteration includes:
1. **Develop**: Build production content
2. **Implement**: Deploy for testing
3. **Evaluate**: Measure and refine

### SAM1 vs SAM2

**SAM1** (Extended):
- For smaller projects
- Single designer/developer
- 3 iterations typical

**SAM2** (Standard):
- For larger projects
- Cross-functional teams
- More formal documentation
- 5+ iterations typical

### When to Use SAM

**Best for**:
- Fast-paced environments
- Rapidly changing content
- Projects with high stakeholder involvement
- Teams comfortable with ambiguity
- When early feedback is critical

**Limitations**:
- Requires available stakeholders for frequent reviews
- May produce less comprehensive documentation
- Can feel chaotic without strong project management

---

## Merrill's Principles of Instruction

Five research-based principles for effective learning, regardless of delivery method.

### The Five Principles

#### 1. Task-Centered
Learning should focus on real-world tasks or problems.

**Application**:
- Start with a realistic scenario or challenge
- Use authentic work products as learning artifacts
- Progress through increasingly complex tasks
- Connect all content to practical application

#### 2. Activation
Activate relevant prior knowledge before presenting new content.

**Application**:
- Begin with "What do you already know about...?"
- Use advance organizers to connect to existing schemas
- Provide pre-assessments to surface knowledge gaps
- Reference familiar concepts as bridges

#### 3. Demonstration
Show examples, don't just tell information.

**Application**:
- Use worked examples with expert narration
- Provide diverse examples (correct and incorrect)
- Show process, not just final product
- Use multimedia to visualize abstract concepts

#### 4. Application
Let learners practice with feedback.

**Application**:
- Provide immediate, specific feedback
- Scaffold practice from guided to independent
- Use realistic practice environments
- Allow safe failure and retry

#### 5. Integration
Help learners integrate new knowledge into their world.

**Application**:
- Provide reflection prompts
- Encourage learners to teach others
- Create opportunities for personalized application
- Celebrate and recognize new competencies

---

## Gagné's Nine Events of Instruction

Sequence for structuring any learning experience, from a 5-minute video to a semester course.

### The Nine Events

| Event | Purpose | Example Techniques |
|-------|---------|-------------------|
| 1. Gain attention | Focus learner mind | Provocative question, surprising statistic, video hook |
| 2. State objectives | Set expectations | "By the end, you will be able to..." |
| 3. Recall prior learning | Activate schema | Review quiz, discussion, concept map |
| 4. Present content | Deliver new information | Lecture, video, reading, demonstration |
| 5. Provide guidance | Support understanding | Examples, analogies, mnemonics, visuals |
| 6. Elicit performance | Practice | Exercises, simulations, role-play |
| 7. Provide feedback | Confirm/correct | Immediate response, coaching, rubric |
| 8. Assess performance | Verify mastery | Quiz, test, demonstration, project |
| 9. Enhance retention/transfer | Apply to context | Job aids, follow-up activities, spaced practice |

### Applying Gagné's Events

**For a 10-minute microlearning module**:
1. Attention: 30-sec hook (15 sec)
2. Objectives: Single statement (10 sec)
3. Prior knowledge: Quick recall question (30 sec)
4. Content: Core teaching (4 min)
5. Guidance: Example walkthrough (2 min)
6. Practice: 2-3 interactions (2 min)
7. Feedback: Immediate response (included above)
8. Assessment: 2-3 quiz questions (1 min)
9. Transfer: Job aid or next steps (15 sec)

**For a 1-hour workshop**:
Expand each event proportionally, with emphasis on events 4-7.

---

## Backward Design (Understanding by Design)

Created by Wiggins and McTighe. Start with outcomes and work backward.

### Three Stages

#### Stage 1: Identify Desired Results
**Questions to answer**:
- What should learners understand?
- What knowledge and skills should they acquire?
- What is worthy of understanding?
- What enduring understandings are desired?

**Outputs**:
- Big ideas/essential questions
- Learning goals and objectives
- Transfer goals

#### Stage 2: Determine Acceptable Evidence
**Questions to answer**:
- How will we know if learners have achieved the desired results?
- What evidence will we accept?
- What performance tasks will demonstrate understanding?

**Outputs**:
- Performance assessments
- Rubrics and criteria
- Other evidence (quizzes, observations)

#### Stage 3: Plan Learning Experiences
**Questions to answer**:
- What activities, sequence, and resources will achieve the goals?
- What instruction is needed?
- How will we differentiate for diverse learners?

**Outputs**:
- Lesson plans
- Activity sequence
- Resources and materials

### When to Use Backward Design

**Best for**:
- Outcome-focused training (competency-based)
- Complex skill development
- Ensuring assessment-objective alignment
- Avoiding "content coverage" trap

---

## Model Selection Guide

| Factor | ADDIE | SAM | Merrill | Gagné | Backward Design |
|--------|-------|-----|---------|-------|-----------------|
| Timeline | Long | Short | Any | Any | Medium |
| Content stability | Stable | Changing | Any | Any | Stable |
| Stakeholder availability | Low | High | N/A | N/A | Medium |
| Project size | Large | Any | Any | Any | Medium-Large |
| Risk tolerance | Low | High | N/A | N/A | Low |
| Documentation needs | High | Low | N/A | N/A | Medium |

**Combination approaches**:
- Use **ADDIE** for project phases, **Gagné** for lesson structure
- Use **SAM** for iteration, **Merrill** for design principles
- Use **Backward Design** for objectives, **Gagné** for delivery

**Note**: Merrill and Gagné are design principles that work within any project model.
