# Learning Objectives Guide

Comprehensive reference for writing measurable learning objectives using Bloom's Revised Taxonomy.

## Contents
- Writing Effective Objectives
- Bloom's Taxonomy Levels
- Action Verbs by Level
- Objective Quality Checklist
- Common Mistakes to Avoid

---

## Writing Effective Objectives

### The ABCD Format

**A** - Audience: Who is the learner?
**B** - Behavior: What will they do? (observable action verb)
**C** - Condition: Under what circumstances?
**D** - Degree: To what standard?

**Template**:
> By the end of [this module/course], [audience] will be able to [behavior/action verb] + [content] + [condition] + [degree/criteria].

**Examples**:

| Component | Example 1 | Example 2 |
|-----------|-----------|-----------|
| Audience | Participants | New managers |
| Behavior | Calculate | Conduct |
| Content | Return on investment | A performance review |
| Condition | Given financial statements | Using the company template |
| Degree | With 95% accuracy | That meets all five criteria |

**Full objectives**:
- "By the end of this module, participants will be able to **calculate** return on investment given financial statements with 95% accuracy."
- "By the end of this course, new managers will be able to **conduct** a performance review using the company template that meets all five criteria."

---

## Bloom's Revised Taxonomy (2001)

Cognitive levels from lowest to highest complexity:

```
┌─────────────────────────────────────┐
│            CREATE                    │  Highest
│     Generate new ideas/products      │
├─────────────────────────────────────┤
│            EVALUATE                  │
│    Judge/decide based on criteria    │
├─────────────────────────────────────┤
│            ANALYZE                   │
│    Break down, find relationships    │
├─────────────────────────────────────┤
│             APPLY                    │
│    Use information in new ways       │
├─────────────────────────────────────┤
│           UNDERSTAND                 │
│    Explain ideas or concepts         │
├─────────────────────────────────────┤
│            REMEMBER                  │  Lowest
│     Recall facts and basic concepts  │
└─────────────────────────────────────┘
```

---

## Action Verbs by Cognitive Level

### Level 1: Remember
Retrieve relevant knowledge from long-term memory.

| Verb | Usage Example |
|------|---------------|
| Define | Define the term "machine learning" |
| Describe | Describe the three branches of government |
| Identify | Identify the steps in the sales process |
| Label | Label the parts of a cell diagram |
| List | List the five stages of project management |
| Match | Match terms to their definitions |
| Name | Name the four Ps of marketing |
| Recall | Recall the safety procedures for fire evacuation |
| Recognize | Recognize common phishing indicators |
| State | State the company's mission |

**Additional verbs**: cite, duplicate, enumerate, locate, memorize, quote, recite, record, repeat, reproduce, select, tabulate

### Level 2: Understand
Construct meaning from instructional messages.

| Verb | Usage Example |
|------|---------------|
| Classify | Classify customer complaints by type |
| Compare | Compare agile and waterfall methodologies |
| Contrast | Contrast debit and credit transactions |
| Describe | Describe how photosynthesis works |
| Discuss | Discuss the implications of the new policy |
| Explain | Explain why data backups are important |
| Interpret | Interpret the trends shown in the sales graph |
| Paraphrase | Paraphrase the key points of the presentation |
| Summarize | Summarize the chapter's main arguments |
| Translate | Translate technical jargon into layman's terms |

**Additional verbs**: associate, categorize, conclude, convert, differentiate, distinguish, estimate, exemplify, extend, generalize, give examples, illustrate, infer, predict, restate

### Level 3: Apply
Use a procedure in a given situation.

| Verb | Usage Example |
|------|---------------|
| Apply | Apply the STAR method to interview responses |
| Calculate | Calculate compound interest using the formula |
| Demonstrate | Demonstrate proper CPR technique |
| Execute | Execute the database backup procedure |
| Implement | Implement the new onboarding checklist |
| Operate | Operate the CNC machine safely |
| Perform | Perform a basic needs assessment |
| Solve | Solve customer service scenarios |
| Use | Use the CRM to log customer interactions |
| Complete | Complete Form W-4 correctly |

**Additional verbs**: administer, carry out, chart, compute, construct, develop, employ, examine, experiment, illustrate, modify, practice, prepare, produce, schedule, show, sketch

### Level 4: Analyze
Break material into parts and determine relationships.

| Verb | Usage Example |
|------|---------------|
| Analyze | Analyze the root cause of the system failure |
| Compare | Compare and contrast two leadership styles |
| Deconstruct | Deconstruct the argument's logical structure |
| Differentiate | Differentiate between facts and opinions |
| Distinguish | Distinguish relevant from irrelevant data |
| Examine | Examine the factors contributing to turnover |
| Identify | Identify patterns in customer feedback |
| Investigate | Investigate the source of the discrepancy |
| Organize | Organize the data into meaningful categories |
| Outline | Outline the decision-making process used |

**Additional verbs**: attribute, break down, categorize, characterize, classify, correlate, debate, deduce, diagram, discriminate, dissect, divide, infer, integrate, inventory, question, relate, select, separate, subdivide, test

### Level 5: Evaluate
Make judgments based on criteria and standards.

| Verb | Usage Example |
|------|---------------|
| Appraise | Appraise the quality of the submitted work |
| Assess | Assess the risk level of the proposed strategy |
| Conclude | Conclude whether the hypothesis is supported |
| Critique | Critique the research methodology |
| Decide | Decide which vendor best meets requirements |
| Defend | Defend your recommended approach |
| Evaluate | Evaluate the effectiveness of the campaign |
| Judge | Judge whether the solution meets specifications |
| Justify | Justify the budget allocation decisions |
| Prioritize | Prioritize tasks based on urgency and impact |

**Additional verbs**: argue, award, choose, compare, consider, convince, determine, discriminate, grade, measure, monitor, rank, rate, recommend, review, score, select, support, validate, verify, weigh

### Level 6: Create
Put elements together to form a new coherent whole.

| Verb | Usage Example |
|------|---------------|
| Compose | Compose an email response to a customer complaint |
| Construct | Construct a project timeline |
| Create | Create a marketing plan for the new product |
| Design | Design a training program for new hires |
| Develop | Develop a budget for the initiative |
| Formulate | Formulate a hypothesis based on the data |
| Generate | Generate three solutions to the problem |
| Invent | Invent a new process for quality assurance |
| Plan | Plan a customer retention strategy |
| Produce | Produce a video tutorial for the software |

**Additional verbs**: arrange, assemble, build, combine, compile, devise, hypothesize, integrate, make, modify, organize, originate, prepare, propose, rearrange, reconstruct, reorganize, revise, rewrite, set up, synthesize, write

---

## Objective Quality Checklist

For each objective, verify:

- [ ] **Specific**: Clearly states what the learner will do
- [ ] **Measurable**: Uses observable action verb
- [ ] **Achievable**: Realistic within training scope
- [ ] **Relevant**: Aligned to job performance needs
- [ ] **Time-bound**: Achievable within stated timeframe

### Additional Quality Checks

- [ ] Starts with an action verb (not "understand," "know," or "learn")
- [ ] Focuses on learner behavior, not instructor activity
- [ ] Specifies conditions if they affect performance
- [ ] Includes criteria/standards if needed for assessment
- [ ] Is written at the appropriate Bloom's level for the content
- [ ] One behavior per objective (not "and" or "or")

---

## Common Mistakes to Avoid

### Vague Verbs

| Avoid | Use Instead |
|-------|-------------|
| Understand | Explain, describe, summarize |
| Know | Identify, define, list |
| Learn | Demonstrate, perform, apply |
| Appreciate | Evaluate, critique, defend |
| Be familiar with | Recognize, identify, describe |
| Be aware of | List, state, describe |

### Instructor-Focused Language

| Wrong | Right |
|-------|-------|
| "Teach the five steps..." | "Learners will apply the five steps..." |
| "Cover the new policy..." | "Learners will explain the new policy..." |
| "Introduce Excel formulas..." | "Learners will calculate using Excel formulas..." |

### Multiple Behaviors

| Wrong | Right |
|-------|-------|
| "Identify and apply the rules" | Split into two objectives |
| "Analyze data and create reports" | Split into two objectives |

### Missing Context or Criteria

| Weak | Strong |
|------|--------|
| "Calculate percentages" | "Calculate percentages given raw data, with 100% accuracy" |
| "Write a business email" | "Write a professional business email that includes all five required elements" |

---

## Quick Reference: Verb Selection by Training Type

| Training Type | Primary Levels | Key Verbs |
|--------------|----------------|-----------|
| Compliance | Remember, Understand | Identify, explain, describe, list |
| Software/Technical | Apply, Analyze | Operate, navigate, troubleshoot, configure |
| Sales/Customer Service | Apply, Evaluate | Demonstrate, respond, handle, assess |
| Leadership | Analyze, Evaluate, Create | Analyze, evaluate, develop, design |
| Safety | Remember, Apply | Identify, demonstrate, follow, perform |
| Onboarding | Remember, Understand, Apply | Describe, explain, navigate, complete |
