# Technical E-Learning Standards

Reference for SCORM, xAPI, and cmi5 specifications for LMS compatibility.

## Contents
- Standards Overview
- SCORM Specifications
- xAPI (Experience API)
- cmi5
- Selection Guide
- Implementation Checklist

---

## Standards Overview

| Standard | Released | Primary Use | Data Model |
|----------|----------|-------------|------------|
| SCORM 1.2 | 2001 | Legacy LMS, simple tracking | Completion, score, time |
| SCORM 2004 | 2004 | Sequencing, detailed tracking | Objectives, interactions |
| xAPI | 2013 | Any experience, any platform | Activity statements |
| cmi5 | 2016 | Modern LMS, mobile apps | xAPI + LMS integration |

### Quick Selection

- **SCORM 1.2**: Use when LMS only supports SCORM, simple tracking needs
- **SCORM 2004**: Use for sequencing rules, older enterprise LMS
- **xAPI**: Use for tracking beyond LMS (mobile, simulations, real-world)
- **cmi5**: Use for modern LMS with mobile app support, best of both worlds

---

## SCORM Specifications

### SCORM 1.2

**Supported data elements**:

| Element | Description | Format |
|---------|-------------|--------|
| `cmi.core.lesson_status` | Completion state | passed, completed, failed, incomplete, browsed, not attempted |
| `cmi.core.score.raw` | Score achieved | 0-100 |
| `cmi.core.score.min` | Minimum possible | Number |
| `cmi.core.score.max` | Maximum possible | Number |
| `cmi.core.session_time` | Time in session | HHHH:MM:SS.SS |
| `cmi.core.total_time` | Cumulative time | HHHH:MM:SS.SS |
| `cmi.suspend_data` | Bookmark data | String (max 4096 chars) |
| `cmi.core.lesson_location` | Bookmark location | String (max 255 chars) |

**Completion rules**:
```
passed     = Score >= mastery score
completed  = All required elements viewed
failed     = Score < mastery score
incomplete = Started but not completed
browsed    = Launched but minimal interaction
```

**Limitations**:
- Content must be in same domain as LMS
- Requires browser JavaScript
- No mobile app support
- Limited data storage (4KB suspend_data)

### SCORM 2004

**Additional capabilities**:

| Feature | Description |
|---------|-------------|
| Sequencing | Control content order based on rules |
| Objectives | Track multiple learning objectives |
| Interactions | Log individual question responses |
| Rollup | Calculate scores across SCOs |

**Objective tracking**:
```javascript
// Set objective status
cmi.objectives.0.id = "obj_safety_basics"
cmi.objectives.0.success_status = "passed"
cmi.objectives.0.completion_status = "completed"
cmi.objectives.0.score.scaled = 0.85
```

**Interaction tracking**:
```javascript
// Log question response
cmi.interactions.0.id = "q1_safety_scenario"
cmi.interactions.0.type = "choice"
cmi.interactions.0.learner_response = "b"
cmi.interactions.0.correct_responses.0.pattern = "b"
cmi.interactions.0.result = "correct"
cmi.interactions.0.latency = "PT45S"
```

**Sequencing rules** (simplified):
- Pre-conditions: Requirements before accessing content
- Post-conditions: Actions after completing content
- Exit conditions: When to exit/continue sequence

**SCORM 2004 Editions**:
- 1st Edition (2004): Initial release
- 2nd Edition (2004): Bug fixes
- 3rd Edition (2006): Clarifications
- 4th Edition (2009): Final, recommended version

---

## xAPI (Experience API)

### Statement Structure

xAPI tracks experiences as statements: **Actor + Verb + Object** (+ optional Result, Context).

```json
{
  "actor": {
    "mbox": "mailto:learner@example.com",
    "name": "Jane Smith"
  },
  "verb": {
    "id": "http://adlnet.gov/expapi/verbs/completed",
    "display": {"en-US": "completed"}
  },
  "object": {
    "id": "http://example.com/courses/safety-101",
    "definition": {
      "name": {"en-US": "Safety Fundamentals"},
      "type": "http://adlnet.gov/expapi/activities/course"
    }
  },
  "result": {
    "score": {"scaled": 0.85},
    "success": true,
    "completion": true,
    "duration": "PT35M"
  },
  "context": {
    "instructor": {"name": "John Trainer"},
    "platform": "Example LMS"
  },
  "timestamp": "2024-01-15T14:30:00Z"
}
```

### Common Verbs

| Verb | IRI | Use For |
|------|-----|---------|
| initialized | .../verbs/initialized | Started activity |
| completed | .../verbs/completed | Finished activity |
| passed | .../verbs/passed | Met success criteria |
| failed | .../verbs/failed | Did not meet criteria |
| scored | .../verbs/scored | Received a score |
| answered | .../verbs/answered | Responded to question |
| experienced | .../verbs/experienced | Watched, read, viewed |
| attempted | .../verbs/attempted | Made an attempt |

**ADL verb registry**: http://adlnet.gov/expapi/verbs/

### Activity Types

| Type | IRI | Description |
|------|-----|-------------|
| course | .../activities/course | Overall course |
| module | .../activities/module | Course section |
| assessment | .../activities/assessment | Quiz or test |
| interaction | .../activities/interaction | Single question |
| simulation | .../activities/simulation | Simulation |
| media | .../activities/media | Video or audio |

### Learning Record Store (LRS)

xAPI statements are sent to an LRS, which can be:
- Standalone LRS (Learning Locker, Watershed, etc.)
- LMS-integrated LRS
- Custom LRS implementation

**LRS API endpoints**:
```
POST /statements           # Send statement(s)
GET  /statements           # Query statements
PUT  /activities/state     # Store state data
GET  /activities/state     # Retrieve state data
```

### When to Use xAPI

**Ideal for**:
- Mobile app learning
- Simulations and games
- On-the-job performance tracking
- Multi-platform experiences
- Social learning activities
- Detailed analytics needs

**Considerations**:
- Requires LRS (additional infrastructure)
- No standard launch mechanism (see cmi5)
- More complex implementation
- Privacy considerations for granular tracking

---

## cmi5

Combines xAPI's flexibility with SCORM's LMS integration.

### Key Features

| Feature | cmi5 Approach |
|---------|---------------|
| Launch | LMS launches content with token |
| Communication | xAPI statements to LRS |
| Data model | Defined subset of xAPI |
| Course structure | XML package manifest |
| Completion | Standardized rules |

### cmi5 Defined Statements

**Required verbs for content**:
- `initialized` - Content launched
- `completed` - Content finished
- `passed` or `failed` - Assessment result
- `terminated` - Content closed

**LMS-sent verbs**:
- `launched` - LMS started content
- `abandoned` - Session timed out
- `waived` - Credit given without completion
- `satisfied` - Requirements met

### Course Structure (XML)

```xml
<?xml version="1.0" encoding="UTF-8"?>
<courseStructure xmlns="https://w3id.org/xapi/profiles/cmi5/v1/CourseStructure.xsd">
  <course id="http://example.com/courses/safety-101">
    <title><langstring lang="en-US">Safety Fundamentals</langstring></title>
    <description><langstring lang="en-US">Basic workplace safety</langstring></description>
  </course>
  <au id="http://example.com/au/intro">
    <title><langstring lang="en-US">Introduction</langstring></title>
    <url>content/intro/index.html</url>
    <launchMethod>AnyWindow</launchMethod>
    <moveOn>Completed</moveOn>
  </au>
  <au id="http://example.com/au/assessment">
    <title><langstring lang="en-US">Final Assessment</langstring></title>
    <url>content/assessment/index.html</url>
    <launchMethod>AnyWindow</launchMethod>
    <moveOn>Passed</moveOn>
    <masteryScore>0.8</masteryScore>
  </au>
</courseStructure>
```

### Assignable Unit (AU) Properties

| Property | Description | Values |
|----------|-------------|--------|
| launchMethod | How to open content | AnyWindow, OwnWindow |
| moveOn | Completion criteria | Passed, Completed, CompletedAndPassed, CompletedOrPassed, NotApplicable |
| masteryScore | Passing threshold | 0.0 - 1.0 |
| launchParameters | Custom data | String |
| activityType | xAPI activity type | IRI |

### Launch Mechanism

LMS provides launch URL with parameters:
```
https://content.example.com/course/index.html
  ?endpoint=https://lrs.example.com/xapi/
  &fetch=https://lms.example.com/cmi5/token/abc123
  &actor={"mbox":"mailto:jane@example.com"}
  &registration=550e8400-e29b-41d4-a716-446655440000
  &activityId=http://example.com/au/intro
```

Content retrieves auth token from fetch URL, then communicates with LRS.

### When to Use cmi5

**Ideal for**:
- Modern LMS implementations
- Mobile app + web content mix
- Content hosted separately from LMS
- Need both LMS integration and xAPI analytics
- Replacing SCORM in new projects

**Adoption note**: Growing support but not yet universal. Verify LMS compatibility.

---

## Selection Guide

### Decision Tree

```
Do you need to track beyond the LMS?
├─ Yes → Do you need LMS launch/completion?
│        ├─ Yes → cmi5
│        └─ No  → xAPI
└─ No  → Does your LMS support SCORM 2004?
         ├─ Yes → Need sequencing or detailed interaction data?
         │        ├─ Yes → SCORM 2004
         │        └─ No  → SCORM 1.2
         └─ No  → SCORM 1.2
```

### Comparison Matrix

| Requirement | SCORM 1.2 | SCORM 2004 | xAPI | cmi5 |
|-------------|-----------|------------|------|------|
| Basic completion | ✓ | ✓ | ✓ | ✓ |
| Score tracking | ✓ | ✓ | ✓ | ✓ |
| Objective tracking | ✗ | ✓ | ✓ | ✓ |
| Interaction data | Limited | ✓ | ✓ | ✓ |
| Sequencing rules | ✗ | ✓ | ✗ | ✗ |
| Mobile app support | ✗ | ✗ | ✓ | ✓ |
| Offline capability | ✗ | ✗ | ✓ | ✓ |
| Content anywhere | ✗ | ✗ | ✓ | ✓ |
| Detailed analytics | ✗ | Limited | ✓ | ✓ |
| LMS integration | ✓ | ✓ | ✗ | ✓ |
| LMS support | Universal | Wide | Growing | Growing |

---

## Implementation Checklist

### SCORM Implementation

- [ ] Verify LMS SCORM version support (1.2 or 2004)
- [ ] Define completion criteria (score threshold, pages viewed)
- [ ] Determine data to track (completion, score, time, bookmarks)
- [ ] Create manifest file (imsmanifest.xml)
- [ ] Implement API wrapper in content
- [ ] Test in SCORM Cloud or target LMS
- [ ] Validate package with ADL SCORM Test Suite

### xAPI Implementation

- [ ] Set up or identify LRS
- [ ] Define activity IRIs and structure
- [ ] Choose/create verb vocabulary
- [ ] Design statement templates
- [ ] Implement xAPI library in content
- [ ] Configure authentication (Basic Auth or OAuth)
- [ ] Test statement generation
- [ ] Build reporting/analytics views

### cmi5 Implementation

- [ ] Verify LMS cmi5 support
- [ ] Create course structure XML
- [ ] Define Assignable Units
- [ ] Configure moveOn criteria
- [ ] Implement cmi5 library in content
- [ ] Handle launch parameter parsing
- [ ] Implement required statements
- [ ] Test launch and completion flow
- [ ] Validate with cmi5 conformance test
