---
name: digicluster-build-deploy
description: Build/deploy/troubleshoot DigiCluster on Verdin iMX8MP. Always read /DOCS/BUILD_AND_DEPLOY.md first and never invent commands.
---

# DigiCluster Build/Deploy Skill

## Read this first: two separate devices (non-negotiable)
DigiCluster contains code for **two different devices**:

1) **DigiCluster (DC)**  
   - Runs on the **Verdin iMX8MP** (Torizon OS / systemd service `digicluster.service`)
   - This skill covers **building + deploying DigiCluster to the Verdin only**

2) **Kaiser Engineering Dash (KE)**  
   - Runs on the **Kaiser dash hardware (STM32 firmware)**
   - Its firmware lives in the repo folder: `ke_digital_dash_firmware-1.0.8/`
   - **Even though the KE firmware folder is inside the DigiCluster repo, it is NOT part of the DigiCluster software build/deploy pipeline.**
   - **Jonathan handles building/deploying KE firmware. Claude must NOT attempt to build/deploy KE firmware.**

### Important boundary
- If changes are made under `ke_digital_dash_firmware-1.0.8/`, Claude may help with **code changes only**, but must explicitly note:
  - **“Jonathan must build and deploy this to the Kaiser dash.”**
- Claude should not provide KE flashing steps, toolchain steps, or deployment commands unless Jonathan explicitly requests them.

## Source of truth (non-negotiable)
**The single source of truth for DigiCluster build/deploy is: `/DOCS/BUILD_AND_DEPLOY.md`.**
- Before giving commands, open/read `/DOCS/BUILD_AND_DEPLOY.md`.
- If chat instructions conflict with the doc, follow the doc, unless explicitly instructed.
- If the doc is missing a step, say so and suggest updating the doc, rather than guessing.

## When to use this skill
Use for DigiCluster (Verdin) only:
- building / clean rebuild
- deploy (LAN or Tailscale)
- restarting `digicluster.service`
- logs + “what’s actually running”
- troubleshooting stale artifacts/cache, “module not found”, boot animation stuck

## Output rules
- Split steps into:
  - **On Host (Linux)**
  - **On Target (Verdin over SSH)**
- Provide copy/paste command blocks only.
- Prefer the deploy script (`./scripts/deploy.sh <ip>`) as the recommended method.

## Known doc facts (verify in /DOCS/BUILD_AND_DEPLOY.md before using)
- Build: `source ~/verdin-sdk/environment-setup-armv8a-tdx-linux && cd /home/jonathan/Desktop/DigiClusterV2.1/build-verdin && make -j8`
- Deploy: `cd /home/jonathan/Desktop/DigiClusterV2.1 && ./scripts/deploy.sh <ip>`
- LAN IP: `10.0.0.40`
- Tailscale IP: `100.114.219.6`
- Service: `digicluster.service`
- Install root: `/opt/digicluster/`

## Don’ts
- Don't use "head" or "tail" commands on build/deploy commands.
- Don’t recommend legacy deployment unless explicitly asked.
- Don’t guess commands, paths, or service names.
- Don’t treat `ke_digital_dash_firmware-1.0.8/` as part of DigiCluster’s build/deploy.
- Don’t attempt to build/deploy Kaiser dash firmware (KE). Jonathan handles that.