---
name: discord-gd
description: Complete Discord.gd knowledge base for creating Discord bots in Godot. Use for Discord API integration, handling messages, buttons, select menus, slash commands, embeds, and Discord interactions in GDScript.
---

# Discord.gd Skill

Comprehensive assistance for Discord.gd Godot plugin development, generated from official documentation.

## When to Use This Skill

This skill should be triggered when:
- Creating Discord bots in Godot with Discord.gd
- Implementing Discord API features (messages, buttons, embeds, slash commands)
- Working with Discord interactions and components
- Debugging Discord.gd code or integration issues
- Learning Discord.gd best practices and patterns

## Quick Reference

### Common Patterns

*Quick reference patterns will be added as you use the skill.*

### Example Code Patterns

**Example 1** (GDScript):
```GDScript
{
    text: String, text of the footer,
    icon_url?: String, url of footer icon,
    proxy_url?: String, proxied url of footer icon
}
```

## Reference Files

This skill includes comprehensive documentation in `references/`:

- **components.md** - Components documentation
- **core_classes.md** - Core Classes documentation
- **examples.md** - Examples documentation
- **getting_started.md** - Getting Started documentation
- **interactions.md** - Interactions documentation
- **other.md** - Other documentation
- **updates.md** - Updates documentation
- **utilities.md** - Utilities documentation

Use `view` to read specific reference files when detailed information is needed.

## Working with This Skill

### For Beginners
Start with the getting_started or tutorials reference files for foundational concepts.

### For Specific Features
Use the appropriate category reference file (api, guides, etc.) for detailed information.

### For Code Examples
The quick reference section above contains common patterns extracted from the official docs.

## Resources

### references/
Organized documentation extracted from official sources. These files contain:
- Detailed explanations
- Code examples with language annotations
- Links to original documentation
- Table of contents for quick navigation

### scripts/
Add helper scripts here for common automation tasks.

### assets/
Add templates, boilerplate, or example projects here.

## Notes

- This skill was automatically generated from official documentation
- Reference files preserve the structure and examples from source docs
- Code examples include language detection for better syntax highlighting
- Quick reference patterns are extracted from common usage examples in the docs

## Updating

To refresh this skill with updated documentation:
1. Re-run the scraper with the same configuration
2. The skill will be rebuilt with the latest information
