# Discord-Gd-Docs - Components

**Pages:** 2

---

## SelectMenu¶

**URL:** https://3ddelano.github.io/discord.gd/classes/selectmenu/

**Contents:**
- SelectMenu¶
- Description¶
- Properties¶
- Methods¶
- Method Descriptions¶
  - set_custom_id(new_custom_id)¶
  - get_custom_id()¶
  - add_option(value, label, data?)¶
    - Examples¶
  - set_options(new_options)¶

See Discord SelectMenu docs

Provides methods for customising a select menu.

Sets the custom_id of the menu.

Returns the custom_id of the menu.

Add an option to the menu.

See Discord SelectMenu option docs

Send a menu with a single option

Send a multi-select menu

(For advanced users) Directly set the options of the menu by providing a Array of SelectMenu option.

Returns the options of the menu.

Sets the placeholder of the menu.

Returns the placeholder of the menu.

Sets the min_values of the menu.

Returns the min_values of the menu.

Sets the max_values of the menu.

Returns the max_values of the menu.

Sets the disabled state of the menu.

Returns whether the menu is disabled or not.

Prints the SelectMenu.

Use this instead of print(SelectMenu)

SelectMenu interactions are received via the DiscordBot.interaction_create signal.

**Examples:**

Example 1 (unknown):
```unknown
Represents a select menu component.
```

Example 2 (GDScript):
```GDScript
{
    # Only custom emojis are supported
    emoji: {
        id: "ID_OF_CUSTOM_EMOJI"
    },
    "description": String,  Description of the option
    "default": bool, Whether the option is selected by default
}
```

Example 3 (GDScript):
```GDScript
var menu = SelectMenu.new().set_custom_id("menu1")
menu.set_placeholder("Select an option")

menu.add_option("my_custom_option", "Buy a Parrot", {
    "description": "This is a nice parrot!",
    "emoji": {"id": "565171769187500032"}, # Animated parrot emoji
})

var row = MessageActionRow.new().add_component(menu)
bot.send(message, {
    "content": "Choose an item from the menu:",
    "components": [row]
})
```

Example 4 (GDScript):
```GDScript
var menu = SelectMenu.new().set_custom_id("menu1")
menu.set_placeholder("Select an option")

# Add first option
menu.add_option("parrot_option", "Buy a Parrot", {
    "description": "This is a nice parrot!",
    "emoji": {"id": "565171769187500032"}, # Animated parrot emoji
})

# Add second option
menu.add_option("green_checkmark_option", "A checkmark", {
    "description": "A nice green checkmark",
    "emoji": {"id": "556051807504433152"} # Green checkmark emoji
})

# Set the max selectable items to 2
menu.set_max_values(2)

var row = MessageActionRow.new().add_component(menu)
bot.send(message, {
    "content": "Choose item(s) from the menu:",
    "components": [row]
})
```

---

## Embed¶

**URL:** https://3ddelano.github.io/discord.gd/classes/embed/

**Contents:**
- Embed¶
- Description¶
- Properties¶
- Methods¶
- Method Descriptions¶
  - set_title(title)¶
  - set_type(type)¶
  - set_description(description)¶
  - set_url(url)¶
  - set_timestamp()¶

Contains all the data of an embed. It also has a few chainable methods to make creating embeds easy

See Discord Embed Stucture

footer: Dictionary (See Discord Embed Footer Structure)

image: Dictionary (See Discord Embed Image Structure)

thumbnail: Dictionary (See Discord Embed Thumbnail Structure)

video: Dictionary (See Discord Embed Video Structure)

provider: Dictionary (See Discord Embed Provider Structure)

author: Dictionary (See Discord Embed Author Structure)

Each field: Dictionary (See Discord Embed Field Structure)

Getters are also defined for the above functions which all return Dictionary

All setter methods and add_fields() return the Embed itself, so chaining of methods is possible

Sets the title of the Embed

Sets the type of the Embed

Sets the description of the Embed

Sets the url of the Embed

Sets the timestamp of the Embed to the current unix timestamp

Set the timestamp of an embed to the current ISO8601 timestamp

Sets the color of the Embed

Sets the footer of the Embed

Sets the image of the Embed

Sets the thumbnail of the Embed

Sets the video of the Embed

Sets the provider of the Embed

Sets the author of the Embed

Set the author of an Embed

Sets the field of the Embed

An Embed can have a max of 25 fields

Add multiple fields to an Embed

Removes, replaces, and inserts fields in the Embed.

Dictionary(field): Dictionary

To print an Embed, use Embed.print() instead of print(Embed)

**Examples:**

Example 1 (unknown):
```unknown
Wrapper for an Embed on Discord
```

Example 2 (GDScript):
```GDScript
{
    text: String, text of the footer,
    icon_url?: String, url of footer icon,
    proxy_url?: String, proxied url of footer icon
}
```

Example 3 (GDScript):
```GDScript
{
    url?: String, source url of image,
    proxy_url?: String, proxied url of image,
    height?: int, height of image,
    width?: int, width of image
}
```

Example 4 (GDScript):
```GDScript
{
    url?: String, source url of thumbnail,
    proxy_url?: String, proxied url of thumbnail,
    height?: int, height of thumbnail,
    width?: int, width of thumbnail
}
```

---
