# Discord-Gd-Docs - Core Classes

**Pages:** 8

---

## ApplicationCommand¶

**URL:** https://3ddelano.github.io/discord.gd/classes/applicationcommand/

**Contents:**
- ApplicationCommand¶
- Description¶
- Properties¶
- Methods¶
- Method Descriptions¶
  - get_id()¶
  - get_type()¶
  - set_type(new_type)¶
  - get_application_id()¶
  - set_name(new_name)¶

See Discord ApplicationCommand docs

Provides an interface to make and respond to Discord application commands.

Returns the id of the command.

Returns the type of the menu. One of (CHAT_INPUT, MESSAGE or USER)

Sets the type of this command.

Returns: ApplicationCommand

See Discord application command types docs

Returns the application_id of the parent application.

Sets the name of the command.

Returns: ApplicationCommand

Returns the name of the command.

Sets the description of the command.

Returns: ApplicationCommand

Returns the description of the command.

Returns the guild_id of the command.

(For advanced users) Directly set the options of the command by passing an Array of Dictionary options.

Returns: ApplicationCommand

Use ApplicationCommand.add_option() instead for easier usage.

Set the options to a single option

Returns the options of the command.

Easy way to add options to the command.

Returns: ApplicationCommand

To get the option_data use any of the static option generator methods like sub_command_option(), |sub_command_group_option(), string_option(), integer_option(), boolean_option(), user_option(), channel_option(), role_option(), mentionable_option() or number_option() of the ApplicationCommand class.

Add an autocompleted string option

Generates data for a sub command option.

See Discord application command option docs

Generates data for a sub command group option.

See Discord application command option docs

Add a sub command group with two sub commands

Generates data for a string option.

See Discord application command option docs

Add a single string option

Add multiple string options

Generates data for a integer option.

See Discord application command option docs

Add a single integer option (with min and max values)

Generates data for a boolean option.

See Discord application command option docs

Add a single boolean option

Generates data for a user option.

See Discord application command option docs

Add a single user option

Generates data for a channel option.

See Discord application command option docs

Add a single channel option

Generates data for a role option.

See Discord application command option docs

Generates data for a mentionable option.

See Discord application command option docs

Generates data for a number option.

See Discord application command option docs

Generates data for a command option choice.

See Discord application command option choice docs

Choices for a string option

Choices for a integer option

Choices for a number option

Prints the ApplicationCommand.

Use this instead of print(Message)Generates data for a command option choice.

See Discord registering a command docs

Use the DiscordBot.register_command() and DiscordBot.register_commands() methods to register commands.

While developing commands it's better to use guild level commands since they update instantly while global commands take upto 1hr to update.

Making a MESSAGE command

Making a USER command

Application commands will fire the DiscordBot.interaction_create signal.

Respond to an application command

**Examples:**

Example 1 (unknown):
```unknown
Represents a Discord application command.
```

Example 2 (GDScript):
```GDScript
var cmd1 = ApplicationCommand.new().set_name("test")\
            .set_description("Testing description")
cmd1.set_options(
    [{
        "type": 3,
        "name": "string-option",
        "description": "This is a string option"
    }]
)
```

Example 3 (GDScript):
```GDScript
var cmd1 = ApplicationCommand.new().set_name("view")\
            .set_description("View an item.")
cmd1.add_option(
    ApplicationCommand.string_option("item", "Name of the item to view")
)
```

Example 4 (GDScript):
```GDScript
var cmd1 = ApplicationCommand.new().set_name("donate")\
            .set_description("Give someone money.")
cmd1.add_option(
    ApplicationCommand.user_option("user", "The person to donate to.", {
        # Make this option compulsory
        "required": true
    })
)
```

---

## MessageFlags¶

**URL:** https://3ddelano.github.io/discord.gd/classes/messageflags/

**Contents:**
- MessageFlags¶
- Description¶
- Flags¶

An extended data structure which defines the flags supported by a Message on Discord. See Discord Message Flags Docs

This is a bitfield, so you can use the properties and methods of BitField.

**Examples:**

Example 1 (unknown):
```unknown
Data structure that makes it easy to interact with the Message.flags bitfield.
```

---

## Message¶

**URL:** https://3ddelano.github.io/discord.gd/classes/message/

**Contents:**
- Message¶
- Description¶
- Properties¶
- Methods¶
- Method Descriptions¶
  - print()¶
  - slice_attachments(index, delete_count?, replace_attachments?)¶

Stores all the data related to a message from Discord. It also has a few methods to manage the data in the message.

To print a Message, use Message.print() instead of print(Message)

See Discord Message Structure

Use this instead of print(Message)

Removes, replaces, and inserts attachments in the Message

The maximum file size of the Message must be less than 8MB

Each Attachment: See Discord Message Attachment Structure)

**Examples:**

Example 1 (unknown):
```unknown
Represents a message from, or to Discord.
```

Example 2 (GDScript):
```GDScript
{
    id: String, the id of the attachment,
    filename: String, the name of the file attached,
    content_type: String, MIME type of the file,
    size: int, size of the file in bytes,
    url: String, source url of the file
    proxy_url: String, a proxied url of the file,
    height?: int, height of file (if image),
    width?: int, width of file (if image)
}
```

---

## DiscordBot¶

**URL:** https://3ddelano.github.io/discord.gd/classes/discordbot/

**Contents:**
- DiscordBot¶
- Description¶
- Properties¶
- Methods¶
- Signals¶
- Method Descriptions¶
  - login() -> void¶
  - send(message_or_channelid, content, options?)¶
    - Examples¶
  - edit(message, content, options?)¶

A Node with the ability to communicate with the Discord websockets and REST API. Uses HTTPRequest internally. Uses signals to communicate websocket events from Discord to Godot.

See Discord Gateway Intents

bot_ready(bot: DiscordBot) Emitted when the bot is logged in to Discord. bot: The Discord bot itself

message_create(bot: DiscordBot, message: Message, channel: Dictionary) Emitted when the bot receives a new message. bot: The Discord bot itself message: The message that was received channel: The channel in which the message was received

message_delete(bot: DiscordBot, message: Dictionary) Emitted when any message was deleted. bot: The Discord bot itself message: The message that was deleted

message_reaction_add(bot: DiscordBot, data: Dictionary) Emitted when a user reacts to a message. bot: The Discord bot itself data: Data emitted with the event (See Event Fields)

message_reaction_remove(bot: DiscordBot, data: Dictionary) Emitted when a user removes a reaction from a message. bot: The Discord bot itself data: Data emitted with the event (See Event Fields)

message_reaction_remove_all(bot: DiscordBot, data: Dictionary) Emitted when a user explicitly removes all reactions from a message. bot: The Discord bot itself data: Data emitted with the event (See Event Fields)

message_reaction_remove_emoji(bot: DiscordBot, data: Dictionary) Emitted when a bot removes all instances of a given emoji from the reactions of a message. bot: The Discord bot itself data: Data emitted with the event (See Event Fields)

guild_create(bot: DiscordBot, guild: Dictionary) Emitted when the bot joins a new guild bot: The Discord bot itself guild: The guild that was just joined

guild_update(bot: DiscordBot, guild: Dictionary) Emitted when the guild is updated bot: The Discord bot itself guild: Data of the guild that was updated

guild_delete(bot: DiscordBot, guild_id: String) Emitted when the bot leaves a guild bot: The Discord bot itself guild_id: The id of the guild that the bot left

interaction_create(bot: DiscordBot, interaction: DiscordInteraction) Emitted when a new interaction is created bot: The Discord bot itself interaction: The interaction which was created

Connects the bot to the Discord websocket gateway.

If you want to set DiscordBot.INTENTS to a custom value, set it before calling DiscordBot.login()

The DiscordBot.TOKEN must be set prior to calling DiscordBot.login()

Sends a message to a channel

Returns: Promise<Message>

Each file in files: Dictionary

Send only a text message

Send a text message and an embed

Send only a image file

Send a message as a reply to another message

It's better to use DiscordBot.reply() to reply to messages, but if you want to use DiscordBot.send(), pass in a message_reference object to the options

Send three messages in order

Edits a sent message.

Returns: Promise<Message>

The content and options are same as DiscordBot.send()

Adding a file to a message that already has files results in both files existing on the new message. To only have the new file remain, use Message.slice_attachments()

Edit the content of a message

Edit the embed of a message

Deletes the message with same id as message.

Returns: Promise<bool> The function returns true if the message is deleted, otherwise it returns the HTTP error code.

The bot should have MANAGE_MESSAGES permission inorder to delete messages of other users.

Delete a message sent by the bot

Delete a message sent by a user

Returns: Promise<Message>

The content and options are same as DiscordBot.send()

Creates a new thread with name as name, archive duration as duration and with the starter message as message. It returns the information of the new thread.

Returns: Promise<Dictionary>

Start a new thread with the name as discord.gd

Returns the guild icon of the guild.

Returns: Promise<PoolByteArray>

To get the guild_icon as an Image or ImageTexture use Helpers.to_png_image() and Helpers.to_image_texture()

Get the guild icon as an Image

Get the guild icon as an ImageTexture

Sets the presence of the bot

Set the presence of the bot to "Playing Godot Engine"

Returns the permissions the bot has in a specific channel after applying channel overwrites

Check if the bot has the SEND_MESSAGES pemissions before sending a message

Returns the permissions for a specific user in a specific channel

This currently only works for the Bot, since loading the guild users requires the GUILD_MEMBERS priviledged intent.

Fetches a specific guild member's data

Returns: Promise<Dictionary>

Get the guild member data of the user who sent the message

Adds the role to the member

Returns the HTTP response code (204 is success)

This requires the MANAGE_ROLES permission

Add the role with id 374446838406709259 to the user who sent the message

Removes the role from the member

Returns the HTTP response code (204 is success)

This requires the MANAGE_ROLES permission

Remove the role with id 374446838406709259 from the user who sent the message

Returns an array of all the custom emojis of the guild

Returns: Promise<Array>

Get the custom emojis of the guild in which the message was sent

Returns the channel data of the DM channel between the bot and the recipient

Returns: Promise<Dictionary>

Send the user with id "32123387577696256" a DM

Creates a emoji reaction for the message.

Returns the http response code (204 is success).

Only CUSTOM EMOJIS are supported since Godot can't render unicode emojis. Pass only the Id of the custom emoji for custom_emoji parameter.

This requires the READ_MESSAGE_HISTORY permission. Additionally, if nobody else has reacted to the message using this emoji, this endpoint requires the ADD_REACTIONS permission to be present on the current user.

React with an animated parrot

React with an animated parrot and a white checkmark in order

React without using the entire Message object

Deletes the bot's or a user's reaction of an emoji.

Returns: Promise<int>

Returns the http response code (204 is success).

This requires the MANAGE_MESSAGES permission

Only CUSTOM emojis are supported since Godot can't render unicode emojis. Pass only the Id of the custom emoji as custom_emoji.

Delete the bot's reaction of an animated parrot

Delete the bot's reaction of an animated parrot and a white checkmark in order

Delete the reaction of the user

Delete the reaction of the user as soon as it was reacted to

Deletes all reactions of the emoji on the message.

Returns: Promise<int>

Returns the http response code (204 is success).

Only CUSTOM emojis are supported since Godot can't render unicode emojis. Pass only the Id of the custom emoji as the custom_emoji.

This requires the MANAGE_MESSAGES permission

Delete all reactions on the animated parrot emoji the mesasge

Returns a list of users that reacted with this emoji.

Returns: Promise<Array>

Only CUSTOM emojis are supported since Godot can't render unicode emojis. Pass only the Id of the custom emoji as custom_emoji.

Get the list of users who reacted to the animated parrot emoji

Register the command as a global or guild level command.

Returns: Promise<ApplicationCommand>

While developing commands it's better to use guild level commands since they update instantly while global commands take upto 1hr to update. See Discord registering a command docs

Register a global command

Register command for a specific guild

Register a global command with options (Specific example)

Bulk register multiple commands as a global or guild level commands.

Returns: Promise<Array<ApplicationCommand>>

This will overwrite all types of application commands: slash, user and message Application Commands

Register three commands globally at once

Register three commands for a guild at once

Delete a global or guild level command.

Returns: Promise<int>

Returns the HTTP response code (204 is success).

Delete a global command

Deletes all global or guild level commands.

Returns: Promise<int>

Returns the HTTP response code (204 is success).

Delete all global commands

Delete all commands for a specific guild

Fetch a global or guild level command.

Returns: Promise<ApplicationCommand>

Fetch all global or guild level commands.

Returns: Promise<Array<ApplicationCommand>>

**Examples:**

Example 1 (unknown):
```unknown
The main Node which interacts with the Discord API.
```

Example 2 (GDScript):
```GDScript
{
  embeds?: Array of Embed,
  files?: Array of files
  tts?: bool,
  allowed_mentions?: Dictionary (See https://discord.com/developers/docs/resources/channel#allowed-mentions-object)
}
```

Example 3 (GDScript):
```GDScript
{
  data: PoolByteArray, the raw bytes of the file,
  name: String, the name of the file with extension,
  media_type: String, the MIME type of the file
}
```

Example 4 (GDScript):
```GDScript
# This function is called when the message_create signal is emitted
func _on_message_create(bot: DiscordBot, message: Message, channel: Dictionary):
  bot.send(message, "hello")
  # OR
  # bot.send(message.channel_id, "hello")
  # OR
  # bot.send(channel.id, "hello")
```

---

## MessageButton¶

**URL:** https://3ddelano.github.io/discord.gd/classes/messagebutton/

**Contents:**
- MessageButton¶
- Description¶
- Enums¶
  - STYLES¶
- Properties¶
- Methods¶
- Method Descriptions¶
  - set_style(style_type)¶
    - Examples¶
  - get_style()¶

See Discord Button docs

Provides methods for customising a message button.

Sets the style of the button.

Returns: MessageButton

Set the button style to LINK

Returns the style of the button.

Sets the label of the button.

Returns: MessageButton

Set the button label to "Click Me"

Returns the label of the button.

Sets the custom_id of the button.

Returns: MessageButton

Set the button custom_id to "primary_button"

Returns the custom_id of the button.

Sets the url of the button.

Returns: MessageButton

Returns the url of the button.

Sets the disabled state of the button.

Returns: MessageButton

Returns whether the button is disabled or not.

Sets the emoji of the button.

new_emoji: Dictionary See Discord Emoji Structure

This works only for Custom Emojis. The default ASCII emojis will not work. Its a limitation of Godot.

Workaround for button emojis

If you want to use the default ASCII emojis as an emoji for the button. 1. Add the emoji you want as a custom emoji on any server 2. Get the emoji id of the custom emoji 3. Use this id in the id field of the MessageButton.set_emoji() (See examples below)

Send a green checkmark emoji button

Send an animated parrot emoji button

Get the emoji of the button if it has one.

Prints the MessageButton.

Use this instead of print(MessageButton)

MessageButton interactions are received via the DiscordBot.interaction_create signal.

**Examples:**

Example 1 (unknown):
```unknown
Represents a button message component.
```

Example 2 (GDScript):
```GDScript
{
    DEFAULT,
    PRIMARY,
    SECONDARY,
    SUCCESS,
    DANGER,
    LINK
}
```

Example 3 (GDScript):
```GDScript
var button = MessageButton.new().set_style(MessageButton.STYLES.LINK)
```

Example 4 (GDScript):
```GDScript
var button = MessageButton.new().set_label("Click Me")
```

---

## User¶

**URL:** https://3ddelano.github.io/discord.gd/classes/user/

**Contents:**
- User¶
- Description¶
- Properties¶
- Methods¶
- Method Descriptions¶
  - get_display_avatar_url(options?)¶
    - Examples¶
  - get_default_avatar_url()¶
  - get_display_avatar(options?)¶
    - Examples¶

Stores all the data related to a user from Discord. It also has a few methods to manage the user data.

See Discord User Structure

Returns the url of the user's avatar icon

NoteIf the user has no avatar, the default avatar url will be returned

If the user has no avatar, the default avatar url will be returned

Get the user's avatar and use in an embed

Returns the url of the user's default avatar icon

Returns the raw bytes of the user's avatar icon

To get the avatar as an Image or ImageTexture use Helpers.to_png_image() and Helpers.to_image_texture()

If the user has no avatar set, the default avatar will be returned

Get the user's avatar as a PNG ImageTexture

Gets the user's avatar as a GIF automatically

Returns the raw bytes of the user's default avatar icon

To get the avatar as an Image or ImageTexture use Helpers.to_png_image() and Helpers.to_image_texture()

**Examples:**

Example 1 (unknown):
```unknown
Represents a user on Discord.
```

Example 2 (GDScript):
```GDScript
{
    format: String, one of "webp", "png", "jpg", "jpeg", "gif" (default "png"),
    size: int, one of 16, 32, 64, 128, 256, 512, 1024, 2048, 4096 (default 256),
    dynamic: bool, if true the format will automatically change to gif 
    for animated avatars (default false)
}
```

Example 3 (GDScript):
```GDScript
var avatar_url = message.author.get_display_avatar_url()
var embed = Embed.new().set_image(avatar_url)
bot.send(message, {"embeds": [embed]})
```

Example 4 (GDScript):
```GDScript
{
    format: String, one of "webp", "png", "jpg", "jpeg", "gif" (default "png"),
    size: int, one of 16, 32, 64, 128, 256, 512, 1024, 2048, 4096 (default 256),
    dynamic: bool, if true the format will automatically change to gif for animated avatars (default false)
}
```

---

## MessageActionRow¶

**URL:** https://3ddelano.github.io/discord.gd/classes/messageactionrow/

**Contents:**
- MessageActionRow¶
- Description¶
- Properties¶
- Methods¶
- Method Descriptions¶
  - add_component(component)¶
    - Examples¶
  - slice_components(index, delete_count, replace_components?)¶
  - print()¶

Provides methods for adding and removing message compoenents from an action row.

Adds a component to the action row.

Returns: MessageActionRow

The MessageActionRow can have a maximum of 5 components.

The MessageActionRow cannot contain another MessageActionRow.

Create and send a MessageButton

Removes, replaces, and inserts components in the action row.

Returns: MessageActionRow

Prints the MessageActionRow

Use this instead of print(MessageActionRow)

**Examples:**

Example 1 (unknown):
```unknown
Represents an action row containing message components.
```

Example 2 (GDScript):
```GDScript
var button = MessageButton.new().set_style(MessageButton.STYLES.DEFAULT)\
                .set_label("A")\
                .set_custom_id("primary_custom")

var row = MessageActionRow.new().add_component(button)

yield(bot.send(message, {
    "components": [row]
}))
```

---

## Helpers¶

**URL:** https://3ddelano.github.io/discord.gd/classes/helpers/

**Contents:**
- Helpers¶
- Description¶
- Static Methods¶
- Method Descriptions¶
  - is_num(value)¶
    - Examples¶
  - is_str(value)¶
    - Examples¶
  - is_valid_str(value)¶
    - Examples¶

General purpose functions which Discord.gd makes use of.

Whether a given variable is an integer or a float.

Returns true if a given variable is a String

Returns true if a given variable is a String and has length of 1 or more characters

Returns a ISO8601 timestamp from the current or specified datetime Dictionary

Pretty prints a Dictionary

This is the same as doing print(JSON.print(to_print, "\t"))

Saves a Dictionary as a JSON file to the user:// directory. This helps viewing large dictionaries which result in outpul overflow when printing.

user:// directory is located at %appdata%/Godot/app_userdata/PROJECT_NAME_HERE/

Converts the raw bytes of a PNG image to a Image

Converts an Image to a ImageTexture

Returns: ImageTexture

**Examples:**

Example 1 (unknown):
```unknown
General purpose functions
```

Example 2 (GDScript):
```GDScript
print(Helpers.is_num(15)) # Prints true

print(Helpers.is_num(15.5)) # Prints true

print(Helpers.is_num("15")) # Prints false
```

Example 3 (GDScript):
```GDScript
print(Helpers.is_num(15)) # Prints false

print(Helpers.is_num("")) # Prints true

print(Helpers.is_num("15")) # Prints true
```

Example 4 (GDScript):
```GDScript
print(Helpers.is_valid_str("15")) # Prints true

print(Helpers.is_valid_str("")) # Prints false
```

---
