# Discord-Gd-Docs - Interactions

**Pages:** 1

---

## DiscordInteraction¶

**URL:** https://3ddelano.github.io/discord.gd/classes/discordinteraction/

**Contents:**
- DiscordInteraction¶
- Description¶
- Properties¶
- Methods¶
- Method Descriptions¶
  - is_message_component()¶
  - is_button()¶
  - is_select_menu()¶
  - is_command()¶
  - is_autocomplete()¶

Provides methods for replying, updating and follow up to interactions.

Indicates whether this interaction is a message component.

Indicates whether this interaction is a button interaction.

Indicates whether this interaction is a select menu interaction.

Indicates whether this interaction is an application command interaction.

Indicates whether this interaction is an application command autocomplete interaction.

Responds to an autocomplete interaction with suggested choices.

Returns: bool Returns true if successful otherwise false.

See Discord responding to autocomplete

Always respond with two choices

Indicates whether this interaction is received from a guild.

Fetches the initial reply to this interaction.

Creates a reply to this interaction.

Here the options means the message options. Like embeds, components, content, files, etc. The two new keys are fetch_reply and ephemeral.

If fetch_reply is true, the function will return a Promsise<Message> otherwise the function will return true.

Edits the initial reply to this interaction.

options is same as DiscordInteraction.reply() options.

Deletes the initial reply to this interaction.

Defers the reply to this interaction.

options is same as DiscordInteraction.reply() options.

Defer to send an ephemeral reply later

Updates the original message of the component on which the interaction was received on.

options is same as DiscordInteraction.reply() options.

Remove the components from the message

Send a follow-up message to this interaction.

options is same as DiscordInteraction.reply() options.

Edits a follow-up message to this interaction.

options is same as DiscordInteraction.reply() options.

Deletes a follow-up message to this interaction.

Delete a sent follow up

**Examples:**

Example 1 (unknown):
```unknown
Represents a Discord interaction.
```

Example 2 (GDScript):
```GDScript
# In DiscordBot.interaction_create
if interaction.is_autocomplete():
var data = interaction.data
print("Autocomplete data: ", data)

# In a real situation you would send different choices based on the current input of the user,
# which can be found in interaction.data
interaction.respond_autocomplete([
    ApplicationCommand.choice("Name of the choice 1", "value1"),
    ApplicationCommand.choice("Name of the choice 2", "value2"),
])
return
```

Example 3 (GDScript):
```GDScript
{
    fetch_reply: bool, whether to return the new reply or not,
    ephemeral: bool, whether the reply should be ephemeral or not,
    files: Array, the files to attach to the new reply,
    embeds: Array, the embeds to attach to the new reply,
    content: String, the content of the new reply,
    components: Array, the components to attach to the new reply
}
```

Example 4 (GDScript):
```GDScript
yield(interaction.defer_reply({"ephemeral": true}), "completed")
```

---
