# Decision Rules Reference

IF-THEN rules for all discovery and sales scenarios.

## Stage Transition Rules

### Discovery Scheduled → Discovery Complete
```
IF discovery call completed
AND 38Q all 5 sections addressed
AND red flags documented
AND follow-up questions identified
    → Move to Discovery Complete
    → Score against Practice Gym Rubric 3
    → Log meeting summary to HubSpot

IF discovery call no-show
AND 2+ reschedule attempts
    → Flag as stalled
    → /create-followup with 3 time slots
```

### Discovery Complete → Rate Creation
```
IF volume reality section scored ≥4/5
AND competitive landscape captured
AND decision-maker authority confirmed
    → Request rate creation
    → Send data request if PLD needed
    → Update stage

IF volume reality score ≤2/5
OR cannot quantify addressable volume
    → Qualify OUT or dig deeper before proceeding
    → Do NOT proceed to rate creation
```

### Rate Creation → Proposal Sent
```
IF rate card approved internally
AND volume run rates calculated (annual, daily, %)
AND customer verbally commits ("At this price, I'm committing to X")
    → Document commitment in email
    → Build proposal deck
    → Move to Proposal Sent

IF no verbal commitment
    → Do NOT proceed
    → Address objections first
```

### Proposal Sent → Setup Docs
```
IF test framework agreed (30-50% volume, 2 weeks)
AND success criteria defined
AND verbal confirmation received
    → Send pre-implementation alignment email
    → Move to Setup Docs

IF "start small and ramp" without defined timeline
    → RED FLAG: Get specific milestones first
    → Define: "If Week 1-2 meets X, ramp to Y in Week 3"
```

### Setup Docs → Implementation
```
IF kickoff call scheduled
AND sales added to all implementation emails
AND pre-implementation email sent
    → Move to Implementation
    → Monitor first 3-5 days for operations focus
```

### Implementation → Closed Won
```
IF Week 1-2 test performance meets criteria
AND no contradictions in implementation
AND customer confirms satisfaction
AND ramp to committed volume begins
    → Move to Closed Won
    → Schedule 30-day check-in
    → Set up monthly business reviews

IF performance good BUT customer not ramping
    → Use Post-Test Objection Responses
    → Offer additional support
    → If still no ramp → escalate
```

### Any Stage → Closed Lost
```
IF explicit rejection received
OR 30+ days no response after full cadence
OR unqualified (cannot meet volume/service requirements)
    → Move to Closed Lost
    → Document loss reason
    → Create 90-day win-back task
```

## Email Response Rules

### No Response Handling
```
IF no response after 3 days
    → Send 2-sentence soft check-in
    → "How are things looking? Would you have time to connect?"

IF no response after 7 days
    → Send unprompted value-add analysis
    → Attach something useful they didn't ask for

IF no response after 10 days
    → Send 3 specific time slots + booking link
    → Clear call to action

IF no response after 14 days
    → Decision point
    → Option A: Push (final attempt + breakup warning)
    → Option B: Pause (move to nurture)
    → Option C: Escalate (find different contact)
```

### Response Pattern Selection
```
IF easy confirmation needed
    → "Can you confirm [X] is accurate?"
    → Yes/no question format

IF meeting needed
    → 3 specific times + Calendly link
    → Never ask "what works for you?"

IF waiting on deliverable
    → "I'll have [X] after [specific event]"
    → Shows internal progress

IF re-engagement after silence
    → Lead with value (analysis, news, insight)
    → Do NOT lead with "checking in"
```

## White Glove Jump-In Rules

### Contradiction Detection
```
IF customer or ops team contradicts sales agreement
    → IMMEDIATE jump-in
    → "Let me jump in here to level-set..."
    → Restate exact agreement
    → Confirm alignment before proceeding
```

### Volume Bait & Switch
```
IF customer proposes starting below agreed test volume
    → "Hold on, let's make sure we're aligned"
    → Reference documented commitment
    → Ask: "What's changed?"
    → Address root concern
```

### Indefinite Delay Tactics
```
IF customer says "we'll start small and ramp" without timeline
    → Identify root concern:
        - Operational bandwidth? → Offer support
        - Confidence? → Reference performance data
        - Budget? → Discuss phased approach
    → ALWAYS get specific milestones in writing
```

### Red Flag Escalation
```
IF customer avoiding volume commitment discussions
OR significant gap between agreement and actual
OR "let's wait and see" without milestones
OR new stakeholders with different expectations
    → Document red flag
    → Escalate to manager
    → Consider qualifying out
```

## Practice Gym Integration

### Post-Call Scoring
```
AFTER every discovery call:
    1. Score 38Q Section 1 (Volume Reality): ±10% variance = 5/5
    2. Score 38Q Section 2 (Carrier Setup): Full landscape = 5/5
    3. Score 38Q Section 3 (Service Requirements): All needs captured = 5/5
    4. Score 38Q Section 4 (Operational Fit): Tech stack + team = 5/5
    5. Score 38Q Section 5 (Decision & Commitment): Authority + timeline = 5/5
    6. Document all red flags with mitigation strategies
    7. Identify missed sections for follow-up questions
```

### Weekly Practice Selection
```
IF messy situation occurred this week
    → Convert to 20-min practice drill
    → Score against relevant rubric
    → Request stronger version

IF artifact produced (proposal, analysis, discovery notes)
    → Self-score against rubric
    → Compare with Claude evaluation
    → Focus next week on lowest dimension

IF discovery call completed
    → Score 38Q sections
    → Identify missed sections
    → Plan follow-up questions
```

## Win-Back Rules

### 90-Day Win-Back Trigger
```
IF deal closed lost 90+ days ago
AND company still in business
AND no active deal exists
    → Research company changes (news, hiring, leadership)
    → Draft re-engagement email
    → Reference original relationship
    → Offer new insight or value
    → Create follow-up tasks
```

### Win-Back Approach Selection
```
IF lost to competitor
    → Wait for pain (6+ months)
    → Lead with competitive intel

IF lost to "not right now"
    → Check for trigger events (new funding, leadership change, expansion)
    → Lead with relevant news

IF lost to internal decision
    → Monitor for changes (new ops director, carrier complaints)
    → Lead with "things have changed" angle
```
