# 38 Questions Framework

Complete discovery methodology across 5 sections. Score each section after every call.

## Section 1: Volume Reality (Q1-Q9)

**Purpose**: Understand true addressable volume, not claimed volume.

**Scoring**: ±10% variance confidence = 5/5

| # | Question | Why It Matters | Red Flag |
|---|----------|----------------|----------|
| Q1 | What's your total annual parcel volume? | Baseline sizing | Can't answer within 20% |
| Q2 | What volume is committed to other carriers via contract? | Reduces addressable | Vague "most of it" |
| Q3 | What volume do you NOT control (marketplace, 3PL lock-in)? | Further reduces addressable | "We ship a lot" without detail |
| Q4 | What service levels can we NOT meet (same-day, white glove)? | Service exclusions | Unclear requirements |
| Q5 | What's your weight/dimensional profile? | Pricing implications | No data available |
| Q6 | What % of volume is realistically addressable? | Truth check | Over 80% without justification |
| Q7 | What's your volume trajectory (growing, flat, declining)? | Future state | Declining without strategy |
| Q8 | What's your peak vs off-peak seasonality? | Capacity planning | No peak data |
| Q9 | What volume exclusions should we document? | Clarity | Resistance to documenting |

**CVM's Volume Reality Check (4 Questions)**:
1. What commitments do you have to other carriers?
2. What volume do you NOT control?
3. What service requirements can we NOT meet?
4. What's your realistic addressable %?

**Section 1 Red Flags**:
- Cannot quantify volume within 20%
- "We ship a lot" without specifics
- Over-claiming addressable % (>80% is suspicious)
- Resistance to documenting exclusions

---

## Section 2: Carrier Setup (Q10-Q16)

**Purpose**: Understand current carrier mix and switching motivation.

**Scoring**: Full competitive landscape captured = 5/5

| # | Question | Why It Matters | Red Flag |
|---|----------|----------------|----------|
| Q10 | Who are your current carriers and % mix? | Competitive landscape | Only knows primary |
| Q11 | What are your annual carrier costs? | Savings potential | "I don't have visibility" |
| Q12 | How is cost visibility by carrier/service? | Decision-making capability | No cost breakdown |
| Q13 | What are your biggest carrier pain points? | Urgency drivers | "Everything's fine" |
| Q14 | What are your contract terms (length, penalties)? | Switching barriers | Locked in 2+ years |
| Q15 | What penalties exist for switching? | True cost of change | Hidden penalties |
| Q16 | Have you switched carriers before? How did it go? | Change management experience | Bad past experience |

**GRI 2026 Extensions**:
- Q14a: When does your contract expire?
- Q14b: Are you aware of the January GRI announcements?
- Q14c: What's your exposure to residential surcharges?

**Section 2 Red Flags**:
- "Everything's fine" with no pain points
- Contract locked for 2+ years with penalties
- Bad previous switching experience
- No cost visibility

---

## Section 3: Service Requirements (Q17-Q24)

**Purpose**: Understand SLA needs and special handling.

**Scoring**: All requirements captured with specificity = 5/5

| # | Question | Why It Matters | Red Flag |
|---|----------|----------------|----------|
| Q17 | What geographic coverage do you need? | Network fit | International-heavy |
| Q18 | What transit time targets by service level? | SLA requirements | Unrealistic expectations |
| Q19 | How did carriers perform during last peak? | Performance proof | Won't share data |
| Q20 | What peak season challenges did you face? | Pain identification | "Peak was fine" |
| Q21 | What special handling needs exist? | Operational complexity | Undisclosed requirements |
| Q22 | What signature/delivery confirmation requirements? | Service level needs | Enterprise-only features |
| Q23 | What returns volume and process? | Full service scope | High returns volume |
| Q24 | What claims/damage experience with current carriers? | Performance comparison | High claims rate |

**Section 3 Red Flags**:
- Unrealistic transit expectations
- "Peak was fine" when industry struggled
- Undisclosed special handling requirements
- High claims/returns rate

---

## Section 4: Operational Fit (Q25-Q32)

**Purpose**: Understand tech stack, team, and integration capability.

**Scoring**: Full operational picture captured = 5/5

| # | Question | Why It Matters | Red Flag |
|---|----------|----------------|----------|
| Q25 | What WMS/shipping software do you use? | Integration complexity | Custom/legacy systems |
| Q26 | What are your cutoff times for same-day ship? | Operational alignment | Misaligned cutoffs |
| Q27 | Who is your operations team (names, roles)? | Stakeholder mapping | Unclear ownership |
| Q28 | What's your IT capability for integrations? | Technical readiness | No IT resources |
| Q29 | What's your warehouse layout (single/multi)? | Fulfillment complexity | Multiple locations |
| Q30 | Who handles carrier relationships today? | Decision authority | Fragmented ownership |
| Q31 | What's your label printing setup? | Technical details | Incompatible printers |
| Q32 | What reporting/visibility do you need? | Ongoing requirements | Enterprise-level needs |

**Section 4 Red Flags**:
- Custom/legacy systems with no IT support
- Multiple warehouse locations with different processes
- Fragmented carrier relationship ownership
- IT team not involved in discovery

---

## Section 5: Decision & Commitment (Q33-Q38)

**Purpose**: Understand buying process and commitment readiness.

**Scoring**: Full buying committee identified + timeline locked = 5/5

| # | Question | Why It Matters | Red Flag |
|---|----------|----------------|----------|
| Q33 | Who makes the final carrier decision? | Authority identification | "Committee decides" |
| Q34 | Who else needs to be involved in evaluation? | Stakeholder mapping | Unknown influencers |
| Q35 | What's your timeline for making a decision? | Urgency assessment | "No rush" |
| Q36 | What would make you say yes today? | Buying criteria | Can't articulate |
| Q37 | What obstacles could prevent this from happening? | Risk identification | Unclear blockers |
| Q38 | Are you ready to commit to [X] volume at [Y] price? | Commitment check | Hesitation |

**Section 5 Red Flags**:
- "Committee decides" without named individuals
- "No rush" on timeline
- Can't articulate buying criteria
- Hesitation on volume commitment

---

## Post-Call Scoring Template

After every discovery call, complete this assessment:

```
## Discovery Call Scoring - [COMPANY] - [DATE]

### Section Scores (1-5)
- Section 1 (Volume Reality): _/5
- Section 2 (Carrier Setup): _/5
- Section 3 (Service Requirements): _/5
- Section 4 (Operational Fit): _/5
- Section 5 (Decision & Commitment): _/5
- **TOTAL**: _/25

### Red Flags Identified
1. [Flag] - Mitigation: [Strategy]
2. [Flag] - Mitigation: [Strategy]

### Sections Needing Follow-Up
- Section _: Need to clarify [questions]
- Section _: Missing [information]

### Next Actions
1. [Action] - Owner: [YOU/AI] - Due: [Date]
2. [Action] - Owner: [YOU/AI] - Due: [Date]

### Deal Viability Assessment
- [ ] Proceed to rate creation
- [ ] Need more discovery
- [ ] Qualify out
```

---

## GRI 2026 Question Extensions

Use during December-January campaign for urgency.

**Contract Timing**:
- "When does your current carrier contract expire?"
- "Are you locked into minimum commitments?"
- "What penalties exist for switching mid-contract?"

**GRI Awareness**:
- "Are you aware of the January rate increases?"
- "Have you calculated the real impact on your costs?"
- "5.9% headline but 7-12% effective - does that match your experience?"

**Urgency Creation**:
- "What would it take to make a decision before January 21?"
- "If we could lock rates before GRI, would that change your timeline?"
- "What's the cost of waiting until after GRI takes effect?"
