# Stage Playbook Reference

Stage-by-stage actions, success criteria, and critical checkpoints.

---

## Stage 01: Discovery Scheduled

**Objective**: Book and prepare for discovery call

### Pre-Call Checklist
- [ ] Brand Scout research complete
- [ ] Company shipping page scraped
- [ ] Decision-makers identified
- [ ] LinkedIn research on key contacts
- [ ] 38 Questions template ready
- [ ] Calendar confirmed with all parties

### YOU vs AI Split
| Task | YOU | AI | Tool |
|------|-----|-----|------|
| Schedule call | Approve time | Draft invite | Calendar |
| Pre-call research | Review/approve | Execute | `/brand-scout:scout` |
| Prepare 38Q notes | Review | Draft template | Template |

### Success Criteria
- Call scheduled within 7 days of first contact
- Brand Scout research complete
- All decision-makers invited

### Time: 30-45 min

---

## Stage 02: Discovery Complete

**Objective**: Conduct 38Q discovery and qualify opportunity

### Discovery Call Checklist
- [ ] All 5 sections of 38Q addressed
- [ ] Volume reality quantified (±10%)
- [ ] Competitive landscape captured
- [ ] Pain points documented
- [ ] Decision-maker authority confirmed
- [ ] Timeline established
- [ ] Red flags identified

### YOU vs AI Split
| Task | YOU | AI | Tool |
|------|-----|-----|------|
| Conduct call | Execute | — | Fathom |
| Log summary | Review/edit | Draft | `/meeting-summary` |
| Score 38Q | Review | Calculate | Rubric 3 |
| Update stage | Approve | Execute | `/update-deal` |
| Identify next action | Decide | Suggest | `/next-action` |

### Post-Call Scoring (Rubric 3)
- Section 1 (Volume): _/5
- Section 2 (Carrier): _/5
- Section 3 (Service): _/5
- Section 4 (Operations): _/5
- Section 5 (Decision): _/5

### Success Criteria
- All sections scored ≥3/5
- Red flags documented with mitigation
- Clear next steps defined

### Time: 45-60 min

---

## Stage 03: Rate Creation

**Objective**: Lock volume commitment and request rate card

### CVM White Glove Actions
1. Calculate volume run rates:
   - Annual volume
   - Daily run rate (annual ÷ shipping days)
   - % of addressable volume
2. Document verbal commitment:
   - "At this price, I'm committing to X packages/day"
3. Confirm expectations in writing

### YOU vs AI Split
| Task | YOU | AI | Tool |
|------|-----|-----|------|
| Review discovery notes | Execute | — | — |
| Request rate creation | Submit | Draft request | Template |
| Gather shipping data | Request | Draft email | `/create-followup` |
| Analyze profile | Review | Run analysis | `analysis_skill.md` |
| Update stage | Approve | Execute | `/update-deal` |

### Critical Checkpoint
**DO NOT proceed without documented volume commitment.**

Send confirmation email:
```
Per our conversation, here's what we agreed:
- Test volume: [X] packages/day for 2 weeks
- Full commitment: [Y] packages/day post-test
- Service level: [Xparcel Ground/Expedited/Priority]

Please confirm this aligns with your expectations.
```

### Success Criteria
- Rate card approved internally
- Volume commitment documented in writing
- Customer confirms alignment

### Time: 30-45 min

---

## Stage 04: Proposal Sent

**Objective**: Present proposal and manage follow-up cadence

### Proposal Building Checklist
- [ ] Rate card included
- [ ] Savings analysis (multiple scenarios)
- [ ] "Why we might not win" section
- [ ] Test-to-ramp framework documented
- [ ] Next steps with timeline

### Follow-Up Cadence (AI drafts, YOU send)

| Day | Action | Template |
|-----|--------|----------|
| 0 | Present proposal (live preferred) | Delivery + next steps |
| 3 | 2-sentence soft check-in | "How are things looking?" |
| 7 | Unprompted value-add analysis | Send useful insight |
| 10 | 3 specific times + booking link | Meeting request |
| 14 | Decision point | Push/pause/escalate |

### YOU vs AI Split
| Task | YOU | AI | Tool |
|------|-----|-----|------|
| Review rates | Execute | — | — |
| Build deck | Customize | Draft | Template |
| Send proposal | Execute | Draft email | `/create-followup` |
| Log activity | Trigger | Execute | `/log-activity` |
| Follow-up sequence | Send | Draft all | Swipe files |

### Success Criteria
- Proposal presented (live meeting preferred)
- Test framework agreed (30-50%, 2 weeks)
- Success criteria defined

### Time: 45-60 min + cadence

---

## Stage 05: Setup Docs Sent

**Objective**: Pre-implementation alignment and kickoff scheduling

### Pre-Implementation Checklist
- [ ] Test volume confirmed in writing
- [ ] Success criteria documented
- [ ] Ramp timeline defined
- [ ] Implementation team introduced
- [ ] Kickoff call scheduled
- [ ] Sales added to all implementation emails

### Pre-Implementation Email Template
```
Subject: [COMPANY] - Pre-Implementation Alignment

Confirming our agreement before kickoff:

TEST PERIOD (Weeks 1-2):
- Volume: [X] packages/day
- Success Criteria: Transit performance, billing accuracy, operational smoothness

POST-TEST RAMP (Week 3+):
- Target Volume: [Y] packages/day
- Ramp Timing: Immediate upon meeting success criteria

[Implementation Lead] will reach out shortly to schedule kickoff.
I'll remain involved throughout implementation to ensure alignment.

Please confirm this matches your expectations.
```

### YOU vs AI Split
| Task | YOU | AI | Tool |
|------|-----|-----|------|
| Confirm agreement | Review | Draft email | Template |
| Schedule kickoff | Coordinate | Draft invite | Calendar |
| Add to impl emails | Execute | — | Email |
| Update stage | Approve | Execute | `/update-deal` |

### Success Criteria
- Written confirmation of test framework
- Kickoff scheduled
- Sales cc'd on all implementation emails

### Time: 30 min

---

## Stage 06: Implementation

**Objective**: White Glove execution - ensure deal doesn't "slide into ditch"

### Week 1-2: Test Period

**Daily Monitoring**:
- [ ] On every implementation call
- [ ] Monitoring pickup confirmations
- [ ] Checking volume vs test commitment
- [ ] Watching for contradictions

**Jump-In Triggers**:
1. **Contradiction Alert**: "Let me jump in here to level-set..."
2. **Volume Bait & Switch**: "Hold on, we agreed to [X]. What's changed?"
3. **Delay Tactics**: Address root concern + offer support

**Success Indicators**:
- Pickup confirmations with timestamps + BOL numbers
- Volume tracking aligned with test expectations
- No contradictions in discussions
- Questions are operational ("how") not strategic ("whether")

**Red Flags**:
- Customer avoiding volume discussions
- Gap between agreement and actual
- "Let's wait and see" without milestones
- New stakeholders with different expectations

### Week 3+: Post-Test Ramp

**If Performance Met Criteria**:
```
Congratulations on a successful test! Here's what we saw:
- [Transit performance metrics]
- [Billing accuracy]
- [Operational smoothness]

Per our agreement, let's discuss ramping to [Y] packages/day.
What does your timeline look like for full transition?
```

**If NOT Ramping (Objection Handling)**:

| Objection | Response |
|-----------|----------|
| "We're too busy" | "What support would help? We can provide [X]." |
| "Extend test" | "Let's review data together. What specific thresholds would give you confidence?" |
| "Volume not available" | "What changed from our original discussion? Let's revisit addressable volume." |
| "Wait for peak" | "Let's establish baseline now so we're ready for peak." |

### YOU vs AI Split
| Task | YOU | AI | Tool |
|------|-----|-----|------|
| Attend impl calls | Execute | — | — |
| Monitor volume | Review | Track | Dashboard |
| Jump-in on issues | Execute | Draft response | Templates |
| Post-test ramp | Lead | Draft email | Template |
| Update stage | Approve | Execute | `/update-deal` |

### Success Criteria
- Test performance meets criteria
- Ramp to full volume begins
- No unresolved contradictions

### Time: Ongoing (calls + monitoring)

---

## Stage 07: Closed Won

**Objective**: Continuous White Glove - revenue realization

### 30-Day Check-In
- [ ] Volume tracking vs commitment
- [ ] Transit performance review
- [ ] Billing accuracy confirmation
- [ ] Issue resolution status
- [ ] Expansion opportunity identification

### Monthly Business Reviews
- Transit time trends
- On-time %, cost savings
- Volume vs commitment
- Issue resolution
- Expansion opportunities

### Quarterly Volume Audits
- Compare actual vs committed
- Identify volume leakage
- Renegotiate if needed
- Present expansion opportunities

### Proactive Questions
- "What other carriers are you using?"
- "What volume are we not handling?"
- "Where aren't we meeting expectations?"

### Success Metrics
- Volume variance <15% at 90 days
- No unresolved issues
- Expansion opportunities identified

---

## Stage 08: Closed Lost

**Objective**: Document, learn, and set up win-back

### Loss Documentation
- [ ] Reason captured (competitor, timing, price, other)
- [ ] Learning documented
- [ ] Deal folder updated
- [ ] 90-day win-back task created

### Win-Back Setup
1. Create task for 90 days out
2. Note company news triggers to watch
3. Document relationship contacts

### Time: 10-15 min

---

## Stage 09: Win-Back (90+ Days)

**Objective**: Re-engage closed lost deals

### Pre-Outreach Research
- [ ] Company changes (news, hiring, leadership)
- [ ] Carrier complaints (social media, reviews)
- [ ] Trigger events (funding, expansion, new facilities)

### Win-Back Approach by Loss Reason

| Loss Reason | Wait Time | Lead With |
|-------------|-----------|-----------|
| Competitor | 6+ months | Competitive intel, their pain |
| Timing | Trigger event | "Circumstances changed" |
| Price | GRI announcement | Cost increase angle |
| Internal | Leadership change | Fresh start |

### YOU vs AI Split
| Task | YOU | AI | Tool |
|------|-----|-----|------|
| Review loss reason | Execute | — | Deal folder |
| Research changes | Review | Execute | Web search |
| Draft re-engagement | Personalize | Draft | Swipe files |
| Send win-back | Execute | — | Superhuman |
| Update stage | Approve | Execute | `/update-deal` |

### Time: 20-30 min
