# Email Templates Reference

Proven email patterns organized by stage and purpose.

## Golden Rules (Apply to ALL Emails)

| Do This | Not This |
|---------|----------|
| Specific time slots | "When are you free?" |
| "I need X to complete Y" | "Just checking in" |
| 2 sentences | 2 paragraphs |
| Post-meeting recap + action | Assume they remember |
| Easy yes/no question | Open-ended asks |
| "Can you confirm..." | Vague asks |

## Response Triggers (Why Emails Get Replies)

1. **Easy to respond** - Yes/no, pick a time, confirm a fact
2. **Shows progress** - "I'll have X after meeting at Y"
3. **Adds value** - Analysis, insight, resource they didn't ask for
4. **Specific not vague** - Dates, times, numbers, percentages

---

## Stage 02: Discovery Scheduling

### Initial Outreach (Post-Brand Scout)
```
Subject: Quick question about [COMPANY]'s shipping mix

[FIRST NAME],

Noticed [COMPANY] is shipping [VOLUME INDICATOR] through [CURRENT SETUP].
Quick question: what % of that volume do you actually control vs. locked into other commitments?

Happy to share what we're seeing work for similar [INDUSTRY] brands.

Brett Walker
FirstMile
```

### Meeting Request (3 Times + Link)
```
Subject: 15 min to discuss [COMPANY]'s shipping options

[FIRST NAME],

Would you be available for a quick call to discuss [SPECIFIC TOPIC]?

Any of these work:
- [Day 1] at [Time 1] [TZ]
- [Day 2] at [Time 2] [TZ]
- [Day 3] at [Time 3] [TZ]

Or grab a time here: [Calendly link]

Brett
```

---

## Stage 03: Post-Discovery Follow-Up

### Meeting Recap + Next Steps
```
Subject: [COMPANY] - Discovery Recap + Next Steps

[FIRST NAME],

Thanks for the conversation today. Quick recap:

WHAT WE DISCUSSED:
- [Volume]: [X] packages/day, [Y]% addressable
- [Pain point]: [Specific issue mentioned]
- [Timeline]: Looking to make decision by [Date]

NEXT STEPS:
1. I'll send over rate options by [Date]
2. You'll confirm [Data/info needed]
3. We'll reconnect [Day] to review

Does this align with your understanding?

Brett
```

### Data Request
```
Subject: Quick data request for [COMPANY] rate analysis

[FIRST NAME],

To build accurate rates, I need:
- Last 90 days shipping data (origin, destination, weight, service)
- Current rate card (if available)

Is this something you can share, or should I connect with [Ops contact]?

Brett
```

---

## Stage 04: Proposal Follow-Up Cadence

### Day 0: Proposal Delivery
```
Subject: [COMPANY] - Proposal + Savings Analysis

[FIRST NAME],

Attached is your customized proposal showing:
- [X]% savings on [service level]
- [Transit improvement] to [key destinations]
- [Specific benefit from discovery]

I'll follow up with [remaining analysis/comparison] by [Date].

What does [Day] look like to walk through this together?

Brett
```

### Day 3: Soft Check-In
```
Subject: Re: [COMPANY] Proposal

[FIRST NAME],

How are things looking as you review the proposal?
Would you have time to connect in the next few days?

Brett
```

### Day 7: Unprompted Value-Add
```
Subject: [COMPANY] - Zone analysis you might find useful

[FIRST NAME],

Following up on the proposal - pulled together a zone distribution analysis I thought you'd find useful:

[Key finding 1]
[Key finding 2]

This shows [insight related to their pain point].

Worth 15 minutes to walk through?

Brett
```

### Day 10: Meeting Request with Urgency
```
Subject: [COMPANY] - Quick sync before [event/deadline]

[FIRST NAME],

Wanted to connect before [GRI/contract renewal/peak] to finalize next steps.

Available any of these?
- [Time 1]
- [Time 2]
- [Time 3]

Or grab a slot: [Calendly]

Brett
```

### Day 14: Decision Point
```
Subject: [COMPANY] - Where should we go from here?

[FIRST NAME],

I want to respect your time, so I'll be direct:

Is moving forward with FirstMile still a priority, or has something changed on your end?

Either way, happy to help - just want to calibrate my follow-up.

Brett
```

---

## Stage 05: Pre-Implementation Alignment

### Volume Confirmation Email
```
Subject: [COMPANY] - Pre-Implementation Alignment

[FIRST NAME],

Before we kick off implementation, confirming our agreement:

TEST PERIOD (Weeks 1-2):
- Volume: [X] packages/day
- Success Criteria: Transit times, billing accuracy, operational smoothness

POST-TEST RAMP (Week 3+):
- Target Volume: [Y] packages/day
- Ramp Timing: Immediate upon meeting success criteria

[Implementation Lead] will contact you shortly to schedule kickoff.
I'll remain involved throughout to ensure alignment.

Please confirm this matches your expectations.

Brett
```

---

## Stage 06: Implementation

### Level-Setting on Contradictions
```
Subject: Re: [COMPANY] Implementation - Quick Alignment

[FIRST NAME],

Want to make sure we're aligned on what we discussed during sales:

ORIGINAL AGREEMENT:
- Test volume: [X] packages/day
- Ramp to: [Y] packages/day after successful test
- Timeline: [Specific dates]

I heard [contradiction] mentioned on the last call.
Can we hop on quickly to confirm we're all on the same page?

Brett
```

### Post-Test Performance Review
```
Subject: [COMPANY] - Test Results + Ramp Discussion

[FIRST NAME],

Great news on the test performance:

WEEK 1-2 RESULTS:
- Transit: [X]% on-time (target: [Y]%)
- Billing: [Accuracy %]
- Operations: [Summary]

Per our agreement, this triggers the ramp to [Y] packages/day.

What does next week look like to discuss transition timeline?

Brett
```

---

## Stage 08-09: Win-Back

### 90-Day Re-Engagement
```
Subject: [COMPANY] - Things have changed

[FIRST NAME],

It's been a few months since we last connected.

Wanted to reach out because [trigger event - new GRI, industry news, company change].

Curious if [specific pain point from original discovery] is still a challenge, or if things have improved with [current carrier].

Worth a quick catch-up?

Brett
```

### Competitive Win-Back
```
Subject: Hearing some [COMPETITOR] frustrations in the market

[FIRST NAME],

Been hearing from a few brands about [specific competitor issue].

Didn't know if that matched your experience, but figured I'd check in.

If things have been smooth, no worries - just wanted to stay connected.

Brett
```

---

## December Pipeline Priming

### Email 1: Volume Reality Hook (Immediately after Brand Scout)
```
Subject: Quick question about [COMPANY]'s shipping mix

[FIRST NAME],

Noticed [COMPANY] ships [VOLUME INDICATOR] from [LOCATION].

Quick question: What % of that volume do you actually control vs. locked into carrier commitments?

Asking because we just helped a similar [INDUSTRY] brand realize they were only getting rates on 40% of their volume.

Happy to share what we're seeing if helpful.

Brett
```

### Email 2: Peak Season Check-In (Dec 23-27)
```
Subject: How'd [CARRIER] hold up?

[FIRST NAME],

Not trying to pitch while you're catching your breath post-peak.

Just curious - how did [CARRIER] perform when it mattered?

We track transit performance across the network and happy to share what we saw if interesting.

Brett
```

### Email 3: GRI Primer (Jan 6-10)
```
Subject: January 21 is coming

[FIRST NAME],

UPS GRI hits January 21. 5.9% headline, but with surcharge stacking we're seeing 7-12% effective increases.

Given your volume, that's roughly [$ ESTIMATE] annual impact.

Worth 15 minutes to run the math together?

Brett
```

---

## January Follow-Ups

### Follow-Up 1: GRI Dropped (Jan 21)
```
Subject: [CARRIER] just got 7-12% more expensive

[FIRST NAME],

GRI hit today. Here's what it means for [COMPANY]:

BEFORE: [Estimated current costs]
AFTER: [Estimated new costs]
IMPACT: [$ Increase] annually

We can still lock pre-GRI rates for a limited time.

15 minutes this week?

Brett
```

### Follow-Up 2: Math Offer (Jan 23-24)
```
Subject: Ran the numbers for [COMPANY]

[FIRST NAME],

Put together a quick analysis of GRI impact on your shipping profile:

[3 key data points]

Full breakdown attached - no obligation, just thought you'd want to see it.

Worth discussing?

Brett
```

### Follow-Up 3: LinkedIn Reference (When they engage with post)
```
Subject: Saw you liked the post on [TOPIC]

[FIRST NAME],

Noticed you engaged with my post on [TOPIC].

Happy to dig deeper on that for [COMPANY] specifically.

What's your calendar look like?

Brett
```

### Follow-Up 4: Breakup (Jan 28-31)
```
Subject: Should I close the loop?

[FIRST NAME],

I've reached out a few times but haven't heard back.

Totally understand if timing isn't right.

Should I:
A) Check back in Q2
B) Connect you with someone else on our team
C) Close this out for now

Either way, no hard feelings.

Brett
```
