# YOU vs AI Mapping Reference

Task delegation framework for every stage transition. AI drafts, YOU decide timing and personal touches.

## Core Principle

**"AI drafts, you decide timing and personal touches."**

AI handles: Research, drafts, templates, analysis, logging, updates
YOU handle: Judgment calls, relationship moments, sending, approving

## Decision Framework

For any task >1 hour:
1. List all micro-tasks
2. Mark each as M (Manual) or AI
3. For AI tasks, specify tool/command
4. Estimate time saved
5. Execute in order

**If unsure M or AI:**
- Requires judgment? → M
- Requires your relationship? → M
- Repetitive/templated? → AI
- Creativity within constraints? → AI

---

## [01] New Lead → Discovery Scheduled

| Task | YOU | AI | Tool | Time |
|------|-----|-----|------|------|
| Identify target company | Decide | Suggest | Brand Scout triggers | 2 min |
| Run Brand Scout research | Review/approve | Execute full research | `/brand-scout:scout` | 15 min |
| Draft outreach email | Review/personalize | Draft from template | Email 1 template | 5 min |
| Send outreach | Execute | — | Superhuman | 1 min |
| Follow-up sequence | Send each | Draft all | Templates | 10 min |
| Schedule call | Approve time | Draft invite text | Calendar | 3 min |
| Pre-call prep | Review | Compile from Brand Scout | Template | 5 min |

**Total Time**: 40-45 min
**AI Time Saved**: ~25 min

---

## [01] → [02] Discovery Scheduled → Discovery Complete

| Task | YOU | AI | Tool | Time |
|------|-----|-----|------|------|
| Confirm call details | Quick check | — | Calendar | 1 min |
| Prepare 38Q template | Review | Pre-fill from Brand Scout | Template | 5 min |
| Conduct discovery call | Execute full call | — | Fathom recording | 30-45 min |
| Log meeting summary | Review/edit | Draft from notes | `/meeting-summary` | 10 min |
| Score 38Q sections | Review scores | Calculate from notes | Rubric 3 | 5 min |
| Identify red flags | Confirm | Suggest from patterns | Analysis | 3 min |
| Update deal stage | Approve | Execute | `/update-deal` | 1 min |
| Identify next action | Decide | Suggest options | `/next-action` | 2 min |

**Total Time**: 45-60 min
**AI Time Saved**: ~20 min

---

## [02] → [03] Discovery Complete → Rate Creation

| Task | YOU | AI | Tool | Time |
|------|-----|-----|------|------|
| Review discovery notes | Execute | — | — | 5 min |
| Determine qualification | Decide | Provide analysis | 38Q scores | 3 min |
| Request rate creation | Submit to ops | Draft request | Template | 5 min |
| Request shipping data | Review/send | Draft email | `/create-followup` | 3 min |
| Analyze shipping profile | Review findings | Run analysis | `analysis_skill.md` | 15 min |
| Document volume commitment | Confirm numbers | Draft email | Template | 5 min |
| Update deal stage | Approve | Execute | `/update-deal` | 1 min |

**Total Time**: 30-45 min
**AI Time Saved**: ~25 min

---

## [03] → [04] Rate Creation → Proposal Sent

| Task | YOU | AI | Tool | Time |
|------|-----|-----|------|------|
| Review rate card | Execute | — | — | 10 min |
| Build proposal deck | Customize key slides | Draft full deck | Template | 20 min |
| Calculate savings scenarios | Review | Run calculations | Analysis | 10 min |
| Draft proposal email | Review/personalize | Draft | `/create-followup` | 5 min |
| Send proposal | Execute | — | Superhuman | 2 min |
| Log activity | Trigger | Execute | `/log-activity` | 1 min |
| Set follow-up reminders | Approve | Create all tasks | HubSpot tasks | 3 min |
| Update deal stage | Approve | Execute | `/update-deal` | 1 min |

**Total Time**: 45-60 min
**AI Time Saved**: ~30 min

---

## [04] Proposal Follow-Up Cadence

| Day | Task | YOU | AI | Tool |
|-----|------|-----|-----|------|
| 0 | Present proposal | Execute meeting | — | Zoom |
| 3 | Soft check-in | Send | Draft 2-sentence | Template |
| 7 | Value-add analysis | Review/send | Draft + create analysis | Template |
| 10 | Meeting request | Send | Draft 3-times | Template |
| 14 | Decision point | Decide next action | Draft breakup | Template |

**Pattern**: AI drafts all follow-ups, YOU decide timing and send

---

## [04] → [05] Proposal → Setup Docs

| Task | YOU | AI | Tool | Time |
|------|-----|-----|------|------|
| Get verbal commitment | Execute conversation | — | Call | 10 min |
| Document test framework | Confirm numbers | Draft alignment email | Template | 10 min |
| Send pre-implementation email | Review/send | Draft | Template | 5 min |
| Schedule kickoff call | Coordinate | Draft invite | Calendar | 5 min |
| Add self to impl emails | Execute | — | Email | 1 min |
| Update deal stage | Approve | Execute | `/update-deal` | 1 min |

**Total Time**: 30 min
**AI Time Saved**: ~15 min

---

## [05] → [06] Setup Docs → Implementation

| Task | YOU | AI | Tool | Time |
|------|-----|-----|------|------|
| Attend kickoff call | Execute | — | Call | 30 min |
| Monitor all impl emails | Review | — | Email | Ongoing |
| Track volume vs commitment | Review dashboard | Create tracking | Spreadsheet | 5 min/day |
| Jump-in on contradictions | Execute immediately | Draft response | Template | As needed |
| Daily impl check | Quick review | Summarize status | Dashboard | 5 min |

**Total Time**: Variable (ongoing during 2-week test)
**Critical**: YOU must be on every call, monitoring every email

---

## [06] → [07] Implementation → Closed Won

| Task | YOU | AI | Tool | Time |
|------|-----|-----|------|------|
| Review test performance | Execute | Compile metrics | Dashboard | 15 min |
| Send performance recap | Review/send | Draft email | Template | 5 min |
| Negotiate ramp timeline | Lead conversation | Draft talking points | Notes | 15 min |
| Handle objections | Lead | Provide responses | Objection bank | As needed |
| Confirm go-live | Execute | — | Call | 10 min |
| Send welcome email | Review/send | Draft | Template | 5 min |
| Create 30-day check-in task | Approve | Create | HubSpot | 1 min |
| Update deal stage | Approve | Execute | `/update-deal` | 1 min |

**Total Time**: 45-60 min
**AI Time Saved**: ~20 min

---

## [07] Closed Won - Ongoing

| Task | Frequency | YOU | AI | Tool |
|------|-----------|-----|-----|------|
| Volume tracking | Weekly | Review | Compile | Dashboard |
| Monthly business review | Monthly | Lead meeting | Prep slides | Template |
| Quarterly volume audit | Quarterly | Lead discussion | Run analysis | Analysis |
| Expansion identification | Ongoing | Decide | Suggest opps | Research |
| Issue resolution | As needed | Lead | Document | HubSpot |

---

## [Any] → [08] Closed Lost

| Task | YOU | AI | Tool | Time |
|------|-----|-----|------|------|
| Receive/confirm loss | Acknowledge | — | — | 2 min |
| Document loss reason | Provide details | Format notes | `/log-activity` | 5 min |
| Update deal stage | Approve | Execute | `/update-deal` | 1 min |
| Create 90-day win-back task | Approve | Create | HubSpot | 2 min |

**Total Time**: 10-15 min
**AI Time Saved**: ~5 min

---

## [08] → [09] Closed Lost → Win-Back

| Task | YOU | AI | Tool | Time |
|------|-----|-----|------|------|
| Review loss reason | Execute | — | Deal folder | 3 min |
| Research company changes | Review | Execute search | Web search | 10 min |
| Identify trigger events | Decide relevance | Find news | News search | 5 min |
| Draft re-engagement | Review/personalize | Draft email | Swipe files | 5 min |
| Send win-back email | Execute | — | Superhuman | 2 min |
| Create follow-up tasks | Approve | Create | HubSpot | 2 min |
| Update deal stage | Approve | Execute | `/update-deal` | 1 min |

**Total Time**: 20-30 min
**AI Time Saved**: ~15 min

---

## Summary: YOU vs AI by Activity Type

### YOU Always Does
- Send external communications
- Lead live calls/meetings
- Make judgment calls
- Relationship moments
- Final approval on anything customer-facing
- Jump-in on contradictions
- Decide push/pause/escalate

### AI Always Does
- Research and data gathering
- Draft all emails
- Create analysis/reports
- Log activities to HubSpot
- Execute stage updates (after approval)
- Create follow-up tasks
- Compile meeting prep
- Calculate metrics

### Time Savings by Stage

| Stage | Total Time | AI Saved | AI % |
|-------|------------|----------|------|
| [01] Lead → Scheduled | 45 min | 25 min | 56% |
| [02] Discovery Complete | 60 min | 20 min | 33% |
| [03] Rate Creation | 40 min | 25 min | 63% |
| [04] Proposal + Cadence | 60 min | 30 min | 50% |
| [05] Setup Docs | 30 min | 15 min | 50% |
| [07] Closed Won | 55 min | 20 min | 36% |
| [08] Closed Lost | 15 min | 5 min | 33% |
| [09] Win-Back | 30 min | 15 min | 50% |
