# Known Failures Reference

Documented failures with prevention patterns. Check this BEFORE key actions.

---

## F001: Volume Commitment Not Documented in Writing

**Date Discovered**: 2025-12-16

**What Happened**:
Customer verbally agreed to 5,000 packages/day during rate discussion. No email confirmation sent. During implementation, customer claimed "we never agreed to that" and started at 1,000/day.

**Why It's Wrong**:
Verbal commitments evaporate. Without written confirmation, there's no leverage to enforce ramp.

**Symptoms**:
- Customer disputes agreed volume during implementation
- "We said we'd start small and see"
- No email trail to reference

**Prevention**:
```
AFTER every verbal commitment:
1. Send confirmation email SAME DAY
2. Include exact numbers (packages/day, not %)
3. Include test framework and ramp timeline
4. End with "Please confirm this aligns with your expectations"
5. Do NOT proceed until written confirmation received
```

**Template**:
```
Per our conversation, here's what we agreed:
- Test volume: [X] packages/day for 2 weeks
- Full commitment: [Y] packages/day post-test
- Success criteria: [Specific metrics]

Please confirm alignment.
```

---

## F002: Sales Not on Implementation Calls

**Date Discovered**: 2025-12-16

**What Happened**:
Handed off to ops team after contract signed. Ops made different promises during implementation. Customer confused about commitments. Sales found out 3 weeks later when deal had "slid into ditch."

**Why It's Wrong**:
Implementation weeks 2-4 are where revenue dies. Without sales presence, contradictions go unchallenged and commitments get renegotiated down.

**Symptoms**:
- Finding out about problems after they've festered
- Customer has different understanding than sales agreement
- Ops team making commitments sales didn't authorize
- Volume tracking significantly below agreement

**Prevention**:
```
BEFORE implementation begins:
1. Add self to ALL implementation emails (cc or to)
2. Block calendar for ALL implementation calls
3. Tell customer: "I'll be on every call to ensure alignment"
4. Tell ops team: "Flag any pushback to me immediately"

DURING implementation:
1. Attend every call (no exceptions)
2. Monitor every email
3. Jump in IMMEDIATELY on any contradiction
4. Track volume daily vs commitment
```

**Jump-In Script**:
```
"Let me jump in here to level-set. When we discussed this during sales,
we agreed to [X]. I want to make sure we're all aligned before we proceed.
[CUSTOMER], does this match your understanding?"
```

---

## F003: Vague "Start Small and Ramp" Without Timeline

**Date Discovered**: 2025-12-16

**What Happened**:
Customer said "let's start with 500/day and see how it goes." No specific ramp milestones defined. 6 months later still at 500/day with no path to committed volume.

**Why It's Wrong**:
"See how it goes" is an indefinite delay tactic. Without defined milestones, there's no accountability and no leverage.

**Symptoms**:
- Indefinite test period
- Customer comfortable at low volume
- No urgency to ramp
- "Things are going great, but..."

**Prevention**:
```
WHEN customer proposes "start small and ramp":
1. Ask: "What would you need to see to ramp?"
2. Define specific milestones (transit %, billing accuracy, etc.)
3. Define specific timeline (Week 3-4 decision point)
4. Document in writing: "IF Week 1-2 meets [criteria], THEN ramp to [volume] in Week 3"
5. Get written confirmation

IF customer resists specific milestones:
- Probe for root concern (confidence? bandwidth? budget?)
- Address root concern directly
- Offer support/resources
- If still no milestones → qualify out or adjust expectations
```

---

## F004: Missing Red Flags During Discovery

**Date Discovered**: 2025-12-16

**What Happened**:
Customer couldn't answer Q1-Q4 (volume reality). Couldn't quantify addressable volume, didn't know carrier commitments, unclear on service requirements. Proceeded anyway because "seemed like a good opportunity." Deal stalled at rate creation - customer couldn't commit because they genuinely didn't know their numbers.

**Why It's Wrong**:
Red flags in Section 1 (Volume Reality) are disqualifiers. If they can't answer basic volume questions, they can't make volume commitments.

**Symptoms**:
- "We ship a lot" without specifics
- "Let me get back to you on that" for basic questions
- Multiple stakeholders with conflicting answers
- Stalled at rate creation because can't commit

**Prevention**:
```
AFTER every discovery call:
1. Score all 5 sections of 38Q (1-5 each)
2. Flag any section scored ≤2/5
3. If Section 1 (Volume Reality) ≤2/5:
   → Do NOT proceed to rate creation
   → Either: get answers OR qualify out
4. Document red flags with specific mitigation strategies
5. Identify follow-up questions for weak sections
```

**Section 1 Minimum Standards**:
- Can quantify total volume within 20%
- Knows what volume is committed elsewhere
- Can identify addressable %
- Has authority to commit volume

---

## F005: Not Challenging "Everything's Fine"

**Date Discovered**: 2025-12-16

**What Happened**:
Customer said current carrier "works fine" and they're "just exploring options." No specific pain points identified. Proposal sent anyway. Ghosted after proposal.

**Why It's Wrong**:
No pain = no urgency = no deal. "Just exploring" means no compelling reason to change.

**Symptoms**:
- "Current carrier is fine"
- "Just seeing what's out there"
- Can't articulate specific pain points
- Ghosted after proposal

**Prevention**:
```
WHEN customer says "everything's fine":
1. Probe deeper: "What would need to change for you to consider switching?"
2. Look for hidden pain: peak performance, claims, billing accuracy, support
3. Use GRI intelligence: "With 7-12% increases coming, is 'fine' still fine?"
4. Ask about exceptions: "When has it NOT been fine?"

IF no pain emerges:
- Consider qualifying out
- Or nurture until trigger event
- Do NOT send proposal to "just exploring" prospects
```

---

## F006: Proposal Without Live Presentation

**Date Discovered**: 2025-12-16

**What Happened**:
Sent proposal via email without scheduling live presentation. Customer reviewed alone, had questions/objections that weren't addressed, decided to stay with current carrier.

**Why It's Wrong**:
Proposals sent alone get rejected alone. Live presentation allows objection handling in real-time.

**Symptoms**:
- "We reviewed and decided to stay put"
- Customer had concerns never voiced
- No opportunity to address objections
- "The numbers didn't quite work"

**Prevention**:
```
BEFORE sending proposal:
1. Schedule live presentation meeting
2. Never just email proposal and wait
3. If customer insists on email-only:
   → Send with clear next steps
   → Include "I'll call you [DAY] to walk through"
   → Book follow-up before sending
```

---

## F007: Not Tracking Volume During Implementation

**Date Discovered**: 2025-12-16

**What Happened**:
Test started at agreed 500/day. No one tracked actual volume. Week 2 review revealed average of 150/day. Customer said "we're ramping up" but no accountability.

**Why It's Wrong**:
What gets measured gets managed. Without daily tracking, volume gaps go unaddressed until it's too late.

**Symptoms**:
- Surprised by volume gap at end of test
- "We're ramping up" without evidence
- No data to hold customer accountable
- Test "successful" but at 30% of agreed volume

**Prevention**:
```
DURING implementation:
1. Get pickup confirmations with BOL numbers daily
2. Track volume vs commitment in spreadsheet
3. Flag gaps >10% immediately (don't wait for end of test)
4. Address gaps in real-time: "We're seeing 200/day vs 500 agreed"
5. Document daily in HubSpot for evidence
```

---

## Pre-Action Checklists

### Before Rate Creation
- [ ] All 38Q sections scored ≥3/5? (F004)
- [ ] Volume reality quantified within 20%? (F004)
- [ ] Specific pain points identified? (F005)
- [ ] Decision-maker authority confirmed? (F004)

### Before Proposal
- [ ] Live presentation scheduled? (F006)
- [ ] Volume commitment documented in writing? (F001)
- [ ] Test framework agreed with specific milestones? (F003)

### Before Implementation
- [ ] Added to all impl emails? (F002)
- [ ] Blocked for all impl calls? (F002)
- [ ] Volume tracking set up? (F007)
- [ ] Pre-implementation alignment email sent? (F001)

### During Implementation
- [ ] On every call? (F002)
- [ ] Tracking volume daily? (F007)
- [ ] Flagging gaps >10%? (F007)
- [ ] Jumping in on contradictions? (F002)

---

## Adding New Failures

When a new failure is discovered:

1. Add entry here with date, description, prevention
2. Update expertise.yaml learned_behaviors.failures
3. Increment expertise.yaml version (patch level)
4. Add to relevant pre-action checklist
5. Consider if new decision rule needed in 00-decision-rules.md
