---
name: do-workflow-jit-docs
description: 사용자 의도와 프로젝트 컨텍스트를 기반으로 관련 문서를 지능적으로 발견, 로드, 캐싱하는 Just-In-Time 문서 로딩 시스템
version: 3.0.0
category: workflow
allowed-tools: Read, Grep, Glob, WebFetch, WebSearch
user-invocable: true
---

## 빠른 참조

목적: 사용자 의도와 컨텍스트에 기반해 관련 문서를 온디맨드 로드

핵심 도구:
- WebSearch: 최신 문서 및 리소스 온라인 검색
- WebFetch: 특정 문서 페이지 직접 조회
- Context7 MCP: 공식 라이브러리 문서 접근 (가용시)
- Read, Grep, Glob: 로컬 프로젝트 문서 탐색

트리거 조건:
- 사용자가 특정 기술 질문을 할 때
- 대화에서 기술 키워드 감지
- 작업 완료에 도메인 전문성 필요
- 구현 가이드 요청

---

## 의도 감지

### 질문 기반 트리거

사용자의 질문 유형에 따라 문서 로딩 활성화:
- 구현 질문: "JWT 인증을 어떻게 구현하나요?"
- 모범 사례 질문: "API 설계의 베스트 프랙티스는?"
- 트러블슈팅 질문: "쿼리가 느린 이유가 뭘까요?"

### 기술별 트리거

프레임워크: FastAPI, React, Vue, Django, Flask, Next.js
언어: Python, TypeScript, JavaScript, Go, Rust
데이터베이스: PostgreSQL, MongoDB, Redis, MySQL
인프라: Docker, Kubernetes, Terraform, AWS

### 도메인별 트리거

인증/보안: authentication, authorization, encryption, JWT, OAuth
성능 최적화: optimization, caching, scaling, performance
데이터베이스: queries, migrations, indexing, normalization
API 설계: endpoints, REST, GraphQL, versioning

### 패턴 기반 트리거

구현 요청: "implement", "create", "build", "develop"
아키텍처 논의: "design", "structure", "pattern", "architecture"
문제 해결: "debug", "fix", "error", "not working", "slow"

---

## 문서 소스 우선순위

첫째, 로컬 프로젝트 문서 (최고 우선순위):
- .do/docs/: 프로젝트별 문서
- .do/specs/: 요구사항 및 명세
- README.md, docs/: 종합 문서

둘째, 공식 문서 소스:
- WebFetch로 공식 프레임워크 문서 조회
- Context7 MCP 도구로 라이브러리 문서 접근

셋째, 커뮤니티 리소스:
- WebSearch로 고품질 튜토리얼 검색
- Stack Overflow 높은 투표수 솔루션

넷째, 실시간 웹 연구:
- 현재 연도로 WebSearch 실행해 최신 정보 획득
- 새 기능 및 폐기 예정 공지 확인

---

## 로딩 전략

### 의도 분석 프로세스

- 사용자 요청에서 언급된 기술 식별
- 질문과 관련된 도메인 영역 결정
- 질문 유형 분류 (구현, 트러블슈팅, 개념)
- 복잡도 평가로 필요한 문서 깊이 판단

### 소스 우선순위 결정

- 로컬 문서 존재시: 프로젝트별 문서 우선 로드
- 공식 문서 가용시: 권위 있는 소스 조회
- 구현 예제 필요시: 커뮤니티 리소스 검색
- 최신 정보 필요시: 웹 연구 수행

### 컨텍스트 인식 캐싱

- 세션 내 검색된 문서 캐시
- 현재 대화 컨텍스트 기반 관련성 유지
- 컨텍스트 전환시 오래된 콘텐츠 제거
- 자주 액세스되는 문서 우선순위 지정

---

## 품질 평가

### 콘텐츠 품질 기준

권위성 (30%): 공식 소스가 최고 신뢰도
최신성 (25%): 빠른 변화 기술은 12개월 이내 콘텐츠 선호
완전성 (25%): 예제가 포함된 문서 높은 순위
관련성 (20%): 콘텐츠와 사용자 의도 간 일치도

### 품질 점수 임계값

0.8 이상: 높은 신뢰도, 바로 활용 가능
0.6에서 0.8: 참고용, 추가 검증 권장
0.6 미만: 추가 검증 필수, 다른 소스 탐색 권장

---

## 실제 워크플로우

### 인증 구현

상황: 사용자가 인증 관련 질문
- 기술 감지: FastAPI, JWT 등 기술 스택 파악
- 도메인 식별: 인증, 보안 영역 인식
- FastAPI 보안 문서 WebFetch로 로드
- JWT 모범 사례 WebSearch로 검색
- 소스 귀속과 함께 종합 가이드 제공

### 데이터베이스 최적화

상황: 사용자가 쿼리 성능 질문
- 데이터베이스 기술 감지: PostgreSQL, MySQL 등
- 공식 데이터베이스 문서 로드
- 최적화 가이드 및 튜토리얼 검색
- 소스와 함께 실행 가능한 권장사항 제공

### 신기술 도입

상황: 사용자가 새 기술 도입 검토
- 기술명 감지: GraphQL, Kubernetes 등
- 공식 시작 가이드 문서 로드
- 마이그레이션 가이드 검색 (해당시)
- 전략적 도입 가이드 제공

---

## 의도 분석 상세

### 질문 유형 분류

implementation (구현): 무언가를 만들거나 구현하는 방법
- 키워드: "how to", "implement", "create", "build"

troubleshooting (문제 해결): 이슈 해결 방법
- 키워드: "error", "not working", "slow", "problem"

conceptual (개념): 개념 이해
- 키워드: "what is", "explain", "difference between"

best_practices (모범 사례): 권장 접근법
- 키워드: "best way", "recommended", "pattern"

comparison (비교): 옵션 평가
- 키워드: "compare", "vs", "which is better"

### 긴급도 판단

high (높음): 프로덕션 이슈, 에러 발생
- 키워드: "error", "broken", "production", "urgent"

normal (보통): 일반적인 개발 질문
- 키워드: "how to", "want to", "looking for"

low (낮음): 학습 목적, 호기심
- 키워드: "curious", "later", "someday"

---

## 캐싱 시스템

### 캐시 레벨

session (세션): 현재 세션에서만 유효, 종료시 자동 삭제
project (프로젝트): 프로젝트별 지속 캐시, 7일간 유효
global (전역): 프로젝트 간 공유, 권위 높은 소스 장기 보관

### 캐시 조회 순서

첫째, 세션 캐시에서 키 존재 및 관련성 검증
둘째, 프로젝트 캐시에서 7일 이내 생성 여부 검증
셋째, 전역 캐시에서 권위 높은 소스인지 검증
넷째, 캐시 미스시 새로 문서 로드 후 적절한 레벨에 저장

---

## 오류 처리

### 네트워크 오류

웹 검색 실패시: 캐시된 콘텐츠로 폴백, 제한사항 알림
WebFetch 실패시: 로컬 문서 활용, 부분 결과 표시

### 콘텐츠 품질 이슈

검색 결과가 오래됨: 더 최신 소스 추가 검색, 날짜 명확히 표시
관련성 불확실: 사용자에게 명확화 요청
정보 충돌 발견: 여러 소스를 날짜와 함께 제시

### 관련성 불일치

초기 검색 결과 불량시: 검색 쿼리 정제, 다른 키워드로 재검색
사용자 컨텍스트 불명확시: 로딩 전 명확화 요청

---

## 성능 최적화

### 효율적 로딩

지연 로딩: 명시적 필요시에만 문서 로드
선제 로딩 지양: 모든 가능한 문서 미리 로드하지 않음
타겟 검색: 광범위 쿼리 대신 구체적 검색어 사용

### 배치 처리

관련 검색 결합: 가능한 경우 연관 검색 통합
기술별 그룹화: 동일 기술 문서 요청 묶어 처리
병렬 처리: 독립적 소스는 동시에 검색

### 성능 목표

캐시 히트율: 70% 이상
평균 로드 시간: 2초 이내
관련성/품질 점수 임계값: 0.6-0.7 이상

---

## 고급 패턴

### 다중 소스 집계

공식 문서와 커뮤니티 예제 결합
여러 권위 있는 소스 교차 참조
다양한 자료에서 종합 답변 도출

### 컨텍스트 지속성

대화 초반에 로드한 문서 기억
같은 문서 중복 로딩 방지
세션 통해 누적 지식 구축

### 선제적 로딩

대화 흐름 기반 문서 필요 예측
복잡한 기능 논의시 관련 주제 미리 로드
사용자 질문 전 관련 문서 제안

---

## 피해야 할 패턴

### 모든 문서 미리 로딩

문제: 세션 시작시 가능한 모든 문서 로드
해결: 의도 분석 후 필요한 문서만 JIT 로딩

### 품질 검증 생략

문제: 검증 없이 모든 검색 결과 동등 취급
해결: 품질 평가 후 임계값 이상만 사용

### 캐시 무효화 무시

문제: 오래된 캐시 문서 계속 사용
해결: TTL 및 관련성 기반 캐시 관리

### 단일 소스 의존

문제: 하나의 소스에만 의존
해결: 다중 소스 집계, 교차 검증

---

## 연관 리소스

에이전트: workflow-docs, core-planner, workflow-spec
스킬: do-docs-generation, do-library-nextra, do-foundation-context
커맨드: /do:3-sync, /do:9-feedback

---

## 설정

### 로컬 문서 경로

프로젝트별 문서: .do/docs/
요구사항 명세: .do/specs/
프로젝트 정보: README.md
변경 이력: CHANGELOG.md
종합 문서: docs/

### 캐시 설정

캐시 유지 기간: 30일 (공식 문서), 7일 (커뮤니티)
관련성 임계값: 0.7 이상만 캐시
자동 정리: 활성화 권장

### 검색 최적화

WebSearch에 현재 연도 포함해 최신 결과 우선
특정 도메인 필터 site: 사용 가능
정확한 구문 필요시 따옴표 활용
너무 넓은 쿼리 지양, 구체적 검색어 사용

---

Version: 3.0.0
Last Updated: 2025-12-06
