---
name: doc-review
description: ドキュメントレビューを実施するためのスキル。提案書、設計書、PRD、技術仕様書などのドキュメントをレビューする際に使用します。「ドキュメントをレビュー」「提案書をチェック」「設計書を確認」「この文書をレビューして」「ドキュメントの品質を確認」などのドキュメントレビュータスクに言及した場合にトリガーします。ビジネス・戦略観点、論理構造、技術的妥当性、リスク管理、表現の正確性を多角的に評価し、建設的な改善提案を行います。
---

# ドキュメントレビュー

提案書、設計書、PRD、技術仕様書などのドキュメントを、ビジネス・戦略観点、論理構造、技術的妥当性、リスク管理、表現の正確性の観点から包括的にレビューします。

## レビュー優先順位

### 🔴 CRITICAL（修正必須）

- **戦略的整合性**: ビジネス目標との不整合、経営方針との矛盾
- **論理的欠陥**: MECE違反、根拠なき結論、重大な論理飛躍
- **実現可能性**: 予算・期間・技術的に明らかに不可能な内容
- **リスク**: 最悪のシナリオが未検討、重大なリスク見落とし

### 🟡 IMPORTANT（要検討）

- **目標設定**: SMART基準の不足、KPIの曖昧さ
- **トレードオフ**: 代替案や選択理由が不明確
- **情報不足**: 5W1Hの欠落、読み手によって解釈が分かれる曖昧さ
- **技術的懸念**: スケーラビリティ、保守性、単一障害点

### 🟢 SUGGESTION（推奨事項）

- **構成改善**: ストーリーライン、結論ファーストの徹底
- **表現改善**: 専門用語の説明不足、冗長な記述
- **補足情報**: あると説得力が増す追加データや事例
- **形式**: フォーマット、図表の追加提案

## レビューワークフロー

### 1. コンテキスト確認

レビュー開始前に以下を確認：

1. ドキュメントの種類（提案書、設計書、PRD等）を特定
2. 読み手（意思決定者、エンジニア、クライアント等）を把握
3. ドキュメントの目的・背景を理解

### 2. 観点別レビュー

以下の観点で順にチェック：

1. **戦略・ビジネス**: 目的整合性、価値提案、ROI
2. **論理構造**: MECE、ピラミッドストラクチャ、So What?/Why So?
3. **目標設定**: SMART基準、KPI、成功の定義
4. **技術的妥当性**: 実装可能性、スケーラビリティ、トレードオフ
5. **リスク管理**: 最悪シナリオ、緩和策、撤退基準
6. **表現・品質**: 曖昧さの排除、5W1H、読みやすさ

各観点の詳細なチェック項目は [references/checklist.md](references/checklist.md) を参照。

### 3. コメント作成

レビューコメントは優先度とカテゴリを明示し、問題の説明・影響・改善案を含める。

## 基本原則とフレームワーク

### MECE（Mutually Exclusive, Collectively Exhaustive）

- 課題分析や解決策に重要な要素の抜け漏れ・重複がないか
- 真にインパクトのあるイシューにフォーカスしているか

### SMART

- **Specific**: 誰が、何を、どのように行うか曖昧さはないか
- **Measurable**: 成功の定義が数値化されているか
- **Achievable**: 予算・期間・技術力に照らして現実的か
- **Relevant**: 経営目標・プロジェクト目的に合致しているか
- **Time-bound**: 完了時期・効果発現時期が明確か

### 5W1H

- **Who**: 実行者・責任者は誰か
- **What**: 何をするのか
- **When**: いつまでに行うのか
- **Where**: どこで実施するのか
- **Why**: なぜ必要なのか
- **How**: どのように行うのか

## リファレンス

- **詳細チェックリスト**: [references/checklist.md](references/checklist.md) - 観点別の確認項目
- **フレームワーク詳細**: [references/frameworks.md](references/frameworks.md) - レビューで使用するフレームワーク

## レビュー姿勢の原則

1. **共同作業として**: レビューは批判ではなく、ドキュメントを共に改善する作業
2. **心理的安全性**: 「案」に対して意見を言い、「作成者」を否定しない
3. **代替案の提示**: 問題指摘だけでなく「こうすれば良くなる」を提案
4. **エゴの排除**: 自分の好みではなく、プロジェクトの最適解を追求
5. **コンテキスト理解**: 読み手・目的を踏まえたレビューを実施
6. **建設的フィードバック**: 良い点も認め、改善を促す表現を使用
