# ドキュメントレビュー チェックリスト

## 1. 戦略・ビジネス観点

### 目的の整合性

- [ ] ドキュメントの目的が明確に定義されているか
- [ ] 経営目標・ビジネス指標との整合性があるか
- [ ] 「これによってビジネスのどの指標が動くのか」が明確か
- [ ] ステークホルダーのニーズに応えているか

### 価値提案

- [ ] 提案の価値が定量的に示されているか
- [ ] 投資対効果（ROI）が明確か
- [ ] 競合・代替案との比較が適切か

## 2. 論理構造観点

### MECE（モレなく、ダブりなく）

- [ ] 課題分析に重要な要素の抜け漏れがないか
- [ ] 解決策の提示に重複がないか
- [ ] 分類や整理が論理的か

### So What? / Why So?

- [ ] 事実の羅列ではなく、示唆・結論が導き出されているか
- [ ] 「結局、我々は何をすべきか」が明確か
- [ ] 結論に対する根拠が論理的に繋がっているか
- [ ] 論理の飛躍がないか

### ピラミッドストラクチャ

- [ ] 結論が最上位に配置されているか（結論ファースト）
- [ ] 結論を支える根拠が明確にぶら下がっているか
- [ ] SCQA（Situation, Complication, Question, Answer）の構成か

## 3. 目標設定観点（SMART）

### Specific（具体性）

- [ ] 誰が、何を、どのように行うか明確か
- [ ] 曖昧な表現がないか
- [ ] 読み手によって解釈が分かれないか

### Measurable（測定可能性）

- [ ] 成功の定義が数値化されているか
- [ ] KPIが設定されているか
- [ ] 測定方法が明確か

### Achievable（達成可能性）

- [ ] 予算に照らして現実的か
- [ ] 期間に照らして現実的か
- [ ] 技術力・リソースに照らして現実的か

### Relevant（関連性）

- [ ] 経営目標に合致しているか
- [ ] プロジェクトの本来の目的に合致しているか
- [ ] 優先度が適切か

### Time-bound（期限）

- [ ] 完了時期が明確か
- [ ] 効果発現時期が明確か
- [ ] マイルストーンが設定されているか

## 4. 技術・アーキテクチャ観点

### スケーラビリティと信頼性

- [ ] データ量・トラフィック増加時の設計考慮があるか
- [ ] 単一障害点（SPOF）がないか
- [ ] 疎結合な設計になっているか

### トレードオフの明示

- [ ] 採用した案の選択理由が明記されているか
- [ ] 捨てたメリット・受け入れたリスクが明記されているか
- [ ] 代替案との比較検討が行われているか

### 保守性

- [ ] 過剰な設計（Over-engineering）になっていないか
- [ ] シンプルで理解しやすいか
- [ ] 運用・メンテナンスが容易か
- [ ] 監視・アラートの考慮があるか

### 技術的誠実さ

- [ ] メリットだけでなく限界・欠点も記述されているか
- [ ] 技術的な不確実性が明記されているか

## 5. リスク管理観点

### リスク識別

- [ ] 主要なリスクが特定されているか
- [ ] 最悪のシナリオ（Worst Case）が想定されているか
- [ ] 外部依存リスクが考慮されているか

### リスク対応

- [ ] リスク緩和策が明確か
- [ ] 撤退基準・判断ポイントが設定されているか
- [ ] コンティンジェンシープランがあるか

## 6. 表現・品質観点

### 5W1Hの網羅性

- [ ] Who（誰が）が明確か
- [ ] What（何を）が明確か
- [ ] When（いつ）が明確か
- [ ] Where（どこで）が明確か
- [ ] Why（なぜ）が明確か
- [ ] How（どのように）が明確か

### 表現の正確性

- [ ] 専門用語に適切な説明があるか
- [ ] 曖昧な言葉（「適切に」「必要に応じて」等）を避けているか
- [ ] 数値・データの出典が明記されているか
- [ ] 図表が適切に使用されているか

### 読みやすさ

- [ ] 構成が論理的で追いやすいか
- [ ] 適切な見出し・段落分けがされているか
- [ ] 冗長な記述がないか
- [ ] 誤字脱字がないか

## レビュー観点サマリー

| カテゴリ | 核心を突く問い |
| --- | --- |
| **戦略** | 「これによってビジネスのどの指標が動くのか？」 |
| **論理** | 「根拠は十分か？論理が飛躍していないか？」 |
| **技術** | 「よりシンプルで堅牢な代替案はないか？」 |
| **リスク** | 「最悪のシナリオ（Worst Case）を想定しているか？」 |
| **品質** | 「読み手によって解釈が分かれる曖昧な言葉はないか？」 |
