# ドキュメントレビュー フレームワーク詳細

## 1. ビジネス・戦略フレームワーク（マッキンゼー流）

### MECE（Mutually Exclusive, Collectively Exhaustive）

**目的**: 課題分析や解決策の提示における論理的な構造化

**チェックポイント**:

- **構造の網羅性**: 課題分析や解決策の提示に、重要な要素の抜け漏れや重複はないか
- **選択と集中**: すべてを網羅した上で、真にインパクトのある「イシュー（課題）」にフォーカスしているか

**適用例**:
```
❌ 悪い例: 「課題は、コスト削減と業務効率化です」
   → 業務効率化はコスト削減の一部であり重複

✅ 良い例: 「課題は、人件費削減、システム費削減、外注費削減です」
   → 相互排他的で網羅的
```

### So What? / Why So?

**目的**: 事実から示唆を導き、結論の根拠を明確化

**チェックポイント**:

- **示唆の抽出**: 事実（Fact）の羅列になっていないか。「結局、我々は何をすべきか」というアクションが明確か
- **論理の裏付け**: 結論に対して、それを支える根拠（エビデンス）が論理的に繋がっているか

**適用例**:
```
❌ 悪い例: 「競合A社の売上は前年比120%です」
   → So What? が不明

✅ 良い例: 「競合A社の売上は前年比120%（新規顧客獲得が主因）。
          当社も同様のマーケティング施策を検討すべき」
   → 示唆とアクションが明確
```

### ピラミッドストラクチャ（Pyramid Principle）

**目的**: 読み手が最短で結論を把握できる構成

**構成要素**:

1. **結論（Top）**: 最も伝えたいメッセージを最上位に
2. **根拠（Middle）**: 結論を支える3つ程度の主要な理由
3. **詳細（Bottom）**: 各根拠を裏付けるデータや事例

**SCQAフレームワーク**:

- **Situation（状況）**: 現状の共有認識
- **Complication（複雑化）**: 問題や変化
- **Question（問い）**: 解決すべき課題
- **Answer（答え）**: 提案する解決策

## 2. 目標設定フレームワーク（SMART）

### 各要素の詳細

| 要素 | 定義 | 確認ポイント | 例 |
|------|------|--------------|-----|
| **Specific** | 具体的 | 誰が、何を、どのように | 「営業部門が新CRMを導入」 |
| **Measurable** | 測定可能 | 数値化されたKPI | 「顧客対応時間を30%削減」 |
| **Achievable** | 達成可能 | 現実的なリソース見積もり | 「既存予算内で実現」 |
| **Relevant** | 関連性 | 経営目標との整合 | 「顧客満足度向上に直結」 |
| **Time-bound** | 期限付き | 明確なデッドライン | 「2024年Q2までに完了」 |

### 目標記述のテンプレート

```
[誰が/どの組織が] は、[いつまでに] [何を達成するか/数値目標]。
これにより [ビジネス上のメリット/関連する経営目標] を実現する。
```

## 3. 技術・アーキテクチャフレームワーク（Google流）

### スケーラビリティと信頼性

**スケールアウトの観点**:

- データ量が10倍、100倍になっても耐えられる設計か
- ユーザー数増加時のパフォーマンス劣化を考慮しているか
- 水平スケーリングが可能な設計か

**単一障害点（SPOF）の観点**:

- システムの一部が壊れた際に、全体が停止しない設計か
- 冗長化・フェイルオーバーの仕組みがあるか
- 疎結合な設計になっているか

### トレードオフの明示

**記述すべき内容**:

1. **採用した選択肢**: A案を選択した
2. **選択理由**: コスト、期間、技術的適合性など
3. **捨てたメリット**: B案であれば得られたメリット
4. **受け入れたリスク**: A案に伴うリスクと対策

**テンプレート**:
```
## 技術選定: [選択肢名]

### 選択理由
- [理由1]
- [理由2]

### 代替案との比較
| 観点 | 採用案 | 代替案A | 代替案B |
|------|--------|---------|---------|
| コスト | ○ | △ | × |
| 期間 | ○ | ○ | △ |

### 受け入れたリスクと対策
- リスク: [内容]
  - 対策: [対策内容]
```

### 保守性

**シンプルさの原則**:

- 過剰な設計（Over-engineering）を避ける
- 3年後の自分や他人が見て理解できるか
- 「なぜこの複雑さが必要か」を説明できるか

**運用コストの考慮**:

- 構築後の監視・アラートが容易か
- メンテナンス作業の手順が明確か
- ドキュメントが整備されているか

## 4. 情報網羅性フレームワーク（5W1H）

### 各要素の詳細

| 要素 | 質問 | 確認内容 |
|------|------|----------|
| **Who** | 誰が？ | 実行者、責任者、承認者、関係者 |
| **What** | 何を？ | 成果物、アウトプット、達成目標 |
| **When** | いつ？ | 開始日、期限、マイルストーン |
| **Where** | どこで？ | 実施場所、対象範囲、環境 |
| **Why** | なぜ？ | 背景、目的、必要性の根拠 |
| **How** | どのように？ | 方法、手順、プロセス、ツール |

### 5W1Hチェックマトリクス

ドキュメントの各セクションで5W1Hが網羅されているかをチェック:

```
セクション      | Who | What | When | Where | Why | How |
----------------|-----|------|------|-------|-----|-----|
プロジェクト概要 | ✓   | ✓    | ✓    | -     | ✓   | -   |
実施計画        | ✓   | ✓    | ✓    | ✓     | -   | ✓   |
体制            | ✓   | -    | -    | -     | ✓   | -   |
```

## 5. レビューコメントテンプレート

### 基本フォーマット

```
## [🔴/🟡/🟢] [カテゴリ]: [問題の要約]

### 該当箇所
[セクション名] / [ページ番号] / [該当文章の引用]

### 問題点
[何が問題か、なぜ問題かの説明]

### 影響
[この問題が放置された場合の影響]

### 改善案
[具体的な修正案や代替案]
```

### 例

```
## 🟡 目標設定: KPIの測定方法が不明確

### 該当箇所
3.2 成功指標 / 「顧客満足度の向上を目指す」

### 問題点
「顧客満足度の向上」の測定方法・数値目標が定義されていない。
SMARTの「Measurable」を満たしていない。

### 影響
プロジェクト完了時に成功/失敗の判断ができない。
関係者間で期待値のズレが生じる可能性がある。

### 改善案
以下のように具体化を提案:
「NPS（Net Promoter Score）を現在の+20から+35に向上させる。
 測定は四半期ごとの顧客アンケートで実施。」
```
