---
name: doc-to-skill
description: Convert documentation into structured Agent Skills following progressive disclosure principles. Use when (1) Converting user documentation or guides into skills, (2) Creating skills from existing technical documentation, (3) Organizing knowledge into skill format with references, (4) Applying skill design principles to documentation, (5) Structuring information for AI agent consumption, (6) Creating skills that follow best practices for context efficiency
metadata:
  short-description: Convert documentation to Agent Skills format
---

# Documentation to Skill Converter

Transform documentation into structured Agent Skills using progressive disclosure and context-efficient design principles.

## Quick Start

**Conversion workflow:**

1. Analyze source document structure and content
2. Extract core workflows (20% that solves 80%)
3. Create SKILL.md with essential content (<500 lines)
4. Move detailed content to references/ files
5. Write comprehensive description with trigger scenarios
6. Validate and package

**Key principle:** Progressive disclosure - metadata → SKILL.md → references/ (loaded only when needed)

## Core Conversion Process

### Step 1: Analyze Source Document

**Identify structure:**

- Document length and sections
- Information hierarchy (intro → basics → advanced)
- Most frequently used content (80/20 rule)
- Detailed reference material

**Questions to answer:**

- What are the core workflows? (most common tasks)
- What's reference material? (complete command lists, detailed specs)
- What triggers this skill? (when would someone need this?)

### Step 2: Extract Core Content

**For SKILL.md (keep essential only):**

- Quick start / getting started
- Core workflows (most common tasks)
- Essential commands/operations
- Basic configuration
- Common patterns
- Troubleshooting basics
- References to detailed docs

**Extraction criteria:**

- Used in 80% of cases → SKILL.md
- Used in 20% of cases → references/
- Quick reference needed → SKILL.md
- Complete reference → references/

### Step 3: Write Frontmatter

**Description format:**

```
description: [What it does]. Use when (1) [Scenario 1], (2) [Scenario 2], (3) [Scenario 3]...
```

**Requirements:**

- Clear "what it does" statement
- Numbered list of trigger scenarios
- Include all use cases (this is the trigger mechanism)
- No colons in description field

**Example:**

```yaml
description: Comprehensive guide for using GitHub CLI (gh) to interact with GitHub from the command line. Use when (1) Managing GitHub repositories, issues, pull requests, or releases from terminal, (2) Automating GitHub workflows in scripts, (3) Creating or managing pull requests, (4) Working with GitHub issues, (5) Creating releases or managing repository operations, (6) Integrating GitHub operations into development workflows, (7) Using GitHub CLI commands in automation scripts
```

### Step 4: Structure SKILL.md

**Recommended structure:**

```markdown
# [Title]

[Brief overview - 1-2 sentences]

## Quick Start
[Most common operations - 5-10 examples]

## Core Workflows
[Organized by task category]

## Configuration
[Essential settings]

## Advanced Usage
[Optional - only if needed]

## Common Patterns
[Best practices]

## Troubleshooting
[Common issues]

## References
[Links to references/ files]
```

**Guidelines:**

- Keep under 500 lines (ideally 200-300)
- Prioritize actionable content (commands, examples)
- Use code blocks for all examples
- Reference detailed docs, don't duplicate

### Step 5: Create References

**When to create references/ files:**

- Complete command/API reference
- Detailed workflow scenarios
- Advanced patterns and examples
- Large reference material (>100 lines)

**File organization:**

- `references/commands.md` - Complete command/API reference
- `references/workflows.md` - Detailed workflow scenarios
- `references/advanced.md` - Advanced patterns (if needed)

**Reference file structure:**

```markdown
# [Title]

## [Category 1]
[Detailed content]

## [Category 2]
[Detailed content]
```

### Step 6: Link References

**In SKILL.md, add references section:**

```markdown
## References

For detailed information, see:
- [commands.md](references/commands.md) - Complete command reference
- [workflows.md](references/workflows.md) - Detailed workflow scenarios
```

## Design Principles

### 1. Progressive Disclosure

**Three-level loading:**

1. **Metadata** (name + description) - Always loaded (~100 words)
2. **SKILL.md body** - Loaded when skill triggers (<500 lines)
3. **references/** - Loaded only when needed (unlimited)

**Benefit:** Minimizes context window usage while maintaining completeness.

### 2. 80/20 Rule

- **20% of content** (most common) → SKILL.md
- **80% of content** (detailed) → references/

**Example:**

- SKILL.md: `gh pr create`, `gh pr list`, `gh pr merge` (most common)
- references/: All PR commands with all flags and options

### 3. Actionability First

**Prioritize:**

- ✅ Executable commands/code
- ✅ Real-world examples
- ✅ Common patterns
- ❌ Theoretical explanations
- ❌ Edge cases (move to references)

### 4. No Duplication

**Rule:** Information lives in ONE place only.

- SKILL.md = Quick reference, essential workflows
- references/ = Complete documentation, detailed specs

**Avoid:** Copying same content to both places.

### 5. Trigger Clarity

**Description must include:**

- What the skill does
- When to use it (numbered scenarios)
- All relevant use cases

**Why:** Description is the ONLY trigger mechanism - Codex uses it to decide when to load the skill.

## Conversion Checklist

### Pre-Conversion

- Analyzed source document structure
- Identified core workflows (80/20)
- Listed all trigger scenarios
- Planned file organization

### Frontmatter

- `name` field (lowercase, hyphenated)
- `description` with "Use when" scenarios
- `metadata.short-description`
- No colons in description
- All use cases listed

### SKILL.md

- Under 500 lines (ideally 200-300)
- Quick Start section
- Core workflows organized
- Actionable examples (code blocks)
- References section linking to references/
- No duplication with references/

### References

- Created references/ directory
- Detailed content moved to references/
- Files properly named and organized
- Linked from SKILL.md

### Validation

- Frontmatter format correct
- All references valid
- Code examples tested
- Skill packages successfully

## Common Patterns

### Pattern 1: Command-Line Tool Documentation

**Source:** CLI tool manual (e.g., `gh`, `git`, `docker`)

**Structure:**

- SKILL.md: Most common commands, basic workflows
- references/commands.md: Complete command reference with all flags
- references/workflows.md: Common usage patterns

### Pattern 2: API Documentation

**Source:** API reference documentation

**Structure:**

- SKILL.md: Quick start, common operations, authentication
- references/api.md: Complete API reference
- references/examples.md: Code examples

### Pattern 3: Framework Guide

**Source:** Framework documentation (e.g., React, Django)

**Structure:**

- SKILL.md: Core concepts, common patterns
- references/concepts.md: Detailed concepts
- references/patterns.md: Advanced patterns
- references/api.md: API reference

### Pattern 4: Workflow Documentation

**Source:** Process/workflow documentation

**Structure:**

- SKILL.md: Main workflow steps, decision points
- references/workflows.md: Detailed workflow scenarios
- references/troubleshooting.md: Common issues

## Examples

### Before (Documentation)

```
# Tool Guide (500 lines)
## Introduction (50 lines)
## Installation (100 lines)
## Basic Usage (150 lines)
## Advanced Features (200 lines)
```

### After (Skill)

```
SKILL.md (200 lines)
├── Quick Start
├── Core Workflows
├── Common Patterns
└── References → references/

references/
├── installation.md (100 lines)
├── advanced.md (200 lines)
└── complete-reference.md (150 lines)
```

## Tools and Commands

**Initialize skill:**

```bash
python init_skill.py <skill-name> --path <path> --resources references
```

**Package skill:**

```bash
python package_skill.py <path/to/skill>
```

**Validate frontmatter:**

```bash
python quick_validate.py <path/to/SKILL.md>
```

## References

For detailed conversion methodology and examples, see:

- [methodology.md](references/methodology.md) - Complete conversion methodology
- [checklist.md](references/checklist.md) - Detailed conversion checklist
- [examples.md](references/examples.md) - Real conversion examples
- [patterns.md](references/patterns.md) - Common conversion patterns

