# Documentation to Skill Conversion Checklist

Comprehensive checklist for converting documentation to Agent Skills.

## Pre-Conversion Analysis

### Document Analysis
- [ ] Read entire source document
- [ ] Identify document structure (sections, hierarchy)
- [ ] Count total lines/sections
- [ ] Identify content types (tutorial, reference, examples)
- [ ] Map dependencies between sections
- [ ] Note any external references

### Usage Pattern Analysis
- [ ] Identify most frequently used content (80/20 rule)
- [ ] List common workflows vs. edge cases
- [ ] Determine quick reference needs
- [ ] Identify deep dive requirements
- [ ] Map user journey through content

### Trigger Scenario Analysis
- [ ] List all problems this solves
- [ ] Identify all use cases
- [ ] Determine trigger contexts
- [ ] List all scenarios when skill should be used
- [ ] Verify completeness of use cases

## Skill Structure Planning

### File Organization
- [ ] Plan SKILL.md structure
- [ ] Plan references/ file organization
- [ ] Determine which content goes where
- [ ] Ensure no duplication planned
- [ ] Verify progressive disclosure structure

### Content Planning
- [ ] List core workflows for SKILL.md
- [ ] List detailed content for references/
- [ ] Identify quick start content
- [ ] Identify configuration content
- [ ] Identify troubleshooting content

## Frontmatter

### Name Field
- [ ] Skill name is lowercase
- [ ] Skill name uses hyphens (not underscores)
- [ ] Skill name is descriptive
- [ ] Skill name is under 64 characters

### Description Field
- [ ] Clear "what it does" statement
- [ ] Numbered list of trigger scenarios
- [ ] All use cases included
- [ ] No colons in description
- [ ] Comprehensive coverage
- [ ] Specific and actionable

### Metadata
- [ ] `short-description` field present
- [ ] Short description is concise
- [ ] Short description is accurate

## SKILL.md Content

### Structure
- [ ] Quick Start section present
- [ ] Core Workflows section present
- [ ] Configuration section (if applicable)
- [ ] Common Patterns section
- [ ] Troubleshooting section
- [ ] References section with links

### Content Quality
- [ ] Under 500 lines (ideally 200-300)
- [ ] All core workflows covered
- [ ] Actionable examples throughout
- [ ] Code examples are runnable
- [ ] No theoretical explanations (moved to references)
- [ ] No edge cases (moved to references)

### Code Examples
- [ ] All examples are executable
- [ ] Examples are current/up-to-date
- [ ] Examples are tested
- [ ] Examples use proper syntax
- [ ] Examples include comments where helpful

### References
- [ ] References section present
- [ ] All references/ files linked
- [ ] Links are valid
- [ ] Links use relative paths
- [ ] Each reference has description

## References Files

### File Organization
- [ ] references/ directory created
- [ ] Files properly named
- [ ] Logical file organization
- [ ] No unnecessary files

### Content Quality
- [ ] Complete coverage of topic
- [ ] All options/flags documented
- [ ] Detailed explanations
- [ ] Comprehensive examples
- [ ] Edge cases covered

### No Duplication
- [ ] Content not duplicated in SKILL.md
- [ ] Each piece of info in one place only
- [ ] References expand on SKILL.md, don't repeat

## Validation

### Format Validation
- [ ] Frontmatter YAML format correct
- [ ] No syntax errors in YAML
- [ ] Markdown syntax correct
- [ ] Code blocks properly formatted
- [ ] Links use correct syntax

### Content Validation
- [ ] SKILL.md length appropriate
- [ ] No duplication
- [ ] All core workflows covered
- [ ] References properly linked
- [ ] Examples are correct

### Functional Validation
- [ ] Code examples runnable
- [ ] Commands are correct
- [ ] Examples match current versions
- [ ] Links work
- [ ] No broken references

### Skill Packaging
- [ ] Skill packages successfully
- [ ] No validation errors
- [ ] All files included
- [ ] Structure correct

## Post-Conversion

### Testing
- [ ] Test skill triggering (description scenarios)
- [ ] Test SKILL.md content (core workflows)
- [ ] Test references/ loading (detailed content)
- [ ] Test code examples
- [ ] Test in real scenarios

### Refinement
- [ ] Identify missing content
- [ ] Identify unclear instructions
- [ ] Add missing examples
- [ ] Clarify ambiguous content
- [ ] Optimize structure if needed

### Documentation
- [ ] Skill is complete
- [ ] All use cases covered
- [ ] Examples are comprehensive
- [ ] References are complete
- [ ] Quality standards met

## Quality Checklist

### SKILL.md Quality
- [ ] Under 300 lines (excellent) or under 500 (good)
- [ ] All core workflows covered
- [ ] Actionable examples throughout
- [ ] Clear references to detailed docs
- [ ] No duplication with references/

### Description Quality
- [ ] Clear "what it does" statement
- [ ] 5+ trigger scenarios (excellent) or 3-4 (good)
- [ ] Covers all use cases
- [ ] Specific and actionable

### References Quality
- [ ] Complete coverage
- [ ] Well organized
- [ ] Detailed explanations
- [ ] Comprehensive examples

## Final Review

### Before Packaging
- [ ] All checklist items completed
- [ ] No known issues
- [ ] Quality standards met
- [ ] Ready for packaging

### After Packaging
- [ ] Package created successfully
- [ ] No validation errors
- [ ] Skill structure correct
- [ ] Ready for use

## Common Issues to Check

### Format Issues
- [ ] Frontmatter has blank line after `---`
- [ ] No colons in description field
- [ ] YAML indentation correct
- [ ] Markdown formatting correct

### Content Issues
- [ ] SKILL.md not too long
- [ ] No content duplication
- [ ] Examples are current
- [ ] Links are valid

### Structure Issues
- [ ] References properly linked
- [ ] File organization logical
- [ ] Progressive disclosure followed
- [ ] No orphaned content

## Success Criteria

A successfully converted skill should:

✅ **Trigger correctly** - Description includes all use cases
✅ **Load efficiently** - SKILL.md is concise, references/ loaded only when needed
✅ **Provide quick answers** - Core workflows in SKILL.md
✅ **Offer complete details** - References/ provide full documentation
✅ **Follow best practices** - No duplication, actionable content, proper structure

If all criteria are met, the conversion is successful!
