# Documentation to Skill Conversion Examples

Real examples of converting documentation to Agent Skills.

## Example 1: GitHub CLI Guide

### Source Document
- **Type:** CLI tool manual
- **Length:** 706 lines
- **Structure:** Installation → Auth → Commands → Workflows

### Conversion Analysis

**Core Content (for SKILL.md):**
- Quick start (auth, basic commands)
- Core workflows (repo, PR, issue, release)
- Configuration (editor, aliases)
- Common patterns
- Troubleshooting basics

**Reference Content (for references/):**
- Complete command reference (all commands, all flags)
- Detailed workflow scenarios
- Advanced automation scripts
- Complete JSON output fields

### Result

**SKILL.md:** 253 lines
- Quick Start
- Core Workflows (repo, PR, issue, release)
- Configuration
- Advanced Usage
- Common Patterns
- Troubleshooting
- References

**references/commands.md:** Complete command reference
**references/workflows.md:** Detailed workflow scenarios

### Key Decisions

1. **Moved installation to references/** - Not needed for quick reference
2. **Kept core commands in SKILL.md** - Most frequently used
3. **Moved complete flag lists to references/** - Detailed reference
4. **Kept common patterns in SKILL.md** - Frequently needed

## Example 2: API Documentation

### Source Document
- **Type:** REST API reference
- **Length:** 1200 lines
- **Structure:** Overview → Auth → Endpoints → Examples

### Conversion Strategy

**SKILL.md Structure:**
```
# API Name

## Quick Start
- Authentication
- First API call
- Common operations

## Core Endpoints
- Most used endpoints (GET, POST, PUT, DELETE)
- Request/response examples

## Authentication
- Token setup
- Auth flow

## Common Patterns
- Error handling
- Pagination
- Rate limiting

## References
- [api-reference.md](references/api-reference.md)
- [examples.md](references/examples.md)
```

**References:**
- `api-reference.md` - All endpoints with all parameters
- `examples.md` - Comprehensive code examples
- `authentication.md` - Detailed auth flows

### Key Decisions

1. **Quick start in SKILL.md** - Get users started fast
2. **Core endpoints in SKILL.md** - Most common operations
3. **Complete API reference in references/** - All endpoints, all params
4. **Examples split** - Common in SKILL.md, comprehensive in references/

## Example 3: Framework Guide

### Source Document
- **Type:** Framework documentation
- **Length:** 2000 lines
- **Structure:** Concepts → Tutorial → API → Patterns

### Conversion Strategy

**SKILL.md Structure:**
```
# Framework Name

## Quick Start
- Installation
- First project
- Core concepts

## Core Concepts
- Key concepts (simplified)
- Common patterns
- Best practices

## Common Tasks
- Most common operations
- Typical workflows

## References
- [concepts.md](references/concepts.md) - Detailed concepts
- [api.md](references/api.md) - Complete API reference
- [patterns.md](references/patterns.md) - Advanced patterns
```

**References:**
- `concepts.md` - Detailed concept explanations
- `api.md` - Complete API reference
- `patterns.md` - Advanced patterns and examples
- `tutorial.md` - Step-by-step tutorials

### Key Decisions

1. **Core concepts simplified in SKILL.md** - Quick understanding
2. **Detailed concepts in references/** - Deep dives
3. **Common tasks in SKILL.md** - Daily operations
4. **Advanced patterns in references/** - Specialized use cases

## Example 4: Workflow Documentation

### Source Document
- **Type:** Process/workflow guide
- **Length:** 800 lines
- **Structure:** Overview → Steps → Decision Points → Troubleshooting

### Conversion Strategy

**SKILL.md Structure:**
```
# Workflow Name

## Overview
- What this workflow does
- When to use it

## Main Steps
- Step 1: [Action]
- Step 2: [Decision point]
- Step 3: [Action]
- ...

## Decision Points
- If condition A → do X
- If condition B → do Y

## Common Issues
- Issue 1: Solution
- Issue 2: Solution

## References
- [detailed-workflows.md](references/detailed-workflows.md)
- [troubleshooting.md](references/troubleshooting.md)
```

**References:**
- `detailed-workflows.md` - Complete workflow scenarios
- `troubleshooting.md` - Comprehensive troubleshooting guide
- `examples.md` - Real-world examples

### Key Decisions

1. **Main steps in SKILL.md** - Core workflow
2. **Decision points in SKILL.md** - Critical decisions
3. **Detailed scenarios in references/** - All variations
4. **Common issues in SKILL.md** - Quick fixes

## Conversion Patterns

### Pattern A: Command-Line Tool

**Source:** CLI manual
**SKILL.md:** Most common commands, basic workflows
**References:** Complete command reference, all flags

**Example:** `gh`, `git`, `docker`

### Pattern B: API Documentation

**Source:** REST/GraphQL API docs
**SKILL.md:** Quick start, core endpoints, auth
**References:** Complete API reference, all parameters

**Example:** REST APIs, GraphQL APIs

### Pattern C: Framework Guide

**Source:** Framework docs
**SKILL.md:** Core concepts, common tasks
**References:** Detailed concepts, complete API, advanced patterns

**Example:** React, Django, Express

### Pattern D: Workflow Documentation

**Source:** Process/workflow guide
**SKILL.md:** Main steps, decision points
**References:** Detailed scenarios, troubleshooting

**Example:** Deployment workflows, testing workflows

## Before/After Comparisons

### Before: Monolithic Document

```
# Tool Guide (500 lines)
## Introduction (50 lines)
## Installation (100 lines)
## Basic Usage (150 lines)
## Advanced Features (200 lines)
```

**Problems:**
- Everything loaded at once
- Hard to find quick answers
- Context window inefficient

### After: Structured Skill

```
SKILL.md (200 lines)
├── Quick Start
├── Core Workflows
├── Common Patterns
└── References → references/

references/
├── installation.md (100 lines)
├── advanced.md (200 lines)
└── complete-reference.md (150 lines)
```

**Benefits:**
- Progressive disclosure
- Quick answers in SKILL.md
- Complete details in references/
- Context efficient

## Metrics

### Conversion Efficiency

**GitHub CLI Example:**
- Source: 706 lines
- SKILL.md: 253 lines (36% of source)
- References: 2 files, ~600 lines
- **Reduction:** 64% in initial load

**API Documentation Example:**
- Source: 1200 lines
- SKILL.md: 280 lines (23% of source)
- References: 3 files, ~1000 lines
- **Reduction:** 77% in initial load

### Quality Metrics

**Excellent Conversion:**
- SKILL.md: <300 lines
- Core workflows: 100% covered
- Trigger scenarios: 5+ listed
- Examples: All runnable
- Duplication: 0 instances

**Good Conversion:**
- SKILL.md: <500 lines
- Core workflows: 80%+ covered
- Trigger scenarios: 3-4 listed
- Examples: Most runnable
- Duplication: Minimal

## Lessons Learned

### What Works Well

1. **80/20 extraction** - Focus on most common content
2. **Progressive disclosure** - Load only what's needed
3. **Actionable examples** - Code over theory
4. **Clear references** - Link to detailed docs
5. **Comprehensive description** - All trigger scenarios

### Common Pitfalls

1. **Copy-paste conversion** - Don't just copy, reorganize
2. **Missing triggers** - Description must list all use cases
3. **Too much in SKILL.md** - Keep it concise
4. **Duplication** - Information in one place only
5. **Vague descriptions** - Be specific about use cases

### Best Practices

1. **Start with use cases** - List all scenarios first
2. **Test examples** - Ensure all code is runnable
3. **Iterate** - Refine based on real usage
4. **Validate** - Check format and content
5. **Document decisions** - Note why content went where

## Conclusion

Successful conversion requires:
- Understanding the source document
- Identifying core vs. reference content
- Applying progressive disclosure
- Writing comprehensive descriptions
- Testing and iterating

The goal is not to preserve document structure, but to create an efficient skill that serves AI agents and users well.
