# Documentation to Skill Conversion Patterns

Common patterns for converting different types of documentation to Agent Skills.

## Pattern Categories

### 1. Command-Line Tool Documentation

**Source Type:** CLI tool manuals (gh, git, docker, kubectl, etc.)

**Characteristics:**
- Command-based structure
- Flag/option documentation
- Usage examples
- Workflow patterns

**Conversion Strategy:**

**SKILL.md:**
- Quick start (installation, first command)
- Most common commands (top 20%)
- Basic workflows
- Common flags
- Configuration

**references/commands.md:**
- Complete command reference
- All flags and options
- All subcommands
- Parameter details

**references/workflows.md:**
- Common usage patterns
- Advanced workflows
- Automation scripts
- Integration examples

**Example Skills:**
- `github-cli` - GitHub CLI commands
- `git-workflows` - Git operations
- `docker-ops` - Docker commands

### 2. API Documentation

**Source Type:** REST/GraphQL API references

**Characteristics:**
- Endpoint-based structure
- Request/response formats
- Authentication
- Error handling

**Conversion Strategy:**

**SKILL.md:**
- Quick start (auth, first request)
- Core endpoints (most used)
- Request/response examples
- Authentication setup
- Error handling basics

**references/api-reference.md:**
- All endpoints
- All parameters
- Request/response schemas
- Status codes

**references/examples.md:**
- Comprehensive code examples
- Language-specific examples
- Real-world scenarios

**references/authentication.md:**
- Detailed auth flows
- Token management
- Security best practices

**Example Skills:**
- `github-api` - GitHub REST API
- `stripe-api` - Stripe API
- `openai-api` - OpenAI API

### 3. Framework Documentation

**Source Type:** Framework guides (React, Django, Express, etc.)

**Characteristics:**
- Concept-based structure
- Tutorial format
- API reference
- Patterns and best practices

**Conversion Strategy:**

**SKILL.md:**
- Quick start (setup, first app)
- Core concepts (simplified)
- Common tasks
- Basic patterns
- Configuration

**references/concepts.md:**
- Detailed concept explanations
- Architecture overview
- Design patterns

**references/api.md:**
- Complete API reference
- All methods/classes
- All options

**references/patterns.md:**
- Advanced patterns
- Best practices
- Anti-patterns
- Real-world examples

**Example Skills:**
- `react-development` - React framework
- `django-backend` - Django framework
- `express-api` - Express.js

### 4. Workflow Documentation

**Source Type:** Process/workflow guides

**Characteristics:**
- Step-by-step structure
- Decision points
- Conditional flows
- Troubleshooting

**Conversion Strategy:**

**SKILL.md:**
- Overview
- Main workflow steps
- Key decision points
- Common issues
- Quick troubleshooting

**references/workflows.md:**
- Detailed workflow scenarios
- All variations
- Edge cases
- Complete step-by-step

**references/troubleshooting.md:**
- Comprehensive troubleshooting
- All error scenarios
- Solutions and workarounds

**Example Skills:**
- `deployment-workflow` - Deployment processes
- `testing-workflow` - Testing processes
- `release-workflow` - Release processes

### 5. Library Documentation

**Source Type:** Library/package documentation

**Characteristics:**
- Function/method reference
- Usage examples
- Configuration options
- Integration guides

**Conversion Strategy:**

**SKILL.md:**
- Quick start (install, first use)
- Core functions (most used)
- Basic configuration
- Common patterns

**references/api.md:**
- Complete API reference
- All functions/methods
- All parameters
- Return types

**references/examples.md:**
- Comprehensive examples
- Use cases
- Integration patterns

**Example Skills:**
- `lodash-utils` - Lodash library
- `moment-dates` - Moment.js
- `axios-http` - Axios library

### 6. Configuration Documentation

**Source Type:** Configuration guides (config files, environment setup)

**Characteristics:**
- Configuration options
- Environment setup
- Best practices
- Troubleshooting

**Conversion Strategy:**

**SKILL.md:**
- Quick setup
- Essential configuration
- Common settings
- Basic troubleshooting

**references/configuration.md:**
- All configuration options
- Detailed explanations
- Advanced settings
- Environment variables

**references/troubleshooting.md:**
- Configuration issues
- Common problems
- Solutions

**Example Skills:**
- `env-config` - Environment configuration
- `docker-config` - Docker configuration
- `nginx-config` - Nginx configuration

## Pattern Selection Guide

### Choose Pattern Based On:

**Command-Line Tool Pattern:**
- ✅ Command-based structure
- ✅ Flag/option documentation
- ✅ Terminal usage

**API Documentation Pattern:**
- ✅ Endpoint-based structure
- ✅ Request/response formats
- ✅ HTTP methods

**Framework Pattern:**
- ✅ Concept-based structure
- ✅ Tutorial format
- ✅ Multiple components

**Workflow Pattern:**
- ✅ Step-by-step structure
- ✅ Decision points
- ✅ Process-oriented

**Library Pattern:**
- ✅ Function/method reference
- ✅ Package-based
- ✅ Code integration

**Configuration Pattern:**
- ✅ Settings/options structure
- ✅ Environment setup
- ✅ File-based config

## Pattern Combinations

Some documentation may require multiple patterns:

**Example: Full-Stack Framework**
- Framework Pattern (core concepts)
- API Pattern (REST endpoints)
- Configuration Pattern (settings)

**Example: CLI Tool with API**
- Command-Line Pattern (CLI commands)
- API Pattern (REST API)

**Example: Framework with Workflows**
- Framework Pattern (core concepts)
- Workflow Pattern (deployment, testing)

## Pattern-Specific Guidelines

### Command-Line Tool Pattern

**SKILL.md Focus:**
- Most common commands
- Basic workflows
- Essential flags
- Quick reference

**References Focus:**
- Complete command list
- All flags and options
- Advanced workflows
- Automation scripts

### API Documentation Pattern

**SKILL.md Focus:**
- Authentication
- Core endpoints
- Basic request/response
- Error handling

**References Focus:**
- All endpoints
- All parameters
- Complete schemas
- Comprehensive examples

### Framework Pattern

**SKILL.md Focus:**
- Quick start
- Core concepts (simplified)
- Common tasks
- Basic patterns

**References Focus:**
- Detailed concepts
- Complete API
- Advanced patterns
- Best practices

### Workflow Pattern

**SKILL.md Focus:**
- Main steps
- Key decisions
- Common issues

**References Focus:**
- Detailed scenarios
- All variations
- Comprehensive troubleshooting

## Pattern Examples

### Example 1: Command-Line Tool (GitHub CLI)

**Pattern:** Command-Line Tool
**SKILL.md:** Core commands (repo, pr, issue, release)
**References:** Complete command reference, workflows

### Example 2: API (Stripe API)

**Pattern:** API Documentation
**SKILL.md:** Auth, core endpoints (charges, customers)
**References:** All endpoints, complete reference, examples

### Example 3: Framework (React)

**Pattern:** Framework
**SKILL.md:** Quick start, core concepts, common tasks
**References:** Detailed concepts, complete API, patterns

### Example 4: Workflow (Deployment)

**Pattern:** Workflow
**SKILL.md:** Main steps, decision points
**References:** Detailed scenarios, troubleshooting

## Pattern Selection Checklist

When choosing a pattern, consider:

- [ ] Document structure (command-based, endpoint-based, etc.)
- [ ] Primary use case (CLI usage, API calls, framework development)
- [ ] Content type (commands, endpoints, concepts, steps)
- [ ] User journey (quick start → common tasks → advanced)
- [ ] Reference needs (complete command list, all endpoints, etc.)

## Conclusion

Selecting the right pattern helps:
- Organize content effectively
- Apply appropriate structure
- Follow best practices
- Create efficient skills

Match the pattern to your documentation type for best results.
