---
name: document-summarizer
description: Summarize long documents with key points and abstracts. Use when creating executive summaries or condensing content.
---

# Document Summarizer Skill

ドキュメント要約スキルは、長文のドキュメントを効率的に要約し、重要なポイントを抽出します。

## 概要

このスキルを使用すると、技術文書、ビジネスレポート、学術論文、コードドキュメントなど、様々な種類のドキュメントを自動的に要約できます。要約レベルや出力形式を柔軟に指定可能です。

## 主な機能

- **多様なドキュメント形式**: Markdown、PDF、テキスト、HTML、コードファイル
- **要約レベル選択**: 要点のみ/標準/詳細の3段階
- **柔軟な出力形式**: 箇条書き、段落形式、エグゼクティブサマリー、Q&A形式
- **ドキュメントタイプ別最適化**: 技術文書、ビジネス文書、学術論文、コードに対応
- **キーポイント抽出**: 重要な情報を自動的にハイライト
- **セクション別要約**: 長文を章ごとに分割して要約
- **多言語対応**: 日本語、英語、その他の言語
- **HTMLレポート生成**: 美しくフォーマットされた要約レポート

## 使用方法

### 基本的な使い方

```
以下の技術文書を要約してください：
[ドキュメントの内容を貼り付け]

要約レベル: 標準
出力形式: 箇条書き
```

### ファイルからの要約

```
README.mdファイルを要約してください。
要約レベル: 要点のみ
ハイライト: インストール手順、主要機能
```

### 詳細な要約指定

```
以下のビジネスレポートを要約:
- ドキュメントタイプ: ビジネスレポート
- 要約レベル: 詳細
- 出力形式: エグゼクティブサマリー + 箇条書き
- 焦点: 財務データ、市場分析、推奨事項
- 対象読者: 経営陣
```

## ドキュメントタイプ

### 1. 技術文書 (Technical Documentation)

**特徴**:
- API仕様、技術マニュアル、アーキテクチャドキュメント
- コード例、設定手順、トラブルシューティング

**要約内容**:
- 主要な技術仕様
- システム要件
- インストール/設定手順の概要
- 重要なAPI/関数
- 既知の問題と制限事項

**例**:
```
Dockerドキュメントを要約:
- 焦点: コンテナの基本概念、主要コマンド
- 含める: ベストプラクティス、セキュリティ考慮事項
- 除外: 詳細なCLIリファレンス
```

### 2. ビジネス文書 (Business Documents)

**特徴**:
- レポート、プレゼンテーション、提案書
- 財務諸表、マーケティング資料

**要約内容**:
- エグゼクティブサマリー
- 主要な発見事項
- 財務ハイライト
- 推奨事項とアクションアイテム
- リスクと機会

**例**:
```
四半期レポートを要約:
- エグゼクティブサマリー: 1段落
- 財務ハイライト: 主要指標のみ
- 市場動向: 3-5ポイント
- 今後の施策: アクションアイテムリスト
```

### 3. 学術論文 (Academic Papers)

**特徴**:
- 研究論文、学術記事、論文

**要約内容**:
- 研究目的・背景
- 方法論
- 主要な発見
- 結論
- 今後の研究方向

**例**:
```
機械学習に関する論文を要約:
構造:
1. 研究の背景と目的
2. 提案手法の概要
3. 実験結果の要点
4. 主要な貢献
5. 制限事項と今後の課題
```

### 4. コードドキュメント (Code Documentation)

**特徴**:
- READMEファイル、API仕様、コードコメント

**要約内容**:
- プロジェクト概要
- インストール手順
- 主要機能
- 使用例
- ライセンスと貢献方法

**例**:
```
GitHubリポジトリのREADMEを要約:
- プロジェクトの目的
- クイックスタート手順
- 主要機能（3-5項目）
- ライセンス情報
```

### 5. 法律・契約文書 (Legal Documents)

**特徴**:
- 契約書、利用規約、プライバシーポリシー

**要約内容**:
- 主要な権利と義務
- 重要な条項
- 制限事項
- データ取り扱い
- 解約・終了条件

**注意**: 法律的な判断は専門家に確認してください。

### 6. ニュース記事 (News Articles)

**特徴**:
- ニュース、ブログ記事、プレスリリース

**要約内容**:
- 主要な出来事（5W1H）
- 重要な引用
- 影響と意義
- 背景情報

## 要約レベル

### レベル1: 要点のみ (Brief)

**特徴**:
- 最も簡潔な要約
- 2-5個の箇条書き
- 読了時間: 30秒以内

**用途**:
- 素早く全体像を把握
- エグゼクティブサマリー
- メール・チャットでの共有

**例**:
```
要約レベル: 要点のみ
出力:
• プロジェクトAの進捗は計画より2週間遅延
• 予算超過はなし、品質基準は達成
• 来月末までに納品予定
```

### レベル2: 標準 (Standard)

**特徴**:
- バランスの取れた要約
- 1-3段落 または 5-10個の箇条書き
- 読了時間: 2-3分

**用途**:
- 一般的な要約
- レポート作成
- チーム共有

**例**:
```
要約レベル: 標準
出力:
## 概要
プロジェクトAは現在、当初計画より2週間の遅延が発生しています。
主な原因は...

## 主要なポイント
• 進捗状況: 75%完了（目標: 90%）
• 予算: 計画内で推移
• 品質: すべてのテストケースをパス
...
```

### レベル3: 詳細 (Detailed)

**特徴**:
- 包括的な要約
- 複数セクション、詳細な箇条書き
- 読了時間: 5-10分

**用途**:
- 深い理解が必要な場合
- ドキュメント代替
- アーカイブ・参照用

**例**:
```
要約レベル: 詳細
出力:
## エグゼクティブサマリー
[包括的な概要]

## プロジェクト背景
[詳細な背景情報]

## 進捗状況
[詳細な進捗レポート]

## 主要な課題と対応策
[課題ごとの詳細分析]

## 今後の計画
[ステップバイステップの計画]

## リスクと緩和策
[リスク分析]
```

## 出力形式

### 1. 箇条書き (Bullet Points)

**特徴**:
- 簡潔で読みやすい
- 階層構造で整理
- スキャン可能

**例**:
```
## 主要なポイント

• **システムアーキテクチャ**
  - マイクロサービス構成
  - Kubernetes上で稼働
  - 99.9%のSLA

• **技術スタック**
  - バックエンド: Node.js, Python
  - フロントエンド: React, TypeScript
  - データベース: PostgreSQL, Redis

• **デプロイメント**
  - CI/CD: GitHub Actions
  - 自動テスト: Jest, Pytest
  - モニタリング: Prometheus, Grafana
```

### 2. 段落形式 (Paragraph)

**特徴**:
- 文章として読みやすい
- 詳細な説明に適している
- レポートスタイル

**例**:
```
本システムは、マイクロサービスアーキテクチャを採用しており、
Kubernetes上で稼働しています。99.9%のSLAを保証し、
高可用性と拡張性を実現しています。

技術スタックとしては、バックエンドにNode.jsとPythonを使用し、
フロントエンドはReactとTypeScriptで構築されています。
データベースはPostgreSQLとRedisを組み合わせて使用しています。
```

### 3. エグゼクティブサマリー (Executive Summary)

**特徴**:
- ビジネス向け
- 主要な発見事項と推奨事項
- 意思決定者向け

**例**:
```
## エグゼクティブサマリー

### 主要な発見
2024年Q1の売上は前年比15%増加し、目標を5%上回りました。
新規顧客獲得数は過去最高を記録し、顧客満足度も向上しています。

### 推奨事項
1. モバイルアプリへの投資を増額（ROI 3.5倍の見込み）
2. カスタマーサポートチームを20%拡大
3. アジア市場への展開を加速

### 今後の課題
競合他社の新製品発表に対応する必要があります。
第2四半期中に新機能をリリースすることを推奨します。
```

### 4. Q&A形式 (Question & Answer)

**特徴**:
- 理解しやすい
- FAQスタイル
- 特定の質問に答える

**例**:
```
## よくある質問

**Q: このシステムの主な目的は何ですか？**
A: 顧客データを一元管理し、マーケティング施策を最適化することです。

**Q: どのような技術を使用していますか？**
A: クラウドネイティブな技術スタックで、Kubernetes、Node.js、
   PostgreSQLなどを使用しています。

**Q: セキュリティはどのように確保されていますか？**
A: エンドツーエンドの暗号化、定期的な脆弱性スキャン、
   SOC 2 Type II準拠により、高いセキュリティを実現しています。
```

### 5. 比較表 (Comparison Table)

**特徴**:
- 視覚的に比較しやすい
- 選択肢の評価に最適

**例**:
```
## 提案の比較

| 項目 | 案A | 案B | 案C |
|------|-----|-----|-----|
| コスト | ¥500万 | ¥300万 | ¥400万 |
| 期間 | 3ヶ月 | 6ヶ月 | 4ヶ月 |
| リスク | 低 | 中 | 低 |
| ROI | 高 | 中 | 高 |
| 推奨度 | ★★★ | ★★ | ★★★ |
```

## 特殊な要約タイプ

### コード要約

**対象**:
- ソースコードファイル
- GitHubリポジトリ
- コードレビュー

**要約内容**:
- コードの目的と機能
- 主要なクラス/関数
- 依存関係
- 設計パターン
- 改善提案

**例**:
```
以下のPythonコードを要約:
[コードを貼り付け]

要約内容:
• 目的: ユーザー認証システム
• 主要クラス: User, AuthManager, TokenValidator
• 使用技術: JWT, bcrypt, SQLAlchemy
• セキュリティ機能: パスワードハッシュ化、トークン有効期限
• 改善提案: レート制限の追加、多要素認証の実装
```

### 会議議事録要約

**対象**:
- 会議の書き起こし
- 議事録
- チャットログ

**要約内容**:
- 主要な議題
- 決定事項
- アクションアイテム（担当者、期限）
- 未解決の課題

**例**:
```
会議議事録を要約:
日時: 2024-06-15
参加者: [リスト]
議題: Q2レビューと計画

要約:
## 決定事項
• 新機能Aは7月末リリース（担当: 田中）
• マーケティング予算を20%増額
• 月次レビューミーティングを隔週に変更

## アクションアイテム
- [ ] 要件定義書作成（佐藤、6/20まで）
- [ ] デザインモックアップ（鈴木、6/25まで）
- [ ] 競合分析レポート（山田、7/1まで）

## 未解決事項
• 価格戦略の最終決定（次回会議で継続）
```

### 複数ドキュメントの統合要約

**用途**:
- 複数の関連文書をまとめる
- 比較分析
- 統合レポート

**例**:
```
以下の3つのレポートを統合して要約:
1. 技術レポート
2. ビジネスレポート
3. ユーザーフィードバック

統合要約:
## 全体概要
[3つのレポートを横断した総合的な視点]

## 技術的視点
[技術レポートからの主要ポイント]

## ビジネス視点
[ビジネスレポートからの主要ポイント]

## ユーザー視点
[ユーザーフィードバックからの主要ポイント]

## 統合的な推奨事項
[すべての視点を考慮した提案]
```

## カスタマイズオプション

### 焦点の指定

```
特定のトピックに焦点を当てた要約:
- 焦点: セキュリティ、パフォーマンス
- 除外: 歴史的背景、詳細な実装
```

### 対象読者の指定

```
対象読者に合わせた要約:
- 対象: 非技術者の経営陣
- トーン: ビジネス用語、専門用語は説明付き
- 焦点: ROI、ビジネスインパクト
```

### 長さの指定

```
文字数/語数制限:
- 最大文字数: 500文字
- または: 最大5つの箇条書き
```

## HTMLレポート生成

要約結果を美しくフォーマットされたHTMLレポートとして出力できます。

**機能**:
- プロフェッショナルなデザイン
- 印刷最適化
- セクション別の色分け
- 重要度のハイライト
- エクスポート可能

**例**:
```
HTMLレポート形式で要約を生成:
- タイトル: "2024年Q2技術レポート要約"
- テーマ: プロフェッショナル（青系）
- セクション: エグゼクティブサマリー、技術詳細、推奨事項
- 含める: 目次、ページ番号、作成日時
```

## ユースケース

### 1. 長文ドキュメントの素早い理解

```
400ページの技術仕様書を要約:
要約レベル: 標準
焦点: システム要件、APIエンドポイント、セキュリティ
出力: 10ページ程度の要約ドキュメント
```

### 2. 会議前の資料予習

```
明日の会議資料（3つのPDF）を要約:
要約レベル: 要点のみ
出力: 会議前に5分で読める箇条書き
```

### 3. 複数の論文レビュー

```
同じトピックの学術論文5本を要約・比較:
各論文: 要点のみ（2-3ポイント）
最後に: 共通点と相違点の分析
```

### 4. プロジェクトドキュメントの更新

```
1年前の設計書を要約し、現状と比較:
要約: 当初の設計意図、主要な決定事項
比較: 現在の実装との差分
出力: ギャップ分析レポート
```

### 5. コードベースの理解

```
初めて見るリポジトリのREADMEとコードを要約:
要約内容:
• プロジェクトの目的
• アーキテクチャ概要
• セットアップ手順
• 主要なコンポーネント
• 開発開始に必要な情報
```

## ベストプラクティス

### 1. 適切な要約レベルの選択

- **緊急度が高い** → 要点のみ
- **一般的な理解** → 標準
- **詳細な分析** → 詳細

### 2. コンテキストの提供

要約時に以下を指定すると精度が向上:
- ドキュメントの種類
- 対象読者
- 使用目的
- 重要な焦点

### 3. 複数の出力形式を組み合わせ

```
エグゼクティブサマリー（1段落）
+ 箇条書き（主要ポイント5つ）
+ アクションアイテムリスト
```

### 4. 要約の検証

生成された要約を元のドキュメントと照合し、
重要な情報が漏れていないか確認してください。

## 制限事項

- 非常に専門的な分野（医療、法律など）の要約は専門家による確認が必要
- 数式や図表の多いドキュメントは要約の精度が下がる可能性
- 多言語混在ドキュメントは主要言語で要約
- 暗号化されたPDFは事前に復号化が必要

## バージョン情報

- スキルバージョン: 1.0.0
- 対応言語: 日本語、英語、その他

---

**使用例:**

```
以下の技術ドキュメントを要約してください：
[ドキュメント内容]

要約レベル: 標準
出力形式: 箇条書き
焦点: インストール手順、主要機能、トラブルシューティング
対象読者: 開発者
```

このプロンプトで、構造化された要約が生成されます！
