# DSR Project: [Project Name]

**Start Date:** [YYYY-MM-DD]
**Status:** [Planning | In Progress | Evaluation | Complete]
**Entry Point:** [Problem-Centered | Objective-Centered | Design-Centered | Client-Centered]

---

## Activity 1: Problem Identification & Motivation

### Problem Statement
[Clear, concise statement of the problem - 1-2 sentences]

### Importance
[Why does this matter? Include quantitative data if available]

### Stakeholders
| Stakeholder | Impact | Priority |
|-------------|--------|----------|
| [who] | [how affected] | [high/medium/low] |

### Current State Analysis
**How is this currently handled?**
[Description of current approaches]

**Limitations of current approaches:**
- [ ] [Limitation 1]
- [ ] [Limitation 2]
- [ ] [Limitation 3]

### Consequences of Not Solving
[What happens if this problem persists?]

---

## Activity 2: Objectives of Solution

### Ideal Solution Description
[What would success look like?]

### Success Criteria

| Criterion | Metric | Target | Priority |
|-----------|--------|--------|----------|
| [what] | [how measured] | [threshold] | [must/should/could] |

### Constraints

| Type | Constraint | Impact |
|------|------------|--------|
| Technical | [constraint] | [how it limits design] |
| Resource | [constraint] | [how it limits design] |
| Time | [constraint] | [how it limits design] |

### Non-Goals
[What are we explicitly NOT trying to achieve?]
- [ ] [Non-goal 1]
- [ ] [Non-goal 2]

---

## Activity 3: Design & Development

### Artifact Type
- [ ] Construct (vocabulary, concepts)
- [ ] Model (abstraction, representation)
- [ ] Method (algorithm, process)
- [ ] Instantiation (working system)

### Architecture Overview
```
[Diagram or description of high-level architecture]
```

### Components

| Component | Purpose | Interface |
|-----------|---------|-----------|
| [name] | [what it does] | [how to use it] |

### Design Decisions

| Decision | Choice | Rationale | Alternatives Considered |
|----------|--------|-----------|------------------------|
| [topic] | [what was decided] | [why] | [what else was considered] |

### Theoretical Foundation
[What theories, prior work, or research inform this design?]

### Implementation Notes
[Technical details relevant to building the artifact]

---

## Activity 4: Demonstration

### Demonstration Method
- [ ] Proof of Concept
- [ ] Case Study
- [ ] Simulation
- [ ] Experiment

### Context
[Where/how is the artifact being demonstrated?]

### Scenarios

#### Scenario 1: [Name]
**Input:** [what goes in]
**Process:** [what happens]
**Expected Output:** [what should come out]
**Actual Output:** [what actually happened]

### Observations
[What did we observe during demonstration?]

### Artifacts Produced
| Artifact | Type | Location |
|----------|------|----------|
| [name] | [type] | [path/url] |

---

## Activity 5: Evaluation

### Evaluation Method
- [ ] Observational (Case Study / Field Study)
- [ ] Analytical (Static / Architecture Analysis)
- [ ] Experimental (Controlled / Simulation)
- [ ] Testing (Functional / Structural)
- [ ] Descriptive (Argument / Scenarios)

### Evaluation Criteria

| Criterion | Weight | Definition | Measurement | Threshold |
|-----------|--------|------------|-------------|-----------|
| [name] | [0-1] | [what it measures] | [how] | [success level] |

### Results

| Criterion | Score | Evidence | Pass? |
|-----------|-------|----------|-------|
| [name] | [value] | [data] | [Y/N] |

### Analysis
[Interpretation of results - what do they mean?]

### Limitations
[What are the limitations of this evaluation?]

### Suggested Improvements
Based on evaluation, these improvements are recommended:
1. [Improvement 1]
2. [Improvement 2]

---

## Activity 6: Communication

### Target Audiences

| Audience | Key Message | Format | Status |
|----------|-------------|--------|--------|
| [who] | [main takeaway] | [paper/doc/talk] | [done/pending] |

### Contribution Type
- [ ] Artifact Contribution (novel solution)
- [ ] Foundation Contribution (new constructs/models/methods)
- [ ] Methodology Contribution (evaluation methods/metrics)

### Published Artifacts

| Artifact | Location | Audience |
|----------|----------|----------|
| [what] | [where] | [for whom] |

### Reproducibility Notes
[How can others reproduce or build on this work?]

---

## Hevner's Guidelines Compliance

| # | Guideline | Status | Evidence |
|---|-----------|--------|----------|
| 1 | Design as Artifact | [ ] | [reference] |
| 2 | Problem Relevance | [ ] | [reference] |
| 3 | Design Evaluation | [ ] | [reference] |
| 4 | Research Contributions | [ ] | [reference] |
| 5 | Research Rigor | [ ] | [reference] |
| 6 | Design as Search | [ ] | [reference] |
| 7 | Communication | [ ] | [reference] |

---

## Iteration Log

| Date | Activity | Changes | Reason |
|------|----------|---------|--------|
| [date] | [1-6] | [what changed] | [why] |

---

## References

[List relevant papers, tools, prior work]

---

*Template based on DSRM (Peffers et al., 2007) and Hevner's Guidelines (2004)*
