# ECIR Analysis Reference Guide

This document explains the metrics, insights, and analysis outputs generated by the ECIR Report Analyzer.

## Analysis Components

### Header Metrics

Extracted from the Header sheet of ECIR reports:

- **ecir_id**: Unique identifier for the ECIR
- **title**: Descriptive title of the change
- **date_generated**: When the ECIR was created
- **originator**: Person or department who created the ECIR
- **status**: Workflow status (Draft, Approved, etc.)
- **affected_models**: Building models impacted by changes
- **affected_categories**: Material categories with changes
- **total_items**: Total number of items in comparison
- **changed_items**: Number of items with changes
- **unchanged_items**: Number of items without changes
- **change_reason**: Code describing why change occurred
- **justification**: Narrative explanation of change
- **plan_old/plan_new**: Plan set identifiers before/after
- **supplier_old/supplier_new**: Supplier changes
- **overhead_pct/profit_pct**: O&P percentages used
- **direct_cost_old/new**: Direct material costs
- **direct_variance_dollars/pct**: Direct cost change
- **total_with_op_old/new**: Costs including O&P
- **total_with_op_variance_dollars/pct**: Total cost change with O&P

### Status Distribution

Breakdown of how items changed:

- **Added**: Items in AFTER but not BEFORE
- **Deleted**: Items in BEFORE but not AFTER
- **Modified-Spec**: Description/specification changed (substitution)
- **Modified-Qty**: Only quantity changed
- **Modified-Cost**: Only unit cost changed
- **Modified-Qty+Cost**: Both quantity and cost changed
- **Unchanged**: No changes detected

### Category Impacts

Analysis by material category:

- **top_cost_increases**: Categories with largest cost increases
- **top_cost_decreases**: Categories with largest cost decreases
- **categories_with_most_items**: Categories with most line items
- **total_categories**: Number of categories affected

### Outliers

Items with unusually large variances:

- **top_dollar_variances**: Items with largest absolute $ changes
- **top_percentage_variances**: Items with largest % changes

## Insight Types

### ⚠️ Major Cost Impact

Triggered when direct cost variance exceeds ±5%

Example: "Major cost impact: Direct costs increased by 7.3% ($12,456.78)"

### ✓ Minor Cost Impact

Triggered when direct cost variance is under ±5%

Example: "Minor cost impact: Direct costs changed by 2.1%"

### 📝 High Specification Change Rate

Triggered when >30% of items have Modified-Spec status

Example: "High specification change rate: 42.3% of items had spec changes (substitutions)"

Indicates extensive product substitutions or material changes.

### ➕ Significant Scope Increase

Triggered when >20% of items are Added

Example: "Significant scope increase: 25.6% of items were added"

Indicates expanding project scope.

### ➖ Significant Scope Reduction

Triggered when >20% of items are Deleted

Example: "Significant scope reduction: 31.2% of items were deleted"

Indicates reducing project scope or value engineering.

### 📊 Largest Cost Increase

Highlights the category with the biggest cost increase

Example: "Largest cost increase in Glulams: $8,234.56 (18.7%)"

### 🔍 Change Reason

Reports the reason code for the engineering change

Example: "Change reason: Supplier_Change"

## Trend Analysis Metrics

When analyzing multiple ECIRs:

### Cost Variance Statistics

- **mean_dollars**: Average $ variance across all ECIRs
- **median_dollars**: Median $ variance (less affected by outliers)
- **min/max_dollars**: Range of variances
- **mean_pct**: Average % variance

### Change Reasons Frequency

Counts how often each change reason appears across ECIRs.

Common reasons:
- Supplier_Change
- Engineering_Update
- Code_Compliance
- Cost_Reduction
- Material_Availability

### Status Distribution Aggregate

Total counts of each status type across all ECIRs analyzed.

Helps identify if certain change types are more common organizationally.

### Supplier Changes

Tracks supplier transitions across ECIRs.

Useful for identifying:
- Frequent supplier switches
- Preferred vendors
- Supplier reliability issues

### High Variance ECIRs

ECIRs with cost variance exceeding 5%.

These warrant closer review and stakeholder attention.

## Interpretation Guidelines

### When to Investigate Further

1. **Variance >10%**: Significant cost impact requiring executive review
2. **Modified-Spec >50%**: Extensive substitutions may indicate systemic issue
3. **Added >30%**: Major scope increase, check for scope creep
4. **Multiple High-Variance ECIRs**: Pattern may indicate estimation or planning issues

### Healthy Patterns

1. **Variance 0-3%**: Normal engineering refinement
2. **Modified-Qty dominates**: Quantity adjustments are expected
3. **Consistent change reasons**: Indicates controlled change process
4. **Few outliers**: Most changes are moderate and expected

### Warning Signs

1. **Frequent Supplier_Change**: May indicate vendor management issues
2. **Many "Deleted" items**: Possible over-estimation in original plans
3. **High variance without clear justification**: Needs investigation
4. **Recurring high-variance categories**: Systematic estimation problem

## Usage Patterns

### Single ECIR Analysis

Use `analyze_ecir.py` to:
- Understand cost impact of specific engineering change
- Identify which categories drove variance
- Find items needing review
- Generate executive summary

### Multi-ECIR Trend Analysis

Use `compare_ecirs.py` to:
- Track variance trends over time
- Identify systemic patterns
- Benchmark current ECIR against historical data
- Find recurring issues

### Pattern Recognition

Look for:
- Same categories repeatedly high-variance
- Consistent change reasons (process improvement opportunity)
- Supplier patterns (vendor performance)
- Seasonal trends (material availability)

## Example Workflow

### Workflow 1: Monthly ECIR Review

1. Run `compare_ecirs.py` on all ECIRs from past month
2. Review high variance ECIRs (>5%)
3. Check change reason distribution
4. Identify any new patterns
5. Share insights with estimating team

### Workflow 2: Quarterly Business Review

1. Run trend analysis on all ECIRs from quarter
2. Calculate total cost variance impact
3. Identify top 3 categories by variance
4. Review supplier change frequency
5. Present findings to executives

### Workflow 3: Continuous Improvement

1. Analyze ECIRs after each major project
2. Compare actual vs estimated variance
3. Build pattern library of common changes
4. Update estimation models
5. Train team on recurring patterns

## Integration with Learning-First Platform

This analyzer lays groundwork for:

1. **Mastery Tracking**: Compare estimator predictions vs actual analysis
2. **Adaptive Questioning**: Ask estimators to predict patterns before revealing
3. **Pattern Library**: Catalog common change types with examples
4. **Skill Development**: Track which change types estimators struggle with

Future enhancements could include:
- Predictive modeling of cost impacts
- Automatic classification of change reasons
- Real-time variance alerts
- Integration with BAT systems for automatic triggering
