---
name: "Education Verification"
description: "Verify educational credentials, degrees, and academic history"
allowed-tools:
  - src.tools.education_verify
---

# Education Verification

## Purpose

Verify educational credentials, degrees, certifications, and academic history for background checks, professional qualifications, and compliance screening.

## When to Use

- Executive and key personnel background verification
- Professional credential validation for regulated roles
- Due diligence on individuals claiming specific qualifications
- Fraud investigation involving educational claims
- Compliance checks for positions requiring specific degrees
- Verification of professional certifications and licenses
- Academic background screening for expert witness qualification
- Investigation of diploma mills or fraudulent credentials

## How to Use

The education verification tool validates academic credentials through:

- **Degree Verification**: Institution, degree type, graduation date, GPA
- **Institution Validation**: Accreditation status and legitimacy
- **Professional Certifications**: CPA, CFA, medical licenses, etc.
- **Academic Records**: Transcripts, honors, disciplinary actions
- **Continuing Education**: Professional development, recertification
- **International Credentials**: Foreign degree recognition and equivalency

## Examples

**Executive background check:**
```
Subject: Sarah Johnson, proposed Chief Medical Officer
Verification: MD from Johns Hopkins, residency completion, board certifications
Compliance: Medical license status across multiple states
```

**Professional qualification screening:**
```
Individual: Proposed CFO candidate
Requirements: CPA certification, MBA from accredited institution
Investigation: Verify active CPA license and educational background
```

**Fraud investigation:**
```
Subject: Individual claiming Harvard MBA
Investigation: No record found at claimed institution
Evidence: Document false credentials for disciplinary action
```

**Regulatory compliance:**
```
Role: Bank compliance officer position
Requirements: Law degree and relevant certifications
Verification: JD verification, bar admission status, AML certifications
```

## Important Notes

- Educational privacy laws (FERPA in US) may limit information access
- Obtain proper authorization from subject before verification attempts
- International degree verification can be complex and time-consuming
- Some institutions have specific verification procedures and fees
- Professional certifications often have online verification systems
- Be aware of diploma mills and unaccredited institutions
- Consider degree equivalency for international qualifications
- Verify both institution accreditation and individual graduation
- Document verification attempts thoroughly for compliance records