# Word Analysis Protocol

> **"Breaking down new words using Elster's methodology"**
> **"Pattern recognition > Isolated memorization"**

## When to Use This Protocol

**New word from Verbal Advantage:**
- Sid pastes word + definition
- Atlas breaks down systematically
- Captures to vocab.md if arsenal-worthy

**Goal:** Not just learn ONE word, but recognize PATTERNS that unlock many words

## The 6-Step Analysis Protocol

### Step 1: Show Hindi Instinct vs American Reality

**Always start here - this prevents the mistake BEFORE it happens**

**Format:**
```
**WORD** (pronunciation)

**Hindi instinct:**
- [How Sid would naturally say it based on Hindi pronunciation]
- [Why this feels natural - clear vowels, even syllables]

**American reality:**
- [Correct pronunciation with stress marking]
- [Which syllables compress/reduce]
```

**Example:**
```
**OMNIPOTENT** (ahm-NIP-uh-tint)

**Hindi instinct:**
- om-ni-PO-tent (clear "o" sounds, stress on third syllable)
- Pronounce vowels fully, equal weight to all syllables

**American reality:**
- ahm-**NIP**-uh-tint (4 catches: om→ahm, stress NIP, po→uh, tent→tint)
- Heavy stress on NIP → other syllables compress naturally
```

**Why this works:**
- Catches the error before practice
- Shows WHY Hindi instinct is wrong (not just "that's wrong")
- Makes American pronunciation logical, not arbitrary

### Step 2: Identify Pattern Match

**Connect to known patterns from cheat sheet:**

**Check against:**
- omni- prefix?
- -ant/-ate/-ent suffix?
- re- prefix?
- Unstressed o/u/a vowels?
- Final -us ending?

**Format:**
```
**Pattern:** [Which pattern from cheat sheet]
**Example:** [Show how pattern applies to THIS word]
```

**Example:**
```
**Pattern:** omni- prefix → ahm-ni (unlocks entire family)
**Example:** om-ni-PO-tent becomes ahm-**NIP**-uh-tint
- om → ahm (prefix pattern)
- Stress falls on NIP (second syllable)
- Then normal reductions apply
```

**If NEW pattern discovered:**
- Document it clearly
- Show 2-3 other words that follow same pattern
- Add to cheat sheet in vocab.md

### Step 3: Pronunciation Breakdown with Anchors

**Break word into syllables with familiar anchors:**

**Format:**
```
**Pronunciation breakdown:**
- [Syllable 1] (like "[familiar word]")
- [Syllable 2] (like "[familiar word]", STRESS HERE)
- [Syllable 3] (swallow it)
```

**Example:**
```
**Pronunciation breakdown:**
- ahm (like "am" with "h")
- **NIP** (like "nip" - PUNCH THIS)
- uh (barely there)
- tint (like "tint")
```

**Anchors that work well:**
- Rhymes: "like 'fly'" for PLY-
- Common words: "like 'are'" for AHR-
- Physical: "swallow it", "barely there", "compress naturally"

### Step 4: Usage from Sid's Life

**Create 2-3 usage examples in Sid's context:**

**Contexts that work:**
- ARR/revenue milestones
- Demos with contractors
- VC/investor interactions
- Founder journey
- Immigration/visa experience
- Raw Writer identity
- Community building (H1B founders)

**Format:**
```
**Usage (Sid's life):**
- "[Sentence using word in context 1]"
- "[Sentence using word in context 2]"
- "[Sentence using word in context 3]"
```

**Example:**
```
**Usage (Sid's life):**
- "VCs think they're omnipotent - until bootstrapped founders hit $3M ARR"
- "Immigration system acts omnipotent - I cracked it anyway"
- "Tech gurus position as omnipotent - I ship with manifold skills instead"
```

**Why this matters:**
- Makes vocabulary immediately useful
- Connects to real experiences
- Builds practitioner arsenal (not academic collection)

### Step 5: Raw Writer Weapon

**How does this word serve the Raw Writer identity?**

**Questions to answer:**
- Does it attack performers/virtue signaling?
- Does it express practitioner truth?
- Does it cut sharper than common words?
- Does it have weight in conversations?

**Format:**
```
**Raw Writer weapon:**
- [How this word attacks performance culture]
- [Practitioner vs performer application]
- [Why this is sharper than alternatives]
```

**Example:**
```
**Raw Writer weapon:**
- Perfect for attacking false authority figures
- "They perform omnipotence while I practice competence"
- Sharper than "powerful" - has gravitas in writing
```

### Step 6: Opposite Words + Related Family

**Show contrasts and connections:**

**Format:**
```
**Opposite:** [Contrasting words]
**Related:** [Word family if applicable]
**Teacher's insight:** [Pattern observation]
```

**Example:**
```
**Opposite:** powerless, impotent, weak

**Related (omni- family):**
- OMNIPRESENT (AHM-ni-PREZ-int) - present everywhere
- OMNISCIENT (ahm-NISH-int) - all-knowing
- OMNIVOROUS (ahm-NIV-uh-rus) - eating everything

**Teacher's insight:** Whenever you see "omni-" you know meaning AND pronunciation
```

**Why this matters:**
- Opposites clarify meaning
- Families unlock 10x words
- Teacher's insights = meta-learning

## The Denotation/Connotation Framework

**This explains WHY our protocol captures both definitions AND practitioner examples**

| Term | Meaning | In Our Protocol |
|------|---------|-----------------|
| **DENOTATION** | Precise, explicit meaning (dictionary definition) | Step 1-3: Pronunciation, pattern, meaning |
| **CONNOTATION** | Implied meaning, overtones, emotions | Step 4-5: Usage examples, Raw Writer weapon |

**Theodore Bernstein's distinction:** "Denote means, connote implies"

**Why both matter:**
- Knowing **denotation** = use word with precision and clarity
- Grasping **connotation** = use word with sensitivity, wit, or power
- Dictionary definitions stick chiefly to denotation
- Connotation is what we build through practitioner examples

**Example:**
```
LACERATE

DENOTATION (what we capture):
- To tear, cut roughly, mangle
- Figurative: wound, afflict

CONNOTATION (what we build):
- "My writing lacerates performance culture"
  - Implies: necessary pain, surgical precision
  - Overtones: healer who cuts to heal
  - Emotions: fierce honesty, no coddling
  - Power: visceral, physical quality
```

**This is why Steps 4-5 are critical:**
- Step 4 (Usage) builds connotation through context
- Step 5 (Raw Writer) builds connotation through intention
- Without these, word is academic not weaponized
- WITH these, word is fully owned for speech AND writing

**The principle:**
> "We capture denotation in definitions, build connotation in practitioner examples. Both together = full word ownership."

---

## Arsenal Decision Criteria

**After analysis, decide: Add to arsenal?**

**YES if:**
- Sharper than common word (CREDULOUS > gullible)
- Perfect for attacking performers/virtue signaling
- Has weight in conversations/demos (sounds educated)
- Pronunciation you want to OWN
- Unlocks word family (teaching value)

**NO if:**
- Common word Sid already uses naturally
- Too academic/rare for practical use
- No clear practitioner application
- Pattern already well-represented in arsenal

**Example YES:**
- OMNIPOTENT (unlocks omni- family + attacks false authority)
- PLIANT (pronunciation pattern + practitioner flexibility concept)

**Example NO:**
- UNSCRUPULOUS (known word, no new pattern, "unethical" works fine)

## Quick Reference Format

**When Sid says: "Atlas, break down [WORD]"**

**Atlas provides:**
1. Hindi instinct vs American reality
2. Pattern identification
3. Pronunciation breakdown with anchors
4. Usage from Sid's life (3 examples)
5. Raw Writer weapon angle
6. Opposite words + Related family

**Then asks:**
"Should I add this to the arsenal?"

**If yes:**
- Format for vocab.md
- Update progress tracker
- Note any new patterns discovered

## Example: Full Analysis

**Sid:** "Atlas, break down LACERATE"

**Atlas:**

**LACERATE** (LAS-uh-rayt)

**Hindi instinct:**
- la-CER-ate (clear vowels, stress on middle)
- Would pronounce each syllable distinctly

**American reality:**
- **LAS**-uh-rayt (stress FIRST heavily)
- Middle vowel completely reduces to "uh"
- When you PUNCH LAS, the "uh" vanishes naturally

**Pattern:** Unstressed middle vowel → "uh" sound (standard reduction)

**Pronunciation breakdown:**
- **LAS** (like "lass" - PUNCH THIS)
- uh (swallow it - barely audible)
- rayt (like "rate")

**Meaning:**
- Literal: Tear, cut roughly, mangle
- Figurative: Wound, afflict, cause pain

**Usage (Sid's life):**
- "Truth lacerates fake gurus - they can't handle direct feedback"
- "I don't coddle - my feedback lacerates ego but builds skill"
- "Her husband's vicious retort lacerated her pride" (figurative wound)

**Raw Writer weapon:**
- Perfect for describing harsh but necessary criticism
- "My writing lacerates performance culture - not to destroy, but to cut away the fake"
- Practitioner vs performer: "Real feedback lacerates. Fake mentors comfort."
- Sharper than "criticize" or "attack" - has visceral, physical quality

**Opposite:** soothe, heal, comfort

**Teacher's insight:** The figurative use (emotional wounds) is as powerful as literal use - expands vocabulary range for Raw Writer

---

Should I add LACERATE to the arsenal?

**Decision:** YES - Strong Raw Writer weapon, visceral metaphor, perfect for attacking gentle/coddling culture

[Adds to vocab.md with full formatting]

---

## Success Metrics

**Good analysis:**
- [ ] Prevents Hindi instinct error
- [ ] Connects to known pattern (or documents new one)
- [ ] Provides familiar anchors
- [ ] Shows 3 real usage examples from Sid's life
- [ ] Identifies Raw Writer application
- [ ] Teaches word family if applicable
- [ ] Makes arsenal decision clear

**Sid's test:**
- Pronunciation feels learnable (not overwhelming)
- Usage examples are quotable (actually would say this)
- Arsenal decision makes sense (not arbitrary)

---

*"Pattern recognition > Isolated memorization"*
*"Every word analysis = Teaching moment for families, not just single entries"*
