# Pronunciation Arsenal (Current Weapons)

> **"27 weapons captured - growing arsenal for writing, speaking, demos"**
> **Progress: Level 1 COMPLETE (50 words, 24 weapons) + Level 2 STARTED (3 words, 3 weapons)**

## How to Use This Arsenal

- Highlight PDF as main learning (keep doing that)
- Extract SPECIAL words here (weapons for writing/speaking)
- Format: **WORD** (pronunciation) - why it matters
- Practice with pronunciation drills (see drills/ directory)

## Progress Tracker

- **Level 1: Words 1-50** ✅ COMPLETE (Day 53: 24 weapons captured)
- **Level 2: Words 1-100** 🚀 STARTED (Day 54: 3 weapons captured)
- **27 arsenal weapons operational**
- **2 pronunciation drills created** ("The Practitioner" + "The Sovereign Builder")
- **3 major breakthroughs** (Stress-timing + Diphthong mastery + Diphthong targeting)

## Arsenal Words (Day 52 - Nov 3, 2025)

### OSTENSIBLE (ah-STEN-si-bul) - Word 2
- Apparent, seeming, professed - may or may not be true
- Pronunciation key: ah-STEN (like "sten gun"), si-bul
- Usage: "Their ostensible reason for the call vs what they really want"
- Raw Writer: "Ostensible 'thought leaders' with no actual revenue"

### CONGENIAL (kun-JEE-nee-ul) - Word 10
- Agreeable, pleasant, friendly, sympathetic
- Pronunciation key: kun-JEE (like "congee"), nee-ul
- Usage: "Found congenial founders in H1B community"
- Opposite: disagreeable, unpleasant, hostile

### CAPRICIOUS (kuh-PRISH-us) - Word 11
- Unpredictable, impulsive, subject to whim, erratic
- Pronunciation key: kuh-PRISH (like "precious" with cap-), us
- Usage: "Capricious immigration policy changes"
- Opposite: steady, consistent, predictable

### PRECOCIOUSNESS (pruh-KOH-shus-nis) - Word 19
- Unusually advanced or mature at early age
- First systematic extraction

### CREDULOUS (KREJ-uh-lus)
- Too ready to believe, gullible, easily deceived
- Usage: "credulous founders buying courses"
- Opposite: skeptical, discerning, shrewd

### PEEVISH (PEE-vish)
- Irritable, easily annoyed, complaining
- Usage: "peevish energy on Hacker News"
- Opposite: cheerful, good-natured

### ARDUOUS (AHR-joo-us)
- Very difficult, requiring great effort, laborious, strenuous
- Pronunciation key: AHR (like "are"), joo (like "jewel" without L"), us
- Usage: "arduous climb to $3M ARR"
- Opposite: easy, effortless, simple

### SUPPOSITION (SUHP-uh-ZISH-in) - Word 27 [NUANCED TRIO]
- An assumption, theory, hypothesis - may be based on ample or no evidence

**Related words (master the distinctions):**

**HYPOTHESIS** (hy-PAHTH-uh-sis, plural: hy-PAHTH-uh-seez)
- Preliminary/incomplete theory based on insufficient evidence
- Usage: "VCs operate on hypothesis about market size"

**CONJECTURE** (kun-JEK-chur)
- Assumption based on very little evidence, educated guess
- Usage: "Twitter threads full of conjecture about my business model"

**SUPPOSITION** - the broadest term
- Can be sensible or irrational, evidence-based or baseless
- Usage: "Their suppositions about bootstrapping proved wrong at $3M ARR"

**Practitioner distinction**: Use the RIGHT word for precision
- Weak evidence? Conjecture
- Preliminary theory? Hypothesis
- General assumption? Supposition

**Raw Writer weapon**: "Tech Twitter runs on conjecture while I ship on data"

### REALTOR (REE-ul-tur) - Word 30
- Real estate broker (trademarked term, capital R)
- Pronunciation key: REE-ul (like "real"), tur (like "turnip")
- **Common mistake**: REE-luh-tur (wrong - l sound in wrong place)
- **Practice phrase**: "A Realtor sells realty" (REE-ul-tur, REE-ul-tee)
- **Why critical**: You do demos with contractors/real estate pros
- Getting this right = instant credibility in demos

### VERBIAGE (VUR-bee-ij) - 3 syllables
- Unnecessary words, wordiness, redundancy
- **The metaphor**: "Like going on a diet - shed unwanted pounds"
- **Raw Writer connection**: This IS your editing philosophy
- "Edit to SHARPEN, not polish" = cutting verbiage
- Usage: "Cut the verbiage, keep the punch"
- **Verbal Advantage quote**: "When you shed those unwanted words, you feel better and look better"

### MANIFOLD (MAN-i-fohld) - Word 31
- Numerous AND varied - not just "many" but emphasizes diversity/variety
- Pronunciation key: MAN (like "man"), i (short "ih"), fohld (like "fold")
- Stress on FIRST syllable: **MAN**-i-fohld
- Usage: "Building to $3M ARR required manifold skills - sales, coding, ops, customer success, not just 'focus on one thing' bullshit"
- Raw Writer weapon: Perfect for attacking "niche down" and "focus on one thing" advice
- Practitioner truth: "These gurus say 'pick one thing' while running manifold revenue streams"
- Opposite: singular, uniform, simple, monolithic
- Related: **multifarious** (MUHL-ti-FAIR-ee-us), **multitudinous** (MUHL-ti-T(Y)OO-di-nus)
- 🔑 Hindi pattern note: The middle "i" stays as "ih" sound (NOT reduced to "uh") - exception to the "uh" replacement rule

### PLIANT (PLY-int) - Word 32 [MAJOR PRONUNCIATION PATTERN]
- Flexible, bendable, adaptable, easily influenced
- Pronunciation key: PLY (like "fly"), int (like "lint" - NOT "ant")
- **CRITICAL CATCH**: Hindi instinct = PLY-ant (clear "a"), American = PLY-int (reduced vowel)
- **🔑 MAJOR "-ant" SUFFIX PATTERN**: Endings like "-ant" often become "-int" sound in American English
- Usage: "Credulous founders are too pliant - believe every guru's pitch"
- Raw Writer weapon: "Tech Twitter stays rigid while successful founders stay pliant"
- Practitioner truth: "I stayed pliant through visa changes, pivots, market shifts"
- Opposite: rigid, inflexible, stubborn, obstinate

### RETORT (ri-TORT) - Word 33
- Sharp reply, quick comeback, witty response
- ri (swallow it), TORT (stress here)
- **Pattern**: "re-" prefix → "ri-" sound (not "ree")
- Usage: "When VCs question bootstrapping, I retort with $3M ARR receipts"
- Raw Writer: "I don't debate - I retort with proof"

### OBSTINATE (AHB-sti-nit) - Word 34
- Stubborn, refusing to change, inflexible
- AHB (not "ob"), sti, nit (not "nate")
- **Pattern**: "-nate" → "-nit" (same as "-ant" → "-int")
- Usage: "VCs obstinate about 'growth at all costs' - I'm obstinate about profitability"
- Raw Writer: "I'm obstinate about shipping, not theorizing"
- Opposite: pliant (perfect pair)

### LACERATE (LAS-uh-rayt) - Word 35
- Tear/cut roughly (literal); wound/afflict (figurative)
- LAS, uh (swallow), rayt - stress on FIRST
- Usage: "Truth lacerates fake gurus - they can't handle direct feedback"
- Raw Writer: "My writing lacerates performance culture - cuts away the fake"
- Opposite: soothe, heal, comfort

### OMNIPOTENT (ahm-NIP-uh-tint) - Word 36 [UNLOCKS ENTIRE "OMNI-" FAMILY]
- All-powerful, having unlimited power (potent = powerful, omni- = all)
- **4 catches**: (1) om→ahm (2) stress on NIP (3) po→uh (vanishes) (4) tent→tint
- Hindi instinct: om-ni-PO-tent | American: ahm-**NIP**-uh-tint

**🎓 The "omni-" family** (all follow same pattern: om→ahm, then normal reductions):
- OMNIPRESENT (AHM-ni-PREZ-int) - present everywhere (note: -ent→-int)
- OMNISCIENT (ahm-NISH-int) - all-knowing ("scient" vanishes to NISH)
- OMNIVOROUS (ahm-NIV-uh-rus) - eating everything (middle o→uh)

**Teacher's insight**: Whenever you see "omni-" you know meaning AND pronunciation

Usage: "VCs think they're omnipotent - until bootstrapped founders hit $3M ARR"
Raw Writer: "They perform omnipotence while I practice competence"

### URBANE (ur-BAYN) - Word 45 [THE DIPHTHONG BREAKTHROUGH]
- Sophisticated, polished, refined in manner (from "urban" - city sophistication)
- **Pronunciation:** ur (like "her" without h) + **BAYN** (PUNCH THIS - the "ay" diphthong)

**🎉 BREAKTHROUGH MOMENT**: Finally grokked what a diphthong IS

**Hindi instinct**: ur-BANE (flat "eh" like "cane" - single vowel)
**American reality**: ur-**BAYN** (gliding vowel - **ah → ay → ee**)

**The discovery**: "ah → ay → ee - I sounds EXACTLY how I hear Americans!"
**The validation**: "Feel unnatural to my mouth - BUT MY EARS - that's MUSIC!"

**Why it clicked**: Visual representation (ah → ay → ee) made the sound LEARNABLE - couldn't grok it from hearing alone

**The spectrum discovered**:
- Too flat (Hindi) = "eh" BANE ❌
- Just right (American) = "ah-ay-ee" BAYN ✅
- Too long (Kiwi) = "ah-aay-eee" BAAYN (overshoot)

**Teacher's insight**: "When ears say YES but mouth says WEIRD - you're learning correctly. Trust the ears. The mouth will follow."

**Pattern unlocked**: Every "-ane" word (insane, humane, profane), every "-ain" word (rain, main, gain), every "-ay" word (day, may, say)

**Usage**: "VCs perform urbane sophistication - I ship with founder grit"

**Raw Writer weapon**: Perfect for attacking performers - "Urbane LinkedIn presence while I close $3M ARR deals"

**Opposite**: crude, unsophisticated, rough, provincial

**Related refinement words**:
- SUAVE (SWAHV) - smoothly agreeable (often too smooth - salesman vibes)
- DEBONAIR (deb-uh-NAIR) - sophisticated charm
- COSMOPOLITAN (kahz-muh-PAHL-i-tn) - worldly, traveled

## Level 2 Arsenal (Day 54 - Nov 5, 2025)

### ADVOCATE (AD-vuh-kayt) - Word 1 [ETYMOLOGY UNLOCK]
- Support, plead for, defend by argument
- **Etymology:** Latin **vocare** = to call, summon (unlocks 8-word family)
- **Word family:** EVOKE, CONVOKE, VOCATION, AVOCATION, VOCAL, EVOCATIVE, CONVOCATION
- **Elster's method:** ONE root → PREFIX combinations → instant word family mastery
- Usage: "I'm an advocate for bootstrapped founders - vocal about profitability over VC fantasy"
- Raw Writer: "I advocate for revenue-first building while Twitter advocates for fundraising"
- Why arsenal-worthy: Practitioner word + demonstrates etymology teaching pattern

### POIGNANT (POYN-yint) - Word 4 [THREE MEANINGS + "OI" DIPHTHONG]
- Piercing, sharp, biting, penetrating, keen (three ways: senses/emotions/intellect)
- **"Oi" diphthong:** Different from -ane/-ain (glide WITHIN syllable, not at end)
- **Three meanings:**
  1. Keenly affecting senses: poignant odor, beauty, look
  2. Piercing feelings: emotionally touching - poignant drama, reunion
  3. Biting, intellectually cutting: poignant wit, critique
- **Etymology:** French (silent g) ← Latin **pungere** = to pierce, prick
- **Word family:** PUNCTURE, PUNGENT, EXPUNGE
- Usage: "Poignant critique of tech performative culture - cuts through noise"
- Raw Writer: "Poignant observations about build-in-public theater vs actual building"
- Why arsenal-worthy: Three-way precision tool (senses/emotions/intellect) + pronunciation challenge

### CLANDESTINE (klan-DES-tin) - Word 6 [SYNONYM CASCADE]
- Kept secret for evil/immoral/illegal purpose (moral weight)
- **Pronunciation trap:** Middle stressed (klan-**DES**-tin, NOT **CLAN**-des-tine)
- **Synonym cascade (9 levels):** PRIVATE → CONCEALED → COVERT → UNDERHAND → SLY → STEALTHY → FURTIVE → SURREPTITIOUS → **CLANDESTINE**
- **Nuance:** Not just "secret" - implies WRONGDOING (affair, illegal deal, intelligence op)
- **Elster's teaching:** Synonym cascades show progressive precision (not interchangeable synonyms)
- Usage: "Clandestine VC term sheets designed to trap founders in predatory deals"
- Raw Writer: "Immigration lawyers' clandestine fee structures - hidden costs until committed"
- Why arsenal-worthy: Exposes immoral secrecy + synonym precision demonstration

---

## Arsenal Categories

**For attacking performers/virtue signaling:**
- OSTENSIBLE, CREDULOUS, OMNIPOTENT, LACERATE, RETORT, URBANE, POIGNANT

**For practitioner identity:**
- MANIFOLD, PLIANT, OBSTINATE, ARDUOUS, ADVOCATE

**For precision/nuance:**
- SUPPOSITION trio (hypothesis, conjecture, supposition)
- VERBIAGE (editing philosophy)
- POIGNANT (three-way precision: senses/emotions/intellect)
- CLANDESTINE (moral weight in secrecy)

**For professional credibility:**
- REALTOR (demos with contractors)
- CONGENIAL (community building)
- ADVOCATE (practitioner word with word family)

**For exposing predatory practices:**
- CLANDESTINE (immoral secrecy - VCs, immigration lawyers)
- UNSCRUPULOUS (predatory term sheets)

**Word families unlocked (etymology teaching):**
- **vocare family** (ADVOCATE): EVOKE, CONVOKE, VOCATION, AVOCATION, VOCAL, EVOCATIVE, CONVOCATION
- **pungere family** (POIGNANT): PUNCTURE, PUNGENT, EXPUNGE
- **omni- family** (OMNIPOTENT): OMNIPRESENT, OMNISCIENT, OMNIVOROUS

---

*"27 weapons operational - pronunciation mastery + writing arsenal + etymology patterns"*
*"Use with pronunciation drills (The Practitioner + The Sovereign Builder) for compound learning"*
*"Day 53: Level 1 COMPLETE - Stress-timing + Diphthong mastery breakthroughs"*
*"Day 54: Level 2 LAUNCHED - Diphthong targeting + Etymology teaching + Synonym cascades"*
