---
name: email-anti-slop
description: Prevent generic AI-generated email aesthetics and enforce distinctive, handcrafted design quality. Use when generating HTML emails, email templates, newsletters, marketing emails, or any email content. Ensures emails look professionally designed, not machine-generated. Applies anti-pattern detection and distinctive design requirements.
---

# Email Anti-Slop Design Enforcer

Every email must look handcrafted by a skilled designer, never algorithmically generated. This skill enforces design quality through explicit anti-patterns and required distinctive elements.

## The Core Problem

AI-generated emails converge toward statistical averages—the "safest" choices that satisfy no one and delight no one. These patterns instantly reveal an email as AI-made:

## NEVER USE - Typography Sins

- NO: Arial, Helvetica, Verdana as the ONLY font (no personality)
- NO: Same font weight throughout (no hierarchy)
- NO: Generic 14px body / 24px headline (no drama)
- NO: System font stacks without personality
- NO: All caps for body text

**INSTEAD:** Create typographic drama within email-safe constraints:
- Georgia + Arial pairing (elegant + clean)
- Trebuchet MS for friendly/modern headers
- Size jumps: 32px+ headlines vs 14-16px body (2x+ ratio)
- Strategic bold/light weight contrast in headlines
- Letter-spacing for sophistication in headers

## NEVER USE - Color Sins

- NO: Plain white (#ffffff) background with pastel cards
- NO: Blue-to-purple gradients (most overused AI pattern)
- NO: Generic corporate blue (#0066CC, #007bff)
- NO: Washed-out pastels with no contrast
- NO: Gray-on-gray boring neutrals (#f5f5f5, #e5e5e5 everywhere)
- NO: Pink-to-orange sunset gradients

**INSTEAD:** Commit to a bold, memorable palette:
- One dominant brand color used confidently
- High-contrast accent for CTAs
- Either dark mode elegant OR warm/rich backgrounds
- Solid color blocks, not wimpy gradients
- Background colors that create sections (not all white)

## NEVER USE - Layout Sins

- NO: Predictable hero → 3-column features → CTA flow
- NO: Everything centered with identical padding
- NO: Same section structure repeated (card, card, card)
- NO: Equal-width columns for everything
- NO: Cookie-cutter spacing (all 20px padding)

**INSTEAD:** Create visual interest within table constraints:
- Asymmetric content placement (image left, text right offset)
- Varied section background colors
- One oversized hero element
- Generous OR tight spacing—never medium
- Full-width impact sections between contained content

## NEVER USE - Content Sins

- NO: "Dear Valued Customer"
- NO: "Click here to learn more"
- NO: Stock photo placeholder vibes
- NO: Buzzword copy ("leverage", "synergy", "innovative")
- NO: Generic CTAs ("Submit", "Learn More", "Get Started")

**INSTEAD:** Personality-driven content:
- Direct address with context
- Specific, benefit-focused CTAs ("See My Order", "Start Writing")
- Copy that sounds like a human wrote it
- Headlines that would work as tweets

## Required: The Memorable Element

Before finalizing ANY email, identify the ONE thing recipients will remember. If nothing specific, add one:

**For Email:**
- An unexpected hero color block
- A bold typographic treatment on the main headline
- An asymmetric image/text layout
- A distinctive CTA button style (not rounded-everything)
- A unique section divider or accent

**Ask:** "What will someone remember 5 minutes after seeing this email?"

## Aesthetic Directions (Choose ONE)

Match to brand/industry. Execute with conviction:

| Direction | Characteristics | Good For |
|-----------|-----------------|----------|
| **Minimal Refined** | Extreme whitespace, subtle details, muted palette, elegant restraint | Finance, Legal, Luxury |
| **Dark Elegant** | Deep backgrounds (#1a1a1a), luminous accents, sophisticated shadows | Tech, SaaS, Creative |
| **Warm Organic** | Earthy tones (terracotta, sage, cream), soft divisions | Wellness, Food, Lifestyle |
| **Bold Editorial** | High contrast, serif headlines, magazine-like, strong hierarchy | Media, Publishing, Fashion |
| **Playful Bright** | Primary colors, friendly, energetic, clear sections | Consumer, Kids, Entertainment |
| **Tech Modern** | Monospace accents, dark themes, cyan/green accents | Developer, Cybersecurity, Startup |

## Pre-Output Checklist

Before generating email HTML:

- Did I choose ONE clear aesthetic direction?
- Is there ONE memorable design element?
- Are colors bold and intentional (not washed out)?
- Is there clear typographic hierarchy (2x+ size difference)?
- Does the layout have asymmetry or variation?
- Would a human designer be proud of this?
- Does this look different from a default template?

If any answer is "no," revise before output.
