---
name: Email Composer
slug: email-composer
description: Draft professional, well-structured emails for any business context
category: communication
complexity: simple
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "draft email"
  - "write email"
  - "compose email"
  - "email template"
tags:
  - email
  - professional-communication
  - business-writing
---

# Email Composer

The Email Composer skill helps you craft professional, effective emails for any business context. Whether you need to reach out to a client, respond to a team inquiry, follow up on a meeting, or send a cold outreach message, this skill ensures your emails are clear, appropriately toned, and action-oriented.

This skill analyzes the context you provide and generates emails that match the appropriate level of formality, include necessary components (subject line, greeting, body, call-to-action, closing), and maintain professional standards. It can adapt tone from casual internal communications to formal external correspondence.

The skill also considers email best practices like brevity, clarity, scannable structure, and clear next steps to maximize response rates and effectiveness.

## Core Workflows

### Workflow 1: Draft New Email
1. **Gather Context**: Understand the purpose, recipient, and key points
2. **Determine Tone**: Assess formality level (casual, professional, formal)
3. **Structure Email**: Create subject line, opening, body paragraphs, CTA, closing
4. **Review & Refine**: Check for clarity, conciseness, and appropriate tone
5. **Deliver**: Present complete email ready to send

### Workflow 2: Reply to Email Thread
1. **Review Thread**: Analyze previous messages for context
2. **Identify Key Points**: Extract questions or items requiring response
3. **Craft Response**: Address all points systematically
4. **Maintain Thread**: Preserve relevant context while staying concise
5. **Close Loop**: Ensure all items are addressed with clear next steps

### Workflow 3: Email Template Creation
1. **Identify Use Case**: Understand the recurring scenario
2. **Define Variables**: Mark customizable sections
3. **Create Template**: Build reusable structure
4. **Add Guidelines**: Include usage notes and customization tips
5. **Test & Validate**: Review with example content

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Draft new email | "Draft email to [recipient] about [topic]" |
| Reply to thread | "Write reply to [sender] addressing [points]" |
| Cold outreach | "Compose cold email to [prospect] for [purpose]" |
| Follow-up email | "Write follow-up on [topic] from [date/meeting]" |
| Thank you email | "Draft thank you email for [reason]" |
| Internal update | "Write team email about [update/announcement]" |
| Create template | "Create email template for [use case]" |
| Adjust tone | "Make this more [formal/casual/friendly]" |

## Email Types Supported

- **Cold Outreach**: First contact with prospects or partners
- **Follow-ups**: After meetings, proposals, or previous emails
- **Internal Updates**: Team announcements and status reports
- **Client Communication**: Professional updates and responses
- **Thank You Notes**: Appreciation and acknowledgment
- **Meeting Requests**: Scheduling and coordination
- **Introductions**: Connecting people or introducing services
- **Apologies**: Professional handling of mistakes or delays
- **Requests**: Asking for information, time, or resources
- **Confirmations**: Acknowledging receipt or confirming details

## Best Practices

- **Subject Lines**: Keep under 50 characters, make them specific and actionable
- **Opening**: Personalize when possible, reference previous interactions
- **Body Structure**: Use short paragraphs (2-3 sentences max), bullet points for lists
- **One Main Point**: Each email should have one primary purpose
- **Clear CTA**: End with specific next step or call-to-action
- **Appropriate Length**: Aim for under 200 words for most business emails
- **Professional Tone**: Match recipient's communication style while staying professional
- **Proofread**: Check for typos, grammar, and clarity before sending
- **Timing**: Consider time zones and optimal send times
- **Mobile-Friendly**: Format should be easily readable on mobile devices

## Tone Guidelines

| Context | Tone | Example Opening |
|---------|------|-----------------|
| Cold Outreach | Professional, Value-focused | "I noticed your work on [X] and wanted to reach out..." |
| Internal Team | Casual, Clear | "Quick update on the project..." |
| Client Communication | Professional, Helpful | "Thank you for your message regarding..." |
| Executive Communication | Formal, Concise | "Per our discussion on [topic]..." |
| Follow-up | Friendly, Persistent | "I wanted to circle back on..." |
| Apology | Humble, Solution-oriented | "I apologize for the confusion regarding..." |

## Common Pitfalls to Avoid

- **Too Long**: Emails over 300 words rarely get fully read
- **Buried Lede**: Put the main point in the first paragraph
- **No Clear Ask**: Always end with what you need from recipient
- **Generic Greetings**: Personalize when possible
- **Over-Apologizing**: One sincere apology is enough
- **Reply-All Abuse**: Only use when truly necessary
- **Vague Subject**: Be specific about email content
- **Missing Context**: Don't assume recipient remembers previous conversations

## Usage Examples

### Example 1: Cold Outreach
```
Subject: Quick question about [Company]'s content strategy

Hi [Name],

I came across your recent article on [topic] and was impressed by your approach to [specific point].

I'm reaching out because we've developed a tool that helps companies like [Company] streamline their content workflow. I'd love to show you how [specific benefit relevant to their work].

Would you be open to a quick 15-minute call next week to explore this?

Best regards,
[Your name]
```

### Example 2: Internal Update
```
Subject: Design sprint update - Week of Jan 6

Team,

Quick update on our progress:

✅ Completed: User research interviews (12/12)
🏃 In progress: Wireframe iterations for checkout flow
📅 Next: Prototype testing scheduled for Thursday

Blocker: Still waiting on API specs from backend team.

Let me know if you have questions.

[Your name]
```

### Example 3: Follow-up Email
```
Subject: Following up - Partnership discussion

Hi [Name],

I wanted to follow up on our conversation from last Tuesday about the potential partnership between our companies.

As discussed, I've attached the proposal outlining our integration timeline and resource requirements. The key highlights:

• Go-live target: March 15, 2026
• Estimated setup time: 2-3 weeks
• Monthly cost: $X,XXX

Are you available for a brief call this week to discuss next steps?

Thanks,
[Your name]
```

## Integration Points

- **CRM Systems**: Draft emails based on contact records and interaction history
- **Calendar**: Include meeting links and availability
- **Task Management**: Reference tickets, projects, or action items
- **Templates Library**: Build and maintain reusable templates
- **Analytics**: Track open rates and response rates to improve effectiveness
